/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.adapter;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.adapter.AdapterFactoryProxy;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;

public final class AdapterManagerListener
implements IRegistryEventListener,
IAdapterManagerProvider {
    public static final String ADAPTER_POINT_ID = "org.eclipse.core.runtime.adapters";
    private AdapterManager theAdapterManager = AdapterManager.getDefault();

    public AdapterManagerListener() {
        this.theAdapterManager.registerLazyFactoryProvider((IAdapterManagerProvider)this);
    }

    public boolean addFactories(AdapterManager adapterManager) {
        IExtensionPoint iExtensionPoint = RegistryFactory.getRegistry().getExtensionPoint(ADAPTER_POINT_ID);
        if (iExtensionPoint == null) {
            return false;
        }
        boolean bl = false;
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                AdapterFactoryProxy adapterFactoryProxy = AdapterFactoryProxy.createProxy(iConfigurationElementArray[n2]);
                if (adapterFactoryProxy != null) {
                    adapterManager.registerFactory((IAdapterFactory)adapterFactoryProxy, adapterFactoryProxy.getAdaptableType());
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        RegistryFactory.getRegistry().addListener(this, ADAPTER_POINT_ID);
        return bl;
    }

    private void registerExtension(IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            AdapterFactoryProxy adapterFactoryProxy = AdapterFactoryProxy.createProxy(iConfigurationElementArray[n]);
            if (adapterFactoryProxy != null) {
                this.theAdapterManager.registerFactory((IAdapterFactory)adapterFactoryProxy, adapterFactoryProxy.getAdaptableType());
            }
            ++n;
        }
    }

    public synchronized void added(IExtension[] iExtensionArray) {
        int n = 0;
        while (n < iExtensionArray.length) {
            this.registerExtension(iExtensionArray[n]);
            ++n;
        }
        this.theAdapterManager.flushLookup();
    }

    public synchronized void removed(IExtension[] iExtensionArray) {
        this.theAdapterManager.flushLookup();
        int n = 0;
        while (n < iExtensionArray.length) {
            Iterator iterator = this.theAdapterManager.getFactories().values().iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    IAdapterFactory iAdapterFactory = (IAdapterFactory)iterator2.next();
                    if (!(iAdapterFactory instanceof AdapterFactoryProxy) || !((AdapterFactoryProxy)iAdapterFactory).originatesFrom(iExtensionArray[n])) continue;
                    iterator2.remove();
                }
            }
            ++n;
        }
    }

    public synchronized void added(IExtensionPoint[] iExtensionPointArray) {
    }

    public synchronized void removed(IExtensionPoint[] iExtensionPointArray) {
    }

    public synchronized void stop() {
        RegistryFactory.getRegistry().removeListener(this);
    }
}

