/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.preferences.BundleDefaultPreferences;
import org.eclipse.core.internal.preferences.ConfigurationPreferences;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.preferences.InstancePreferences;
import org.eclipse.core.internal.preferences.LookupOrder;
import org.eclipse.core.internal.preferences.PreferenceServiceRegistryHelper;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.preferences.StringPool;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.core.runtime.preferences.PreferenceModifyListener;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService {
    private static final long STRING_SHARING_INTERVAL = 300000L;
    private static final String MATCH_TYPE_PREFIX = "prefix";
    private static String[] DEFAULT_DEFAULT_LOOKUP_ORDER = new String[]{"instance", "configuration", "default"};
    private static final char EXPORT_ROOT_PREFIX = '!';
    private static final char BUNDLE_VERSION_PREFIX = '@';
    private static final float EXPORT_VERSION = 3.0f;
    private static final String VERSION_KEY = "file_export_version";
    private static final String EMPTY_STRING = "";
    private static PreferencesService instance;
    static final RootPreferences root;
    private static final Map defaultsRegistry;
    private Object registryHelper = null;
    private Map defaultScopes = new HashMap();
    private long lastStringSharing = 0L;

    static {
        root = new RootPreferences();
        defaultsRegistry = Collections.synchronizedMap(new HashMap());
    }

    private static IStatus createStatusError(String string, Exception exception) {
        return new Status(4, "org.eclipse.equinox.preferences", 4, string, (Throwable)exception);
    }

    public static PreferencesService getDefault() {
        if (instance == null) {
            instance = new PreferencesService();
        }
        return instance;
    }

    static void log(IStatus iStatus) {
        RuntimeLog.log((IStatus)iStatus);
    }

    PreferencesService() {
        this.initializeDefaultScopes();
    }

    public void applyPreferences(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray) throws CoreException {
        if (iPreferenceFilterArray == null || iPreferenceFilterArray.length == 0) {
            return;
        }
        try {
            this.internalApply(iEclipsePreferences, iPreferenceFilterArray);
            try {
                this.getRootNode().node(iEclipsePreferences.absolutePath()).flush();
            }
            catch (BackingStoreException backingStoreException) {
                throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_saveProblems, backingStoreException));
            }
            this.lastStringSharing = 0L;
            this.shareStrings();
        }
        catch (BackingStoreException backingStoreException) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_applyProblems, backingStoreException));
        }
    }

    public IStatus applyPreferences(IExportedPreferences iExportedPreferences) throws CoreException {
        if (iExportedPreferences == null) {
            throw new IllegalArgumentException();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Applying exported preferences: " + ((ExportedPreferences)iExportedPreferences).toDeepDebugString());
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.preferences", 0, PrefsMessages.preferences_applyProblems, null);
        IEclipsePreferences iEclipsePreferences = this.firePreApplyEvent(iExportedPreferences);
        IPreferenceNodeVisitor iPreferenceNodeVisitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
                IEclipsePreferences iEclipsePreferences2 = iEclipsePreferences.parent() == null ? root : (IEclipsePreferences)root.node(iEclipsePreferences.absolutePath());
                ExportedPreferences exportedPreferences = (ExportedPreferences)iEclipsePreferences;
                boolean bl = false;
                if (exportedPreferences.isExportRoot()) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        PrefsMessages.message("Found export root: " + exportedPreferences.absolutePath());
                    }
                    iEclipsePreferences2.removeNode();
                    bl = true;
                }
                String[] stringArray = exportedPreferences.properties.keys();
                if (bl) {
                    iEclipsePreferences2 = (IEclipsePreferences)root.node(iEclipsePreferences.absolutePath());
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < iEclipsePreferences2.keys().length) {
                    arrayList.add(iEclipsePreferences2.keys()[n]);
                    ++n;
                }
                if (stringArray.length > 0) {
                    String string = null;
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        string = stringArray[n2];
                        arrayList.remove(string);
                        string = string.intern();
                        String string2 = iEclipsePreferences.get(string, null);
                        if (string2 != null) {
                            if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                                PrefsMessages.message("Setting: " + iEclipsePreferences2.absolutePath() + '/' + string + '=' + string2);
                            }
                            iEclipsePreferences2.put(string, string2);
                        }
                        ++n2;
                    }
                }
                String string = null;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    string = string.intern();
                    if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                        PrefsMessages.message("Removing: " + iEclipsePreferences2.absolutePath() + '/' + string);
                    }
                    iEclipsePreferences2.remove(string);
                }
                return true;
            }
        };
        try {
            iEclipsePreferences.accept(iPreferenceNodeVisitor);
        }
        catch (BackingStoreException backingStoreException) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_applyProblems, backingStoreException));
        }
        try {
            this.getRootNode().node(iEclipsePreferences.absolutePath()).flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_saveProblems, backingStoreException));
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Current list of all settings: " + ((EclipsePreferences)this.getRootNode()).toDeepDebugString());
        }
        this.lastStringSharing = 0L;
        this.shareStrings();
        return multiStatus;
    }

    private boolean containsKeys(IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
        final boolean[] blArray = new boolean[1];
        IPreferenceNodeVisitor iPreferenceNodeVisitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
                if (iEclipsePreferences.keys().length != 0) {
                    blArray[0] = true;
                }
                return !blArray[0];
            }
        };
        iEclipsePreferences.accept(iPreferenceNodeVisitor);
        return blArray[0];
    }

    private Properties convertFromLegacy(Properties properties) {
        Properties properties2 = new Properties();
        String string = "/instance/";
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            int n = string2.indexOf(47);
            if (n == -1) {
                properties2.put(String.valueOf('@') + string2, string3);
                properties2.put(String.valueOf('!') + string + string2, EMPTY_STRING);
                continue;
            }
            String string4 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            properties2.put(EclipsePreferences.encodePath(String.valueOf(string) + string4, string2), string3);
        }
        return properties2;
    }

    private IExportedPreferences convertFromProperties(Properties properties) {
        IExportedPreferences iExportedPreferences = ExportedPreferences.newRoot();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            if (string.charAt(0) == '!') {
                object = (String[])iExportedPreferences.node(string.substring(1));
                ((ExportedPreferences)object).setExportRoot();
                continue;
            }
            if (string.charAt(0) == '@') {
                object = (ExportedPreferences)iExportedPreferences.node("instance").node(string.substring(1));
                ((ExportedPreferences)object).setVersion(string2);
                continue;
            }
            object = EclipsePreferences.decodePath(string);
            string = object[0] == null ? EMPTY_STRING : object[0];
            ExportedPreferences exportedPreferences = (ExportedPreferences)iExportedPreferences.node(string);
            Object object2 = object[1];
            exportedPreferences.put((String)object2, string2);
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Converted preferences file to IExportedPreferences tree: " + ((ExportedPreferences)iExportedPreferences).toDeepDebugString());
        }
        return iExportedPreferences;
    }

    private Properties convertToProperties(IEclipsePreferences iEclipsePreferences, final String[] stringArray) throws BackingStoreException {
        final Properties properties = new Properties();
        final int n = iEclipsePreferences.absolutePath().length();
        IPreferenceNodeVisitor iPreferenceNodeVisitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
                String[] stringArray2;
                String string = iEclipsePreferences.absolutePath();
                String string2 = PreferencesService.this.getScope(string);
                if ("default".equals(string2)) {
                    return false;
                }
                String string3 = string.length() <= n ? PreferencesService.EMPTY_STRING : EclipsePreferences.makeRelative(string.substring(n));
                int n4 = 0;
                while (n4 < stringArray.length) {
                    stringArray2 = EclipsePreferences.makeRelative(stringArray[n4]);
                    if (string3.startsWith((String)stringArray2)) {
                        return false;
                    }
                    ++n4;
                }
                n4 = "instance".equals(string2) ? 1 : 0;
                stringArray2 = iEclipsePreferences.keys();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    String string4;
                    String string5 = stringArray2[n2];
                    boolean bl = false;
                    int n3 = 0;
                    while (!bl && n3 < stringArray.length) {
                        if (EclipsePreferences.encodePath(string3, string5).startsWith(EclipsePreferences.makeRelative(stringArray[n3]))) {
                            bl = true;
                        }
                        ++n3;
                    }
                    if (!bl && (string4 = iEclipsePreferences.get(string5, null)) != null) {
                        if (n4 != 0) {
                            String string6;
                            String string7 = PreferencesService.this.getBundleName(string);
                            if (string7 != null && (string6 = PreferencesService.this.getBundleVersion(string7)) != null) {
                                properties.put(String.valueOf('@') + string7, string6);
                            }
                            n4 = 0;
                        }
                        properties.put(EclipsePreferences.encodePath(string, string5), string4);
                    }
                    ++n2;
                }
                return true;
            }
        };
        iEclipsePreferences.accept(iPreferenceNodeVisitor);
        return properties;
    }

    void copyFromTo(Preferences preferences, Preferences preferences2, String[] stringArray, int n) throws BackingStoreException {
        String[] stringArray2 = stringArray == null ? preferences.keys() : stringArray;
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string = preferences.get(stringArray2[n2], null);
            if (string != null) {
                preferences2.put(stringArray2[n2], string);
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        String[] stringArray3 = preferences.childrenNames();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            this.copyFromTo(preferences.node(stringArray3[n3]), preferences2.node(stringArray3[n3]), stringArray, n);
            ++n3;
        }
    }

    public WeakReference applyRuntimeDefaults(String string, WeakReference weakReference) {
        if (this.registryHelper == null) {
            return null;
        }
        return ((PreferenceServiceRegistryHelper)this.registryHelper).applyRuntimeDefaults(string, weakReference);
    }

    private void initializeDefaultScopes() {
        this.defaultScopes.put("bundle_defaults", new BundleDefaultPreferences());
        root.addChild("bundle_defaults", null);
        this.defaultScopes.put("default", new DefaultPreferences());
        root.addChild("default", null);
        this.defaultScopes.put("instance", new InstancePreferences());
        root.addChild("instance", null);
        this.defaultScopes.put("configuration", new ConfigurationPreferences());
        root.addChild("configuration", null);
    }

    public IEclipsePreferences createNode(String string) {
        IScope iScope = (IScope)this.defaultScopes.get(string);
        if (iScope == null) {
            if (this.registryHelper == null) {
                return new EclipsePreferences(root, string);
            }
            return ((PreferenceServiceRegistryHelper)this.registryHelper).createNode(root, string);
        }
        return iScope.create(root, string);
    }

    public void exportPreferences(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray, OutputStream outputStream) throws CoreException {
        if (iPreferenceFilterArray == null || iPreferenceFilterArray.length == 0) {
            return;
        }
        try {
            this.internalExport(iEclipsePreferences, iPreferenceFilterArray, outputStream);
        }
        catch (BackingStoreException backingStoreException) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_exportProblems, backingStoreException));
        }
    }

    public IStatus exportPreferences(IEclipsePreferences iEclipsePreferences, OutputStream outputStream, String[] stringArray) throws CoreException {
        if (iEclipsePreferences == null || outputStream == null) {
            throw new IllegalArgumentException();
        }
        Properties properties = null;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        try {
            properties = this.convertToProperties(iEclipsePreferences, stringArray);
            if (properties.isEmpty()) {
                return Status.OK_STATUS;
            }
            properties.put(VERSION_KEY, Float.toString(3.0f));
            properties.put(String.valueOf('!') + iEclipsePreferences.absolutePath(), EMPTY_STRING);
        }
        catch (BackingStoreException backingStoreException) {
            throw new CoreException(PreferencesService.createStatusError(backingStoreException.getMessage(), backingStoreException));
        }
        try {
            properties.store(outputStream, null);
        }
        catch (IOException iOException) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_exportProblems, iOException));
        }
        return Status.OK_STATUS;
    }

    private IEclipsePreferences firePreApplyEvent(IEclipsePreferences iEclipsePreferences) {
        if (this.registryHelper == null) {
            return iEclipsePreferences;
        }
        final IEclipsePreferences[] iEclipsePreferencesArray = new IEclipsePreferences[]{iEclipsePreferences};
        PreferenceModifyListener[] preferenceModifyListenerArray = ((PreferenceServiceRegistryHelper)this.registryHelper).getModifyListeners();
        int n = 0;
        while (n < preferenceModifyListenerArray.length) {
            final PreferenceModifyListener preferenceModifyListener = preferenceModifyListenerArray[n];
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                }

                public void run() throws Exception {
                    iEclipsePreferencesArray[0] = preferenceModifyListener.preApply(iEclipsePreferencesArray[0]);
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            ++n;
        }
        return iEclipsePreferencesArray[0];
    }

    public String get(String string, String string2, Preferences[] preferencesArray) {
        if (preferencesArray == null) {
            return string2;
        }
        int n = 0;
        while (n < preferencesArray.length) {
            String string3;
            Preferences preferences = preferencesArray[n];
            if (preferences != null && (string3 = preferences.get(string, null)) != null) {
                return string3;
            }
            ++n;
        }
        return string2;
    }

    public boolean getBoolean(String string, String string2, boolean bl, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        return string3 == null ? bl : Boolean.valueOf(string3);
    }

    String getBundleName(String string) {
        if (string.length() == 0 || string.charAt(0) != '/') {
            return null;
        }
        int n = string.indexOf(47, 1);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(47, n + 1);
        return n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
    }

    String getBundleVersion(String string) {
        Object v;
        Bundle bundle = PreferencesOSGiUtils.getDefault().getBundle(string);
        if (bundle != null && (v = bundle.getHeaders(EMPTY_STRING).get("Bundle-Version")) != null && v instanceof String) {
            return (String)v;
        }
        return null;
    }

    public byte[] getByteArray(String string, String string2, byte[] byArray, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        return string3 == null ? byArray : Base64.decode(string3.getBytes());
    }

    public String[] getDefaultLookupOrder(String string, String string2) {
        LookupOrder lookupOrder = (LookupOrder)defaultsRegistry.get(this.getRegistryKey(string, string2));
        return lookupOrder == null ? null : lookupOrder.getOrder();
    }

    public double getDouble(String string, String string2, double d, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        if (string3 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public float getFloat(String string, String string2, float f, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        if (string3 == null) {
            return f;
        }
        try {
            return Float.parseFloat(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public int getInt(String string, String string2, int n, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        if (string3 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getLong(String string, String string2, long l, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        if (string3 == null) {
            return l;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public String[] getLookupOrder(String string, String string2) {
        String[] stringArray = this.getDefaultLookupOrder(string, string2);
        if (stringArray == null && string2 != null) {
            stringArray = this.getDefaultLookupOrder(string, null);
        }
        if (stringArray == null) {
            stringArray = DEFAULT_DEFAULT_LOOKUP_ORDER;
        }
        return stringArray;
    }

    private Preferences[] getNodes(final String string, String string2, final IScopeContext[] iScopeContextArray) {
        String[] stringArray = this.getLookupOrder(string, string2);
        final String string3 = EclipsePreferences.makeRelative(EclipsePreferences.decodePath(string2)[0]);
        final ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < stringArray.length) {
            final String string4 = stringArray[n];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    boolean bl = false;
                    int n = 0;
                    while (iScopeContextArray != null && n < iScopeContextArray.length) {
                        Preferences preferences;
                        IScopeContext iScopeContext = iScopeContextArray[n];
                        if (iScopeContext != null && iScopeContext.getName().equals(string4) && (preferences = iScopeContext.getNode(string)) != null) {
                            bl = true;
                            if (string3 != null) {
                                preferences = preferences.node(string3);
                            }
                            arrayList.add(preferences);
                        }
                        ++n;
                    }
                    if (!bl) {
                        Preferences preferences = PreferencesService.this.getRootNode().node(string4).node(string);
                        if (string3 != null) {
                            preferences = preferences.node(string3);
                        }
                        arrayList.add(preferences);
                    }
                    bl = false;
                }

                public void handleException(Throwable throwable) {
                    PreferencesService.log((IStatus)new Status(4, "org.eclipse.equinox.preferences", PrefsMessages.preferences_contextError, throwable));
                }
            });
            ++n;
        }
        return arrayList.toArray(new Preferences[arrayList.size()]);
    }

    private String getRegistryKey(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string2 == null) {
            return string;
        }
        return String.valueOf(string) + '/' + string2;
    }

    public IEclipsePreferences getRootNode() {
        return root;
    }

    String getScope(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY_STRING;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            return string;
        }
        if (string.length() == 1) {
            return EMPTY_STRING;
        }
        int n2 = string.indexOf(47, n + 1);
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(n + 1, n2);
    }

    public String getString(String string, String string2, String string3, IScopeContext[] iScopeContextArray) {
        return this.get(EclipsePreferences.decodePath(string2)[1], string3, this.getNodes(string, string2, iScopeContextArray));
    }

    public IStatus importPreferences(InputStream inputStream) throws CoreException {
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Importing preferences...");
        }
        return this.applyPreferences(this.readPreferences(inputStream));
    }

    private void internalApply(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray) throws BackingStoreException {
        ArrayList<IEclipsePreferences> arrayList = new ArrayList<IEclipsePreferences>();
        int n = 0;
        while (n < iPreferenceFilterArray.length) {
            arrayList.add(this.trimTree(iEclipsePreferences, iPreferenceFilterArray[n]));
            ++n;
        }
        IEclipsePreferences iEclipsePreferences2 = this.mergeTrees(arrayList.toArray(new IEclipsePreferences[arrayList.size()]));
        iEclipsePreferences2 = this.firePreApplyEvent(iEclipsePreferences2);
        IPreferenceNodeVisitor iPreferenceNodeVisitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
                String[] stringArray = iEclipsePreferences.keys();
                if (stringArray.length == 0) {
                    return true;
                }
                PreferencesService.this.copyFromTo(iEclipsePreferences, PreferencesService.this.getRootNode().node(iEclipsePreferences.absolutePath()), stringArray, 0);
                return true;
            }
        };
        iEclipsePreferences2.accept(iPreferenceNodeVisitor);
    }

    private void internalExport(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray, OutputStream outputStream) throws BackingStoreException, CoreException {
        ArrayList<IEclipsePreferences> arrayList = new ArrayList<IEclipsePreferences>();
        int n = 0;
        while (n < iPreferenceFilterArray.length) {
            arrayList.add(this.trimTree(iEclipsePreferences, iPreferenceFilterArray[n]));
            ++n;
        }
        IEclipsePreferences iEclipsePreferences2 = this.mergeTrees(arrayList.toArray(new IEclipsePreferences[arrayList.size()]));
        this.exportPreferences(iEclipsePreferences2, outputStream, null);
    }

    private boolean internalMatches(IEclipsePreferences iEclipsePreferences, IPreferenceFilter iPreferenceFilter) throws BackingStoreException {
        String[] stringArray = iPreferenceFilter.getScopes();
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        String string = iEclipsePreferences.absolutePath();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            Map map = iPreferenceFilter.getMapping(string2);
            if (map == null) {
                if (iEclipsePreferences.parent() == null && iEclipsePreferences.nodeExists(string2) && this.containsKeys((IEclipsePreferences)iEclipsePreferences.node(string2))) {
                    return true;
                }
                if (this.scopeMatches(string2, iEclipsePreferences) && this.containsKeys(iEclipsePreferences)) {
                    return true;
                }
            } else {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    PreferenceFilterEntry[] preferenceFilterEntryArray;
                    String string3 = (String)iterator.next();
                    String string4 = String.valueOf('/') + string2 + '/' + string3;
                    if (!string4.startsWith(string)) continue;
                    String string5 = string4.substring(string.length());
                    if (!iEclipsePreferences.nodeExists(string5 = EclipsePreferences.makeRelative(string5))) continue;
                    try {
                        preferenceFilterEntryArray = (PreferenceFilterEntry[])map.get(string3);
                    }
                    catch (ClassCastException classCastException) {
                        PreferencesService.log(PreferencesService.createStatusError(PrefsMessages.preferences_classCastFilterEntry, classCastException));
                        continue;
                    }
                    Preferences preferences = iEclipsePreferences.node(string5);
                    if (preferenceFilterEntryArray == null) {
                        if (preferences.keys().length == 0 && preferences.childrenNames().length == 0) continue;
                        return true;
                    }
                    int n2 = 0;
                    while (n2 < preferenceFilterEntryArray.length) {
                        if (preferenceFilterEntryArray[n2] != null && (preferenceFilterEntryArray[n2].getMatchType() == null ? preferences.get(preferenceFilterEntryArray[n2].getKey(), null) != null : this.internalMatchesWithMatchType(preferenceFilterEntryArray[n2], preferences.keys()))) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return false;
    }

    private IPreferenceFilter[] internalMatches(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray) throws BackingStoreException {
        ArrayList<IPreferenceFilter> arrayList = new ArrayList<IPreferenceFilter>();
        int n = 0;
        while (n < iPreferenceFilterArray.length) {
            if (this.internalMatches(iEclipsePreferences, iPreferenceFilterArray[n])) {
                arrayList.add(iPreferenceFilterArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IPreferenceFilter[arrayList.size()]);
    }

    private boolean internalMatchesWithMatchType(PreferenceFilterEntry preferenceFilterEntry, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        String string = preferenceFilterEntry.getKey();
        String string2 = preferenceFilterEntry.getMatchType();
        if (!string2.equalsIgnoreCase(MATCH_TYPE_PREFIX)) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isLegacy(Properties properties) {
        return properties.getProperty(VERSION_KEY) == null;
    }

    public IPreferenceFilter[] matches(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray) throws CoreException {
        if (iPreferenceFilterArray == null || iPreferenceFilterArray.length == 0) {
            return new IPreferenceFilter[0];
        }
        try {
            return this.internalMatches(iEclipsePreferences, iPreferenceFilterArray);
        }
        catch (BackingStoreException backingStoreException) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_matching, backingStoreException));
        }
    }

    private IEclipsePreferences mergeTrees(IEclipsePreferences[] iEclipsePreferencesArray) throws BackingStoreException {
        if (iEclipsePreferencesArray.length == 1) {
            return iEclipsePreferencesArray[0];
        }
        final IExportedPreferences iExportedPreferences = ExportedPreferences.newRoot();
        if (iEclipsePreferencesArray.length == 0) {
            return iExportedPreferences;
        }
        IPreferenceNodeVisitor iPreferenceNodeVisitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
                Preferences preferences = iExportedPreferences.node(iEclipsePreferences.absolutePath());
                PreferencesService.this.copyFromTo(iEclipsePreferences, preferences, null, 0);
                return true;
            }
        };
        int n = 0;
        while (n < iEclipsePreferencesArray.length) {
            iEclipsePreferencesArray[n].accept(iPreferenceNodeVisitor);
            ++n;
        }
        return iExportedPreferences;
    }

    public IExportedPreferences readPreferences(InputStream inputStream) throws CoreException {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Reading preferences from stream...");
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_importProblems, iOException));
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        if (properties.isEmpty()) {
            throw new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_invalidFileFormat, null));
        }
        if (this.isLegacy(properties)) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Read legacy preferences file, converting to 3.0 format...");
            }
            properties = this.convertFromLegacy(properties);
        } else {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Read preferences file.");
            }
            properties.remove(VERSION_KEY);
        }
        return this.convertFromProperties(properties);
    }

    private boolean scopeMatches(String string, IEclipsePreferences iEclipsePreferences) {
        String string2;
        if (iEclipsePreferences.parent() == null) {
            return false;
        }
        int n = (string2 = iEclipsePreferences.absolutePath()).indexOf(47, 1);
        String string3 = string2.substring(1, n == -1 ? string2.length() : n);
        return string.equals(string3);
    }

    public void setDefaultLookupOrder(String string, String string2, String[] stringArray) {
        String string3 = this.getRegistryKey(string, string2);
        if (stringArray == null) {
            defaultsRegistry.remove(string3);
        } else {
            LookupOrder lookupOrder = new LookupOrder(stringArray);
            defaultsRegistry.put(string3, lookupOrder);
        }
    }

    public void setRegistryHelper(Object object) {
        if (this.registryHelper != null && this.registryHelper != object) {
            ((PreferenceServiceRegistryHelper)this.registryHelper).stop();
        }
        this.registryHelper = object;
    }

    void shareStrings() {
        long l = System.currentTimeMillis();
        if (l - this.lastStringSharing < 300000L) {
            return;
        }
        StringPool stringPool = new StringPool();
        root.shareStrings(stringPool);
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            System.out.println("Preference string sharing saved: " + stringPool.getSavedStringCount());
        }
        this.lastStringSharing = l;
    }

    private IEclipsePreferences trimTree(IEclipsePreferences iEclipsePreferences, IPreferenceFilter iPreferenceFilter) throws BackingStoreException {
        IEclipsePreferences iEclipsePreferences2 = (IEclipsePreferences)ExportedPreferences.newRoot().node(iEclipsePreferences.absolutePath());
        String[] stringArray = iPreferenceFilter.getScopes();
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        String string = iEclipsePreferences.absolutePath();
        int n = 0;
        while (n < stringArray.length) {
            block10: {
                Map map;
                String string2;
                block8: {
                    block9: {
                        string2 = stringArray[n];
                        map = iPreferenceFilter.getMapping(string2);
                        if (map != null) break block8;
                        if (iEclipsePreferences.parent() != null || !iEclipsePreferences.nodeExists(string2)) break block9;
                        this.copyFromTo(iEclipsePreferences.node(string2), iEclipsePreferences2.node(string2), null, -1);
                        break block10;
                    }
                    if (!this.scopeMatches(string2, iEclipsePreferences)) break block10;
                    this.copyFromTo(iEclipsePreferences, iEclipsePreferences2, null, -1);
                    break block10;
                }
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    PreferenceFilterEntry[] preferenceFilterEntryArray;
                    String string3 = (String)iterator.next();
                    String string4 = String.valueOf('/') + string2 + '/' + string3;
                    if (!string4.startsWith(string)) continue;
                    String string5 = string4.substring(string.length());
                    if (!iEclipsePreferences.nodeExists(string5 = EclipsePreferences.makeRelative(string5))) continue;
                    Preferences preferences = iEclipsePreferences.node(string5);
                    try {
                        preferenceFilterEntryArray = (PreferenceFilterEntry[])map.get(string3);
                    }
                    catch (ClassCastException classCastException) {
                        PreferencesService.log(PreferencesService.createStatusError(PrefsMessages.preferences_classCastFilterEntry, classCastException));
                        continue;
                    }
                    String[] stringArray2 = null;
                    if (preferenceFilterEntryArray != null) {
                        ArrayList arrayList = new ArrayList();
                        int n2 = 0;
                        while (n2 < preferenceFilterEntryArray.length) {
                            if (preferenceFilterEntryArray[n2] != null) {
                                this.addMatchedKeys(arrayList, preferenceFilterEntryArray[n2], preferences.keys());
                            }
                            ++n2;
                        }
                        stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    }
                    this.copyFromTo(iEclipsePreferences.node(string5), iEclipsePreferences2.node(string5), stringArray2, stringArray2 == null ? -1 : 0);
                }
            }
            ++n;
        }
        return iEclipsePreferences2;
    }

    private void addMatchedKeys(ArrayList arrayList, PreferenceFilterEntry preferenceFilterEntry, String[] stringArray) {
        String string = preferenceFilterEntry.getMatchType();
        if (string == null) {
            arrayList.add(preferenceFilterEntry.getKey());
            return;
        }
        if (stringArray == null) {
            return;
        }
        String string2 = preferenceFilterEntry.getKey();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(MATCH_TYPE_PREFIX) && stringArray[n].startsWith(string2)) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
    }

    IStatus validatePluginVersions(String string, PluginVersionIdentifier pluginVersionIdentifier, PluginVersionIdentifier pluginVersionIdentifier2) {
        if (pluginVersionIdentifier2.getMajorComponent() == pluginVersionIdentifier.getMajorComponent() && pluginVersionIdentifier2.getMinorComponent() == pluginVersionIdentifier.getMinorComponent()) {
            return null;
        }
        int n = pluginVersionIdentifier2.getMajorComponent() < pluginVersionIdentifier.getMajorComponent() ? 4 : 2;
        String string2 = NLS.bind((String)PrefsMessages.preferences_incompatible, (Object[])new Object[]{pluginVersionIdentifier, string, pluginVersionIdentifier2});
        return new Status(n, "org.eclipse.equinox.preferences", 1, string2, null);
    }

    public IStatus validateVersions(IPath iPath) {
        final MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.preferences", 1, PrefsMessages.preferences_validate, null);
        IPreferenceNodeVisitor iPreferenceNodeVisitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences iEclipsePreferences) {
                if (!(iEclipsePreferences instanceof ExportedPreferences)) {
                    return false;
                }
                ExportedPreferences exportedPreferences = (ExportedPreferences)iEclipsePreferences;
                String string = exportedPreferences.getVersion();
                if (string == null || !PluginVersionIdentifier.validateVersion((String)string).isOK()) {
                    return true;
                }
                PluginVersionIdentifier pluginVersionIdentifier = new PluginVersionIdentifier(string);
                String string2 = PreferencesService.this.getBundleName(iEclipsePreferences.absolutePath());
                if (string2 == null) {
                    return true;
                }
                String string3 = PreferencesService.this.getBundleVersion(string2);
                if (string3 == null || !PluginVersionIdentifier.validateVersion((String)string3).isOK()) {
                    return true;
                }
                PluginVersionIdentifier pluginVersionIdentifier2 = new PluginVersionIdentifier(string3);
                IStatus iStatus = PreferencesService.this.validatePluginVersions(string2, pluginVersionIdentifier, pluginVersionIdentifier2);
                if (iStatus != null) {
                    multiStatus.add(iStatus);
                }
                return true;
            }
        };
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(iPath.toFile()));
            IExportedPreferences iExportedPreferences = this.readPreferences(bufferedInputStream);
            iExportedPreferences.accept(iPreferenceNodeVisitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CoreException coreException) {
            multiStatus.add(PreferencesService.createStatusError(PrefsMessages.preferences_validationException, (Exception)((Object)coreException)));
        }
        catch (BackingStoreException backingStoreException) {
            multiStatus.add(PreferencesService.createStatusError(PrefsMessages.preferences_validationException, backingStoreException));
        }
        return multiStatus;
    }

    public String[] getDefaultDefaultLookupOrder() {
        return DEFAULT_DEFAULT_LOOKUP_ORDER;
    }

    public void setDefaultDefaultLookupOrder(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        DEFAULT_DEFAULT_LOOKUP_ORDER = stringArray;
    }
}

