/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class OSGiPreferencesServiceImpl
implements PreferencesService {
    private IEclipsePreferences bundlePreferences;

    OSGiPreferencesServiceImpl(IEclipsePreferences iEclipsePreferences) {
        this.bundlePreferences = iEclipsePreferences;
    }

    public Preferences getSystemPreferences() {
        return new OSGiLocalRootPreferences(this.bundlePreferences.node("system"));
    }

    public Preferences getUserPreferences(String string) {
        return new OSGiLocalRootPreferences(this.bundlePreferences.node("user/" + string));
    }

    public String[] getUsers() {
        String[] stringArray = null;
        try {
            stringArray = this.bundlePreferences.node("user").childrenNames();
        }
        catch (BackingStoreException backingStoreException) {}
        return stringArray == null ? new String[]{} : stringArray;
    }

    private static final class OSGiLocalRootPreferences
    implements Preferences {
        private Preferences root;
        private Preferences wrapped;

        private OSGiLocalRootPreferences(Preferences preferences) {
            this(preferences, preferences);
        }

        private OSGiLocalRootPreferences(Preferences preferences, Preferences preferences2) {
            this.root = preferences2;
            this.wrapped = preferences;
        }

        private String fixPath(String string) {
            if (string.startsWith("/")) {
                if (string.equals("/")) {
                    return this.root.absolutePath();
                }
                return this.root.absolutePath().concat(string);
            }
            return string;
        }

        public Preferences node(String string) {
            if ((string = this.fixPath(string)).length() > 1 && string.endsWith("/") || string.indexOf("//") != -1) {
                throw new IllegalArgumentException();
            }
            return new OSGiLocalRootPreferences(this.wrapped.node(string), this.root);
        }

        public byte[] getByteArray(String string, byte[] byArray) {
            byte[] byArray2;
            String string2 = this.wrapped.get(string, null);
            byte[] byArray3 = null;
            if (string2 != null && (byArray2 = string2.getBytes()).length % 4 == 0) {
                try {
                    byArray3 = Base64.decode(byArray2);
                }
                catch (Exception exception) {}
            }
            return byArray3 == null ? byArray : byArray3;
        }

        public Preferences parent() {
            if (this.wrapped == this.root) {
                try {
                    if (!this.wrapped.nodeExists("")) {
                        throw new IllegalStateException();
                    }
                }
                catch (BackingStoreException backingStoreException) {}
                return null;
            }
            return new OSGiLocalRootPreferences(this.wrapped.parent(), this.root);
        }

        public boolean nodeExists(String string) throws BackingStoreException {
            return this.wrapped.nodeExists(this.fixPath(string));
        }

        public String absolutePath() {
            if (this.wrapped == this.root) {
                return "/";
            }
            return this.wrapped.absolutePath().substring(this.root.absolutePath().length(), this.wrapped.absolutePath().length());
        }

        public String name() {
            if (this.wrapped == this.root) {
                return "";
            }
            return this.wrapped.name();
        }

        public void put(String string, String string2) {
            this.wrapped.put(string, string2);
        }

        public String get(String string, String string2) {
            return this.wrapped.get(string, string2);
        }

        public void remove(String string) {
            this.wrapped.remove(string);
        }

        public void clear() throws BackingStoreException {
            this.wrapped.clear();
        }

        public void putInt(String string, int n) {
            this.wrapped.putInt(string, n);
        }

        public int getInt(String string, int n) {
            return this.wrapped.getInt(string, n);
        }

        public void putLong(String string, long l) {
            this.wrapped.putLong(string, l);
        }

        public long getLong(String string, long l) {
            return this.wrapped.getLong(string, l);
        }

        public void putBoolean(String string, boolean bl) {
            this.wrapped.putBoolean(string, bl);
        }

        public boolean getBoolean(String string, boolean bl) {
            return this.wrapped.getBoolean(string, bl);
        }

        public void putFloat(String string, float f) {
            this.wrapped.putFloat(string, f);
        }

        public float getFloat(String string, float f) {
            return this.wrapped.getFloat(string, f);
        }

        public void putDouble(String string, double d) {
            this.wrapped.putDouble(string, d);
        }

        public double getDouble(String string, double d) {
            return this.wrapped.getDouble(string, d);
        }

        public void putByteArray(String string, byte[] byArray) {
            this.wrapped.putByteArray(string, byArray);
        }

        public String[] keys() throws BackingStoreException {
            return this.wrapped.keys();
        }

        public String[] childrenNames() throws BackingStoreException {
            return this.wrapped.childrenNames();
        }

        public void removeNode() throws BackingStoreException {
            this.wrapped.removeNode();
        }

        public void flush() throws BackingStoreException {
            this.wrapped.flush();
        }

        public void sync() throws BackingStoreException {
            this.wrapped.sync();
        }
    }
}

