/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.service.datalocation.Location;

public class InstancePreferences
extends EclipsePreferences {
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;
    private IPath location;
    private static Set loadedNodes = Collections.synchronizedSet(new HashSet());
    private static boolean initialized = false;
    private static IPath baseLocation;

    private static IPath getBaseLocation() {
        Location location;
        if (baseLocation == null && (location = PreferencesOSGiUtils.getDefault().getInstanceLocation()) != null && (location.isSet() || location.allowsDefault())) {
            baseLocation = MetaDataKeeper.getMetaArea().getStateLocation("org.eclipse.core.runtime");
        }
        return baseLocation;
    }

    public InstancePreferences() {
        this(null, null);
    }

    private InstancePreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        this.initializeChildren();
        String string2 = this.absolutePath();
        this.segmentCount = InstancePreferences.getSegmentCount(string2);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = InstancePreferences.getSegment(string2, 1);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    protected void loadLegacy() {
        Path path = new Path(this.absolutePath());
        if (path.segmentCount() != 2) {
            return;
        }
        if (PreferencesOSGiUtils.getDefault().getInstanceLocation() == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Cannot load Legacy plug-in preferences since instance location is not set.");
            }
            return;
        }
        String string = path.segment(1);
        File file = null;
        Location location = PreferencesOSGiUtils.getDefault().getInstanceLocation();
        if (location != null && location.isSet()) {
            file = MetaDataKeeper.getMetaArea().getPreferenceLocation(string, false).toFile();
        }
        if (file == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Cannot load legacy values because instance location is not set.");
            }
            return;
        }
        if (!file.exists()) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Legacy plug-in preference file not found: " + file);
            }
            return;
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Loading legacy preferences from " + file);
        }
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                block27: {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        PrefsMessages.message("IOException encountered loading legacy preference file " + file);
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {
                            if (!EclipsePreferences.DEBUG_PREFERENCE_GENERAL) break block27;
                            PrefsMessages.message("IOException encountered closing legacy preference file " + file);
                            iOException2.printStackTrace();
                        }
                    }
                }
                return;
            }
        }
        finally {
            block28: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!EclipsePreferences.DEBUG_PREFERENCE_GENERAL) break block28;
                        PrefsMessages.message("IOException encountered closing legacy preference file " + file);
                        iOException.printStackTrace();
                    }
                }
            }
        }
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            String string4 = properties.getProperty(string3);
            if (string4 == null) continue;
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Loaded legacy preference: " + string3 + " -> " + string4);
            }
            if (string4.equals(string2 = this.internalPut(string3, string4))) continue;
            this.makeDirty();
        }
        if (!file.delete() && EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Unable to delete legacy preferences file: " + file);
        }
    }

    protected IPath getLocation() {
        if (this.location == null) {
            this.location = this.computeLocation(InstancePreferences.getBaseLocation(), this.qualifier);
        }
        return this.location;
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences iEclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                iEclipsePreferences = (IEclipsePreferences)iEclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = iEclipsePreferences;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (initialized || this.parent == null) {
            return;
        }
        try {
            InstancePreferences instancePreferences = this;
            synchronized (instancePreferences) {
                String[] stringArray = this.computeChildren(InstancePreferences.getBaseLocation());
                int n = 0;
                while (n < stringArray.length) {
                    this.addChild(stringArray[n], null);
                    ++n;
                }
            }
        }
        finally {
            initialized = true;
        }
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new InstancePreferences(eclipsePreferences, string);
    }
}

