/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.Activator;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.exchange.IProductPreferencesService;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;
import org.osgi.util.tracker.ServiceTracker;

public class DefaultPreferences
extends EclipsePreferences {
    private static Set loadedNodes = Collections.synchronizedSet(new HashSet());
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final IPath NL_DIR = new Path("$nl$");
    private static final String PROPERTIES_FILE_EXTENSION = "properties";
    private static Properties productCustomization;
    private static Properties productTranslation;
    private static Properties commandLineCustomization;
    private EclipsePreferences loadLevel;
    private Thread initializingThread;
    private String qualifier;
    private int segmentCount;
    private WeakReference pluginReference;
    public static String pluginCustomizationFile;
    static /* synthetic */ Class class$0;

    static {
        pluginCustomizationFile = null;
    }

    public DefaultPreferences() {
        this(null, null);
    }

    private DefaultPreferences(EclipsePreferences eclipsePreferences, String string, Object object) {
        this(eclipsePreferences, string);
        this.pluginReference = new WeakReference<Object>(object);
    }

    private DefaultPreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        if (eclipsePreferences instanceof DefaultPreferences) {
            this.pluginReference = ((DefaultPreferences)eclipsePreferences).pluginReference;
        }
        String string2 = this.absolutePath();
        this.segmentCount = DefaultPreferences.getSegmentCount(string2);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = DefaultPreferences.getSegment(string2, 1);
    }

    private void applyBundleDefaults() {
        Bundle bundle = PreferencesOSGiUtils.getDefault().getBundle(this.name());
        if (bundle == null) {
            return;
        }
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)new Path("preferences.ini"), null);
        if (uRL == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference default override file not found for bundle: " + bundle.getSymbolicName());
            }
            return;
        }
        URL uRL2 = FileLocator.find((Bundle)bundle, (IPath)NL_DIR.append("preferences").addFileExtension(PROPERTIES_FILE_EXTENSION), null);
        if (uRL2 == null && EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Preference translation file not found for bundle: " + bundle.getSymbolicName());
        }
        this.applyDefaults(this.name(), this.loadProperties(uRL), this.loadProperties(uRL2));
    }

    private void applyCommandLineDefaults() {
        if (commandLineCustomization == null) {
            String string = pluginCustomizationFile;
            if (string == null) {
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                    PrefsMessages.message("Command-line preferences customization file not specified.");
                }
                return;
            }
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Using command-line preference customization file: " + string);
            }
            commandLineCustomization = this.loadProperties(string);
        }
        this.applyDefaults(null, commandLineCustomization, null);
    }

    private void applyDefaults(String string, Properties properties, Properties properties2) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            Path path = new Path(string2);
            String string4 = path.lastSegment();
            path = path.removeLastSegments(1);
            String string5 = string;
            if (string == null) {
                string5 = path.segment(0);
                path = path.removeFirstSegments(1);
            }
            if (!this.name().equals(string5)) continue;
            string3 = this.translatePreference(string3, properties2);
            if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                PrefsMessages.message("Setting default preference: " + new Path(this.absolutePath()).append((IPath)path).append(string4) + '=' + string3);
            }
            ((EclipsePreferences)this.internalNode(path.toString(), false, null)).internalPut(string4, string3);
        }
    }

    public IEclipsePreferences node(String string, Object object) {
        return this.internalNode(string, true, object);
    }

    private void applyRuntimeDefaults() {
        WeakReference weakReference = PreferencesService.getDefault().applyRuntimeDefaults(this.name(), this.pluginReference);
        if (weakReference != null) {
            this.pluginReference = weakReference;
        }
    }

    private void applyProductDefaults() {
        if (productCustomization == null) {
            BundleContext bundleContext = Activator.getContext();
            if (bundleContext != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.internal.preferences.exchange.IProductPreferencesService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ServiceTracker serviceTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
                serviceTracker.open();
                IProductPreferencesService iProductPreferencesService = (IProductPreferencesService)serviceTracker.getService();
                if (iProductPreferencesService != null) {
                    productCustomization = iProductPreferencesService.getProductCustomization();
                    productTranslation = iProductPreferencesService.getProductTranslation();
                }
                serviceTracker.close();
            } else {
                PrefsMessages.message("Product-specified preferences called before plugin is started");
            }
            if (productCustomization == null) {
                productCustomization = new Properties();
            }
        }
        if (!productCustomization.isEmpty()) {
            this.applyDefaults(null, productCustomization, productTranslation);
        }
    }

    public void flush() {
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences eclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                eclipsePreferences = (EclipsePreferences)eclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = eclipsePreferences;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new DefaultPreferences(eclipsePreferences, string, object);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected void load() {
        this.setInitializingBundleDefaults();
        try {
            this.applyRuntimeDefaults();
            this.applyBundleDefaults();
        }
        finally {
            this.clearInitializingBundleDefaults();
        }
        this.applyProductDefaults();
        this.applyCommandLineDefaults();
    }

    protected String internalPut(String string, String string2) {
        String string3;
        String string4 = super.internalPut(string, string2);
        if (this.isInitializingBundleDefaults() && (string3 = DefaultPreferences.getScopeRelativePath(this.absolutePath())) != null) {
            Preferences preferences = PreferencesService.getDefault().getRootNode().node("bundle_defaults").node(string3);
            preferences.put(string, string2);
        }
        return string4;
    }

    private void setInitializingBundleDefaults() {
        IEclipsePreferences iEclipsePreferences = this.getLoadLevel();
        if (iEclipsePreferences instanceof DefaultPreferences) {
            DefaultPreferences defaultPreferences = (DefaultPreferences)iEclipsePreferences;
            defaultPreferences.initializingThread = Thread.currentThread();
        }
    }

    private void clearInitializingBundleDefaults() {
        IEclipsePreferences iEclipsePreferences = this.getLoadLevel();
        if (iEclipsePreferences instanceof DefaultPreferences) {
            DefaultPreferences defaultPreferences = (DefaultPreferences)iEclipsePreferences;
            defaultPreferences.initializingThread = null;
        }
    }

    private boolean isInitializingBundleDefaults() {
        IEclipsePreferences iEclipsePreferences = this.getLoadLevel();
        if (iEclipsePreferences instanceof DefaultPreferences) {
            DefaultPreferences defaultPreferences = (DefaultPreferences)iEclipsePreferences;
            return defaultPreferences.initializingThread == Thread.currentThread();
        }
        return false;
    }

    protected static String getScopeRelativePath(String string) {
        if (string.length() < 2) {
            return null;
        }
        int n = string.indexOf(47, 1);
        if (n == -1 || n + 1 >= string.length()) {
            return null;
        }
        return string.substring(n + 1);
    }

    private Properties loadProperties(URL uRL) {
        Properties properties;
        block16: {
            properties = new Properties();
            if (uRL == null) {
                return properties;
            }
            InputStream inputStream = null;
            try {
                try {
                    inputStream = uRL.openStream();
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        PrefsMessages.message("Problem opening stream to preference customization file: " + uRL);
                        iOException.printStackTrace();
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadProperties(String string) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(string));
            properties.load(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference customization file not found: " + string);
            }
            if (inputStream == null) return properties;
            try {
                inputStream.close();
                return properties;
            }
            catch (IOException iOException) {}
            return properties;
        }
        catch (IOException iOException) {
            try {
                String string2 = NLS.bind((String)PrefsMessages.preferences_loadException, (Object)string);
                Status status = new Status(4, "org.eclipse.equinox.preferences", 4, string2, (Throwable)iOException);
                RuntimeLog.log((IStatus)status);
                if (inputStream == null) return properties;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return properties;
            }
            catch (IOException iOException3) {}
            return properties;
        }
        if (inputStream == null) return properties;
        try {
            inputStream.close();
            return properties;
        }
        catch (IOException iOException) {}
        return properties;
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    public void sync() {
    }

    private String translatePreference(String string, Properties properties) {
        string = string.trim();
        if (properties == null || string.startsWith(KEY_DOUBLE_PREFIX)) {
            return string;
        }
        if (string.startsWith(KEY_PREFIX)) {
            int n = string.indexOf(" ");
            String string2 = n == -1 ? string.substring(1) : string.substring(1, n);
            String string3 = n == -1 ? string : string.substring(n + 1);
            return properties.getProperty(string2, string3);
        }
        return string;
    }
}

