/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Queue {
    protected Object[] elements;
    protected int head;
    protected boolean reuse;
    protected int tail;

    public Queue() {
        this(20, false);
    }

    public Queue(int n, boolean bl) {
        this.elements = new Object[n];
        this.tail = 0;
        this.head = 0;
        this.reuse = bl;
    }

    public void enqueue(Object object) {
        int n = this.increment(this.tail);
        if (n == this.head) {
            this.grow();
            n = this.tail + 1;
        }
        this.elements[this.tail] = object;
        this.tail = n;
    }

    public int decrement(int n) {
        return n == 0 ? this.elements.length - 1 : n - 1;
    }

    public Iterator elements() {
        if (this.isEmpty()) {
            return new ArrayList(0).iterator();
        }
        if (this.head <= this.tail) {
            return Arrays.asList(this.elements).iterator();
        }
        Object[] objectArray = new Object[this.size()];
        int n = this.elements.length - this.head;
        System.arraycopy(this.elements, this.head, objectArray, 0, n);
        System.arraycopy(this.elements, 0, objectArray, n, this.tail);
        return Arrays.asList(objectArray).iterator();
    }

    public Object get(Object object) {
        int n = this.head;
        while (n != this.tail) {
            if (this.elements[n].equals(object)) {
                return this.elements[n];
            }
            n = this.increment(n);
        }
        return null;
    }

    public boolean remove(Object object) {
        int n = this.head;
        while (n != this.tail) {
            if (this.elements[n].equals(object)) break;
            n = this.increment(n);
        }
        if (n == this.tail) {
            return false;
        }
        Object object2 = this.elements[n];
        int n2 = -1;
        while (n != this.tail) {
            n2 = this.increment(n);
            if (n2 != this.tail) {
                this.elements[n] = this.elements[n2];
            }
            n = n2;
        }
        this.tail = this.decrement(this.tail);
        this.elements[this.tail] = this.reuse ? object2 : null;
        return true;
    }

    protected void grow() {
        int n = (int)((double)this.elements.length * 1.5);
        Object[] objectArray = new Object[n];
        if (this.tail >= this.head) {
            System.arraycopy(this.elements, this.head, objectArray, this.head, this.size());
        } else {
            int n2 = n - (this.elements.length - this.head);
            System.arraycopy(this.elements, 0, objectArray, 0, this.tail + 1);
            System.arraycopy(this.elements, this.head, objectArray, n2, n - n2);
            this.head = n2;
        }
        this.elements = objectArray;
    }

    public int increment(int n) {
        return n == this.elements.length - 1 ? 0 : n + 1;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public Object peek() {
        return this.elements[this.head];
    }

    public Object dequeue() {
        if (this.isEmpty()) {
            return null;
        }
        Object object = this.peek();
        if (!this.reuse) {
            this.elements[this.head] = null;
        }
        this.head = this.increment(this.head);
        return object;
    }

    public int size() {
        return this.tail > this.head ? this.tail - this.head : this.elements.length - this.head + this.tail;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (!this.isEmpty()) {
            Iterator iterator = this.elements();
            while (true) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) break;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

