/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjectMap
implements Map {
    protected static final int DEFAULT_SIZE = 16;
    protected static final int GROW_SIZE = 10;
    protected int count = 0;
    protected Object[] elements = null;

    public ObjectMap(int n) {
        if (n > 0) {
            this.elements = new Object[Math.max(n * 2, 0)];
        }
    }

    public ObjectMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public void clear() {
        this.elements = null;
        this.count = 0;
    }

    public Object clone() {
        return new ObjectMap(this);
    }

    public boolean containsKey(Object object) {
        if (this.elements == null || this.count == 0) {
            return false;
        }
        int n = 0;
        while (n < this.elements.length) {
            if (this.elements[n] != null && this.elements[n].equals(object)) {
                return true;
            }
            n += 2;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        if (this.elements == null || this.count == 0) {
            return false;
        }
        int n = 1;
        while (n < this.elements.length) {
            if (this.elements[n] != null && this.elements[n].equals(object)) {
                return true;
            }
            n += 2;
        }
        return false;
    }

    public Set entrySet() {
        return this.count == 0 ? Collections.EMPTY_SET : this.toHashMap().entrySet();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.count != map.size()) {
            return false;
        }
        if (!this.keySet().equals(map.keySet())) {
            return false;
        }
        int n = 0;
        while (n < this.elements.length) {
            if (this.elements[n] != null && !this.elements[n + 1].equals(map.get(this.elements[n]))) {
                return false;
            }
            n += 2;
        }
        return true;
    }

    public Object get(Object object) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        int n = 0;
        while (n < this.elements.length) {
            if (this.elements[n] != null && this.elements[n].equals(object)) {
                return this.elements[n + 1];
            }
            n += 2;
        }
        return null;
    }

    protected void grow() {
        Object[] objectArray = new Object[this.elements.length + 10];
        System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
        this.elements = objectArray;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.length) {
            if (this.elements[n2] != null) {
                n += this.elements[n2].hashCode();
            }
            n2 += 2;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set keySet() {
        HashSet<Object> hashSet = new HashSet<Object>(this.size());
        int n = 0;
        while (n < this.elements.length) {
            if (this.elements[n] != null) {
                hashSet.add(this.elements[n]);
            }
            n += 2;
        }
        return hashSet;
    }

    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object2 == null) {
            return this.remove(object);
        }
        if (this.elements == null) {
            this.elements = new Object[16];
        }
        if (this.count == 0) {
            this.elements[0] = object;
            this.elements[1] = object2;
            ++this.count;
            return null;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.elements.length) {
            if (this.elements[n2] != null) {
                if (this.elements[n2].equals(object)) {
                    Object object3 = this.elements[n2 + 1];
                    this.elements[n2 + 1] = object2;
                    return object3;
                }
            } else if (n == -1) {
                n = n2;
            }
            n2 += 2;
        }
        if (n == -1) {
            n = this.count * 2;
        }
        if (this.elements.length <= this.count * 2) {
            this.grow();
        }
        this.elements[n] = object;
        this.elements[n + 1] = object2;
        ++this.count;
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            this.put(k, v);
        }
    }

    public Object remove(Object object) {
        if (this.elements == null || this.count == 0) {
            return null;
        }
        int n = 0;
        while (n < this.elements.length) {
            if (this.elements[n] != null && this.elements[n].equals(object)) {
                this.elements[n] = null;
                Object object2 = this.elements[n + 1];
                this.elements[n + 1] = null;
                --this.count;
                return object2;
            }
            n += 2;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    private HashMap toHashMap() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.size());
        int n = 0;
        while (n < this.elements.length) {
            if (this.elements[n] != null) {
                hashMap.put(this.elements[n], this.elements[n + 1]);
            }
            n += 2;
        }
        return hashMap;
    }

    public Collection values() {
        HashSet<Object> hashSet = new HashSet<Object>(this.size());
        int n = 1;
        while (n < this.elements.length) {
            if (this.elements[n] != null) {
                hashSet.add(this.elements[n]);
            }
            n += 2;
        }
        return hashSet;
    }
}

