/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.Iterator;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class JobQueue {
    protected final InternalJob dummy;
    private final boolean allowConflictOvertaking;
    private final boolean allowPriorityOvertaking;

    public JobQueue(boolean bl) {
        this(bl, true);
    }

    public JobQueue(boolean bl, boolean bl2) {
        this.allowPriorityOvertaking = bl2;
        this.dummy = new InternalJob("Queue-Head"){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                return Status.OK_STATUS;
            }
        };
        this.dummy.setNext(this.dummy);
        this.dummy.setPrevious(this.dummy);
        this.allowConflictOvertaking = bl;
    }

    public void clear() {
        this.dummy.setNext(this.dummy);
        this.dummy.setPrevious(this.dummy);
    }

    public InternalJob dequeue() {
        InternalJob internalJob = this.dummy.previous();
        if (internalJob == this.dummy) {
            return null;
        }
        return internalJob.remove();
    }

    public void enqueue(InternalJob internalJob) {
        Assert.isTrue((internalJob.next() == null ? 1 : 0) != 0);
        Assert.isTrue((internalJob.previous() == null ? 1 : 0) != 0);
        InternalJob internalJob2 = this.dummy.next();
        while (this.canOvertake(internalJob, internalJob2)) {
            internalJob2 = internalJob2.next();
        }
        InternalJob internalJob3 = internalJob2.previous();
        internalJob.setNext(internalJob2);
        internalJob.setPrevious(internalJob3);
        internalJob3.setNext(internalJob);
        internalJob2.setPrevious(internalJob);
    }

    private boolean canOvertake(InternalJob internalJob, InternalJob internalJob2) {
        if (internalJob2 == this.dummy) {
            return false;
        }
        if (internalJob.getWaitQueueStamp() > 0L && internalJob.getWaitQueueStamp() < internalJob2.getWaitQueueStamp()) {
            return true;
        }
        if (this.allowPriorityOvertaking && internalJob2.compareTo(internalJob) >= 0) {
            return false;
        }
        return this.allowConflictOvertaking || !internalJob.isConflicting(internalJob2);
    }

    public void remove(InternalJob internalJob) {
        internalJob.remove();
    }

    public void resort(InternalJob internalJob) {
        this.remove(internalJob);
        this.enqueue(internalJob);
    }

    public boolean isEmpty() {
        return this.dummy.next() == this.dummy;
    }

    public InternalJob peek() {
        return this.dummy.previous() == this.dummy ? null : this.dummy.previous();
    }

    public Iterator iterator() {
        return new Iterator(){
            InternalJob pointer;
            {
                this.pointer = JobQueue.this.dummy;
            }

            public boolean hasNext() {
                this.pointer = this.pointer.previous() == JobQueue.this.dummy ? null : this.pointer.previous();
                return this.pointer != null;
            }

            public Object next() {
                return this.pointer;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

