/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.JobChangeEvent;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.internal.jobs.JobOSGiUtils;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

class JobListeners {
    private final IListenerDoit aboutToRun = new IListenerDoit(){

        public void notify(IJobChangeListener iJobChangeListener, IJobChangeEvent iJobChangeEvent) {
            iJobChangeListener.aboutToRun(iJobChangeEvent);
        }
    };
    private final IListenerDoit awake = new IListenerDoit(){

        public void notify(IJobChangeListener iJobChangeListener, IJobChangeEvent iJobChangeEvent) {
            iJobChangeListener.awake(iJobChangeEvent);
        }
    };
    private final IListenerDoit done = new IListenerDoit(){

        public void notify(IJobChangeListener iJobChangeListener, IJobChangeEvent iJobChangeEvent) {
            iJobChangeListener.done(iJobChangeEvent);
        }
    };
    private final IListenerDoit running = new IListenerDoit(){

        public void notify(IJobChangeListener iJobChangeListener, IJobChangeEvent iJobChangeEvent) {
            iJobChangeListener.running(iJobChangeEvent);
        }
    };
    private final IListenerDoit scheduled = new IListenerDoit(){

        public void notify(IJobChangeListener iJobChangeListener, IJobChangeEvent iJobChangeEvent) {
            iJobChangeListener.scheduled(iJobChangeEvent);
        }
    };
    private final IListenerDoit sleeping = new IListenerDoit(){

        public void notify(IJobChangeListener iJobChangeListener, IJobChangeEvent iJobChangeEvent) {
            iJobChangeListener.sleeping(iJobChangeEvent);
        }
    };
    protected final ListenerList global = new ListenerList(1);

    JobListeners() {
    }

    static JobChangeEvent newEvent(Job job) {
        JobChangeEvent jobChangeEvent = new JobChangeEvent();
        jobChangeEvent.job = job;
        return jobChangeEvent;
    }

    static JobChangeEvent newEvent(Job job, IStatus iStatus) {
        JobChangeEvent jobChangeEvent = new JobChangeEvent();
        jobChangeEvent.job = job;
        jobChangeEvent.result = iStatus;
        return jobChangeEvent;
    }

    static JobChangeEvent newEvent(Job job, long l) {
        JobChangeEvent jobChangeEvent = new JobChangeEvent();
        jobChangeEvent.job = job;
        jobChangeEvent.delay = l;
        return jobChangeEvent;
    }

    private void doNotify(IListenerDoit iListenerDoit, IJobChangeEvent iJobChangeEvent) {
        Object[] objectArray = this.global.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                if (objectArray[n2] != null) {
                    iListenerDoit.notify((IJobChangeListener)objectArray[n2], iJobChangeEvent);
                }
            }
            catch (Exception exception) {
                this.handleException(objectArray[n2], exception);
            }
            catch (LinkageError linkageError) {
                this.handleException(objectArray[n2], linkageError);
            }
            ++n2;
        }
        ListenerList listenerList = iJobChangeEvent.getJob().getListeners();
        Object[] objectArray2 = objectArray = listenerList == null ? null : listenerList.getListeners();
        if (objectArray == null) {
            return;
        }
        n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            try {
                if (objectArray[n3] != null) {
                    iListenerDoit.notify((IJobChangeListener)objectArray[n3], iJobChangeEvent);
                }
            }
            catch (Exception exception) {
                this.handleException(objectArray[n3], exception);
            }
            catch (LinkageError linkageError) {
                this.handleException(objectArray[n3], linkageError);
            }
            ++n3;
        }
    }

    private void handleException(Object object, Throwable throwable) {
        if (throwable instanceof OperationCanceledException) {
            return;
        }
        String string = JobOSGiUtils.getDefault().getBundleId(object);
        if (string == null) {
            string = "org.eclipse.core.jobs";
        }
        String string2 = NLS.bind((String)JobMessages.meta_pluginProblems, (Object)string);
        RuntimeLog.log((IStatus)new Status(4, string, 2, string2, throwable));
    }

    public void add(IJobChangeListener iJobChangeListener) {
        this.global.add((Object)iJobChangeListener);
    }

    public void remove(IJobChangeListener iJobChangeListener) {
        this.global.remove((Object)iJobChangeListener);
    }

    public void aboutToRun(Job job) {
        this.doNotify(this.aboutToRun, JobListeners.newEvent(job));
    }

    public void awake(Job job) {
        this.doNotify(this.awake, JobListeners.newEvent(job));
    }

    public void done(Job job, IStatus iStatus, boolean bl) {
        JobChangeEvent jobChangeEvent = JobListeners.newEvent(job, iStatus);
        jobChangeEvent.reschedule = bl;
        this.doNotify(this.done, jobChangeEvent);
    }

    public void running(Job job) {
        this.doNotify(this.running, JobListeners.newEvent(job));
    }

    public void scheduled(Job job, long l, boolean bl) {
        JobChangeEvent jobChangeEvent = JobListeners.newEvent(job, l);
        jobChangeEvent.reschedule = bl;
        this.doNotify(this.scheduled, jobChangeEvent);
    }

    public void sleeping(Job job) {
        this.doNotify(this.sleeping, JobListeners.newEvent(job));
    }

    static interface IListenerDoit {
        public void notify(IJobChangeListener var1, IJobChangeEvent var2);
    }
}

