/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class ContentTypeHandler
implements IContentType {
    private int generation;
    String id;
    private SoftReference targetRef;

    ContentTypeHandler(ContentType contentType, int n) {
        this.id = contentType.getId();
        this.targetRef = new SoftReference<ContentType>(contentType);
        this.generation = n;
    }

    public void addFileSpec(String string, int n) throws CoreException {
        ContentType contentType = this.getTarget();
        if (contentType != null) {
            contentType.addFileSpec(string, n);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ContentType) {
            return this.id.equals(((ContentType)object).id);
        }
        if (object instanceof ContentTypeHandler) {
            return this.id.equals(((ContentTypeHandler)object).id);
        }
        return false;
    }

    public IContentType getBaseType() {
        ContentType contentType = this.getTarget();
        if (contentType == null) {
            return null;
        }
        ContentType contentType2 = (ContentType)contentType.getBaseType();
        return contentType2 != null ? new ContentTypeHandler(contentType2, contentType2.getCatalog().getGeneration()) : null;
    }

    public String getDefaultCharset() {
        ContentType contentType = this.getTarget();
        return contentType != null ? contentType.getDefaultCharset() : null;
    }

    public IContentDescription getDefaultDescription() {
        ContentType contentType = this.getTarget();
        return contentType != null ? contentType.getDefaultDescription() : new DummyContentDescription();
    }

    public IContentDescription getDescriptionFor(InputStream inputStream, QualifiedName[] qualifiedNameArray) throws IOException {
        ContentType contentType = this.getTarget();
        return contentType != null ? contentType.getDescriptionFor(inputStream, qualifiedNameArray) : null;
    }

    public IContentDescription getDescriptionFor(Reader reader, QualifiedName[] qualifiedNameArray) throws IOException {
        ContentType contentType = this.getTarget();
        return contentType != null ? contentType.getDescriptionFor(reader, qualifiedNameArray) : null;
    }

    public String[] getFileSpecs(int n) {
        ContentType contentType = this.getTarget();
        return contentType != null ? contentType.getFileSpecs(n) : new String[]{};
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        ContentType contentType = this.getTarget();
        return contentType != null ? contentType.getName() : this.id;
    }

    public IContentTypeSettings getSettings(IScopeContext iScopeContext) throws CoreException {
        ContentType contentType = this.getTarget();
        if (contentType == null) {
            return null;
        }
        IContentTypeSettings iContentTypeSettings = contentType.getSettings(iScopeContext);
        return iContentTypeSettings == contentType ? this : iContentTypeSettings;
    }

    public ContentType getTarget() {
        ContentType contentType = (ContentType)this.targetRef.get();
        ContentTypeCatalog contentTypeCatalog = ContentTypeManager.getInstance().getCatalog();
        if (contentType == null || contentTypeCatalog.getGeneration() != this.generation) {
            contentType = contentTypeCatalog.getContentType(this.id);
            this.targetRef = new SoftReference<ContentType>(contentType);
            this.generation = contentTypeCatalog.getGeneration();
        }
        return contentType == null ? null : contentType.getAliasTarget(true);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isAssociatedWith(String string) {
        ContentType contentType = this.getTarget();
        return contentType != null ? contentType.isAssociatedWith(string) : false;
    }

    public boolean isAssociatedWith(String string, IScopeContext iScopeContext) {
        ContentType contentType = this.getTarget();
        return contentType != null ? contentType.isAssociatedWith(string, iScopeContext) : false;
    }

    public boolean isKindOf(IContentType iContentType) {
        ContentType contentType;
        if (iContentType instanceof ContentTypeHandler) {
            iContentType = ((ContentTypeHandler)iContentType).getTarget();
        }
        return (contentType = this.getTarget()) != null ? contentType.isKindOf(iContentType) : false;
    }

    public void removeFileSpec(String string, int n) throws CoreException {
        ContentType contentType = this.getTarget();
        if (contentType != null) {
            contentType.removeFileSpec(string, n);
        }
    }

    public void setDefaultCharset(String string) throws CoreException {
        ContentType contentType = this.getTarget();
        if (contentType != null) {
            contentType.setDefaultCharset(string);
        }
    }

    public String toString() {
        return this.id;
    }

    private class DummyContentDescription
    implements IContentDescription {
        private DummyContentDescription() {
        }

        public String getCharset() {
            return null;
        }

        public IContentType getContentType() {
            return ContentTypeHandler.this;
        }

        public Object getProperty(QualifiedName qualifiedName) {
            return null;
        }

        public boolean isRequested(QualifiedName qualifiedName) {
            return false;
        }

        public void setProperty(QualifiedName qualifiedName, Object object) {
        }
    }
}

