/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FullFeatureParser
extends DefaultHandler
implements IConfigurationConstants {
    private SAXParser parser;
    private FeatureEntry feature;
    private URL url;
    private boolean isDescription;
    private StringBuffer description = new StringBuffer();
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public FullFeatureParser(FeatureEntry featureEntry) {
        this.feature = featureEntry;
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException);
        }
    }

    public void parse() {
        InputStream inputStream = null;
        try {
            if (this.feature.getSite() == null) {
                return;
            }
            try {
                this.url = new URL(this.feature.getSite().getResolvedURL(), String.valueOf(this.feature.getURL()) + "feature.xml");
                inputStream = this.url.openStream();
                this.parser.parse(new InputSource(inputStream), (DefaultHandler)this);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {}
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Utils.log(iOException.getLocalizedMessage());
                }
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Utils.debug("Start Element: uri:" + string + " local Name:" + string2 + " qName:" + string3);
        if ("plugin".equals(string2)) {
            this.processPlugin(attributes);
        } else if ("description".equals(string2)) {
            this.isDescription = true;
        } else if ("license".equals(string2)) {
            this.processLicense(attributes);
        }
    }

    private void processPlugin(Attributes attributes) {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("version");
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("")) {
            System.out.println(NLS.bind((String)Messages.FeatureParser_IdOrVersionInvalid, (Object[])new String[]{string, string2}));
        } else {
            String string3;
            String string4;
            String string5 = attributes.getValue("nl");
            String string6 = attributes.getValue("os");
            if (!Utils.isValidEnvironment(string6, string4 = attributes.getValue("ws"), string3 = attributes.getValue("arch"), string5)) {
                return;
            }
            PluginEntry pluginEntry = new PluginEntry();
            pluginEntry.setPluginIdentifier(string);
            pluginEntry.setPluginVersion(string2);
            this.feature.addPlugin(pluginEntry);
            Utils.debug("End process DefaultFeature tag: id:" + string + " ver:" + string2 + " url:" + this.feature.getURL());
        }
    }

    private void processLicense(Attributes attributes) {
        this.feature.setLicenseURL(attributes.getValue("url"));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.isDescription) {
            return;
        }
        this.description.append(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("description".equals(string2)) {
            this.isDescription = false;
            String string4 = this.description.toString().trim();
            ResourceBundle resourceBundle = this.feature.getResourceBundle();
            this.feature.setDescription(Utils.getResourceString(resourceBundle, string4));
        }
    }
}

