/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public final class PluginVersionIdentifier {
    private Version version;
    private static final String SEPARATOR = ".";

    public PluginVersionIdentifier(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public PluginVersionIdentifier(int n, int n2, int n3, String string) {
        if (n < 0) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_postiveMajor, (Object)(String.valueOf(n) + SEPARATOR + n2 + SEPARATOR + n3 + SEPARATOR + string)));
        }
        if (n2 < 0) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_postiveMinor, (Object)(String.valueOf(n) + SEPARATOR + n2 + SEPARATOR + n3 + SEPARATOR + string)));
        }
        if (n3 < 0) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_postiveService, (Object)(String.valueOf(n) + SEPARATOR + n2 + SEPARATOR + n3 + SEPARATOR + string)));
        }
        this.version = new Version(n, n2, n3, string);
    }

    public PluginVersionIdentifier(String string) {
        Object[] objectArray = PluginVersionIdentifier.parseVersion(string);
        this.version = new Version(((Integer)objectArray[0]).intValue(), ((Integer)objectArray[1]).intValue(), ((Integer)objectArray[2]).intValue(), (String)objectArray[3]);
    }

    public static IStatus validateVersion(String string) {
        try {
            PluginVersionIdentifier.parseVersion(string);
        }
        catch (RuntimeException runtimeException) {
            return new Status(4, "org.eclipse.core.runtime", 4, runtimeException.getMessage(), runtimeException);
        }
        return Status.OK_STATUS;
    }

    private static Object[] parseVersion(String string) {
        String string2;
        if (string == null) {
            Assert.isNotNull(null, CommonMessages.parse_emptyPluginVersion);
        }
        if ((string2 = string.trim()).equals("")) {
            Assert.isTrue(false, CommonMessages.parse_emptyPluginVersion);
        }
        if (string2.startsWith(SEPARATOR)) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_separatorStartVersion, (Object)string2));
        }
        if (string2.endsWith(SEPARATOR)) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_separatorEndVersion, (Object)string2));
        }
        if (string2.indexOf("..") != -1) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_doubleSeparatorVersion, (Object)string2));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SEPARATOR);
        Vector<String> vector = new Vector<String>(4);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        if (n <= 0) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_oneElementPluginVersion, (Object)string2));
        }
        if (n > 4) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_fourElementPluginVersion, (Object)string2));
        }
        int[] nArray = new int[3];
        try {
            nArray[0] = Integer.parseInt((String)vector.elementAt(0));
            if (nArray[0] < 0) {
                Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_postiveMajor, (Object)string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_numericMajorComponent, (Object)string2));
        }
        try {
            if (n >= 2) {
                nArray[1] = Integer.parseInt((String)vector.elementAt(1));
                if (nArray[1] < 0) {
                    Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_postiveMinor, (Object)string2));
                }
            } else {
                nArray[1] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_numericMinorComponent, (Object)string2));
        }
        try {
            if (n >= 3) {
                nArray[2] = Integer.parseInt((String)vector.elementAt(2));
                if (nArray[2] < 0) {
                    Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_postiveService, (Object)string2));
                }
            } else {
                nArray[2] = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Assert.isTrue(false, NLS.bind((String)CommonMessages.parse_numericServiceComponent, (Object)string2));
        }
        Object[] objectArray = new Object[]{new Integer(nArray[0]), new Integer(nArray[1]), new Integer(nArray[2]), n >= 4 ? (String)vector.elementAt(3) : ""};
        return objectArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PluginVersionIdentifier)) {
            return false;
        }
        PluginVersionIdentifier pluginVersionIdentifier = (PluginVersionIdentifier)object;
        return this.version.equals((Object)pluginVersionIdentifier.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public int getMajorComponent() {
        return this.version.getMajor();
    }

    public int getMinorComponent() {
        return this.version.getMinor();
    }

    public int getServiceComponent() {
        return this.version.getMicro();
    }

    public String getQualifierComponent() {
        return this.version.getQualifier();
    }

    public boolean isGreaterOrEqualTo(PluginVersionIdentifier pluginVersionIdentifier) {
        if (pluginVersionIdentifier == null) {
            return false;
        }
        if (this.getMajorComponent() > pluginVersionIdentifier.getMajorComponent()) {
            return true;
        }
        if (this.getMajorComponent() == pluginVersionIdentifier.getMajorComponent() && this.getMinorComponent() > pluginVersionIdentifier.getMinorComponent()) {
            return true;
        }
        if (this.getMajorComponent() == pluginVersionIdentifier.getMajorComponent() && this.getMinorComponent() == pluginVersionIdentifier.getMinorComponent() && this.getServiceComponent() > pluginVersionIdentifier.getServiceComponent()) {
            return true;
        }
        return this.getMajorComponent() == pluginVersionIdentifier.getMajorComponent() && this.getMinorComponent() == pluginVersionIdentifier.getMinorComponent() && this.getServiceComponent() == pluginVersionIdentifier.getServiceComponent() && this.getQualifierComponent().compareTo(pluginVersionIdentifier.getQualifierComponent()) >= 0;
    }

    public boolean isCompatibleWith(PluginVersionIdentifier pluginVersionIdentifier) {
        if (pluginVersionIdentifier == null) {
            return false;
        }
        if (this.getMajorComponent() != pluginVersionIdentifier.getMajorComponent()) {
            return false;
        }
        if (this.getMinorComponent() > pluginVersionIdentifier.getMinorComponent()) {
            return true;
        }
        if (this.getMinorComponent() < pluginVersionIdentifier.getMinorComponent()) {
            return false;
        }
        if (this.getServiceComponent() > pluginVersionIdentifier.getServiceComponent()) {
            return true;
        }
        if (this.getServiceComponent() < pluginVersionIdentifier.getServiceComponent()) {
            return false;
        }
        return this.getQualifierComponent().compareTo(pluginVersionIdentifier.getQualifierComponent()) >= 0;
    }

    public boolean isEquivalentTo(PluginVersionIdentifier pluginVersionIdentifier) {
        if (pluginVersionIdentifier == null) {
            return false;
        }
        if (this.getMajorComponent() != pluginVersionIdentifier.getMajorComponent()) {
            return false;
        }
        if (this.getMinorComponent() != pluginVersionIdentifier.getMinorComponent()) {
            return false;
        }
        if (this.getServiceComponent() > pluginVersionIdentifier.getServiceComponent()) {
            return true;
        }
        if (this.getServiceComponent() < pluginVersionIdentifier.getServiceComponent()) {
            return false;
        }
        return this.getQualifierComponent().compareTo(pluginVersionIdentifier.getQualifierComponent()) >= 0;
    }

    public boolean isPerfect(PluginVersionIdentifier pluginVersionIdentifier) {
        if (pluginVersionIdentifier == null) {
            return false;
        }
        return this.getMajorComponent() == pluginVersionIdentifier.getMajorComponent() && this.getMinorComponent() == pluginVersionIdentifier.getMinorComponent() && this.getServiceComponent() == pluginVersionIdentifier.getServiceComponent() && this.getQualifierComponent().equals(pluginVersionIdentifier.getQualifierComponent());
    }

    public boolean isGreaterThan(PluginVersionIdentifier pluginVersionIdentifier) {
        if (pluginVersionIdentifier == null) {
            return this.getMajorComponent() != 0 || this.getMinorComponent() != 0 || this.getServiceComponent() != 0 || !this.getQualifierComponent().equals("");
        }
        if (this.getMajorComponent() > pluginVersionIdentifier.getMajorComponent()) {
            return true;
        }
        if (this.getMajorComponent() < pluginVersionIdentifier.getMajorComponent()) {
            return false;
        }
        if (this.getMinorComponent() > pluginVersionIdentifier.getMinorComponent()) {
            return true;
        }
        if (this.getMinorComponent() < pluginVersionIdentifier.getMinorComponent()) {
            return false;
        }
        if (this.getServiceComponent() > pluginVersionIdentifier.getServiceComponent()) {
            return true;
        }
        if (this.getServiceComponent() < pluginVersionIdentifier.getServiceComponent()) {
            return false;
        }
        return this.getQualifierComponent().compareTo(pluginVersionIdentifier.getQualifierComponent()) > 0;
    }

    public String toString() {
        return this.version.toString();
    }
}

