/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownServiceException;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class PlatformURLConfigConnection
extends PlatformURLConnection {
    private static final String FILE_PROTOCOL = "file";
    private static boolean isRegistered = false;
    public static final String CONFIG = "config";
    private boolean parentConfiguration = false;
    static /* synthetic */ Class class$0;

    public PlatformURLConfigConnection(URL uRL) {
        super(uRL);
    }

    protected URL resolve() throws IOException {
        File file;
        String string = this.url.getFile().trim();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith(CONFIG)) {
            throw new IOException(NLS.bind((String)CommonMessages.url_badVariant, (Object)this.url.toString()));
        }
        String string2 = string.substring(CONFIG.length() + 1);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IOException(CommonMessages.activator_not_available);
        }
        Location location = activator.getConfigurationLocation();
        Location location2 = location.getParentLocation();
        URL uRL = new URL(location.getURL(), string2);
        if (!FILE_PROTOCOL.equals(uRL.getProtocol()) || location2 == null) {
            return uRL;
        }
        File file2 = new File(uRL.getPath());
        if (file2.exists()) {
            return uRL;
        }
        URL uRL2 = new URL(location2.getURL(), string2);
        if (FILE_PROTOCOL.equals(uRL2.getProtocol()) && (file = new File(uRL2.getPath())).exists()) {
            this.parentConfiguration = true;
            return uRL2;
        }
        return uRL;
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.runtime.PlatformURLConfigConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register(CONFIG, clazz);
        isRegistered = true;
    }

    public OutputStream getOutputStream() throws IOException {
        String string;
        if (this.parentConfiguration || Activator.getDefault() == null || Activator.getDefault().getConfigurationLocation().isReadOnly()) {
            throw new UnknownServiceException(NLS.bind((String)CommonMessages.url_noOutput, (Object)this.url));
        }
        URL uRL = this.getResolvedURL();
        if (uRL != null && (string = uRL.getFile()) != null) {
            File file = new File(string);
            String string2 = file.getParent();
            if (string2 != null) {
                new File(string2).mkdirs();
            }
            return new FileOutputStream(file);
        }
        return null;
    }
}

