/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;
import org.osgi.service.packageadmin.PackageAdmin;

public class PlatformLogWriter
implements SynchronousLogListener,
LogFilter {
    public static final String EQUINOX_LOGGER_NAME = "org.eclipse.equinox.logger";
    private final ExtendedLogService logService;
    private final PackageAdmin packageAdmin;
    private final Bundle bundle;

    public PlatformLogWriter(ExtendedLogService extendedLogService, PackageAdmin packageAdmin, Bundle bundle) {
        this.logService = extendedLogService;
        this.packageAdmin = packageAdmin;
        this.bundle = bundle;
    }

    void logging(IStatus iStatus) {
        Bundle bundle = this.getBundle(iStatus);
        Logger logger = this.logService.getLogger(bundle, EQUINOX_LOGGER_NAME);
        logger.log((Object)PlatformLogWriter.getLog(iStatus), PlatformLogWriter.getLevel(iStatus), iStatus.getMessage(), iStatus.getException());
    }

    public static int getLevel(IStatus iStatus) {
        switch (iStatus.getSeverity()) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 4;
            }
        }
        return 32;
    }

    public static FrameworkLogEntry getLog(IStatus iStatus) {
        IStatus[] iStatusArray;
        int n;
        Throwable throwable = iStatus.getException();
        ArrayList<FrameworkLogEntry> arrayList = new ArrayList<FrameworkLogEntry>();
        int n2 = n = throwable instanceof CoreException ? 1 : 0;
        if (n == 1 && (iStatusArray = ((CoreException)throwable).getStatus()) != null) {
            arrayList.add(PlatformLogWriter.getLog((IStatus)iStatusArray));
        }
        if (iStatus.isMultiStatus()) {
            iStatusArray = iStatus.getChildren();
            int n3 = 0;
            while (n3 < iStatusArray.length) {
                arrayList.add(PlatformLogWriter.getLog(iStatusArray[n3]));
                ++n3;
            }
        }
        iStatusArray = arrayList.size() == 0 ? null : arrayList.toArray(new FrameworkLogEntry[arrayList.size()]);
        return new FrameworkLogEntry((Object)iStatus, iStatus.getPlugin(), iStatus.getSeverity(), iStatus.getCode(), iStatus.getMessage(), n, throwable, (FrameworkLogEntry[])iStatusArray);
    }

    private Bundle getBundle(IStatus iStatus) {
        String string = iStatus.getPlugin();
        if (string == null) {
            return this.bundle;
        }
        Bundle[] bundleArray = this.packageAdmin.getBundles(string, null);
        return bundleArray == null || bundleArray.length == 0 ? this.bundle : bundleArray[0];
    }

    public boolean isLoggable(Bundle bundle, String string, int n) {
        return EQUINOX_LOGGER_NAME.equals(string) && RuntimeLog.hasListeners();
    }

    public void logged(LogEntry logEntry) {
        RuntimeLog.logToListeners(PlatformLogWriter.convertToStatus(logEntry));
    }

    public static IStatus convertToStatus(LogEntry logEntry) {
        Object object = null;
        if (logEntry instanceof ExtendedLogEntry) {
            object = ((ExtendedLogEntry)logEntry).getContext();
        }
        if (object instanceof IStatus) {
            return (IStatus)object;
        }
        if (object instanceof FrameworkLogEntry) {
            FrameworkLogEntry frameworkLogEntry = (FrameworkLogEntry)object;
            if ((object = frameworkLogEntry.getContext()) instanceof IStatus) {
                return (IStatus)object;
            }
            return PlatformLogWriter.convertToStatus(frameworkLogEntry);
        }
        return PlatformLogWriter.convertRawEntryToStatus(logEntry);
    }

    private static IStatus convertToStatus(FrameworkLogEntry frameworkLogEntry) {
        FrameworkLogEntry[] frameworkLogEntryArray = frameworkLogEntry.getChildren();
        if (frameworkLogEntryArray != null) {
            IStatus[] iStatusArray = new Status[frameworkLogEntryArray.length];
            int n = 0;
            while (n < iStatusArray.length) {
                iStatusArray[n] = PlatformLogWriter.convertToStatus(frameworkLogEntryArray[n]);
                ++n;
            }
            return new MultiStatus(frameworkLogEntry.getEntry(), frameworkLogEntry.getBundleCode(), iStatusArray, frameworkLogEntry.getMessage(), frameworkLogEntry.getThrowable());
        }
        return new Status(frameworkLogEntry.getSeverity(), frameworkLogEntry.getEntry(), frameworkLogEntry.getBundleCode(), frameworkLogEntry.getMessage(), frameworkLogEntry.getThrowable());
    }

    private static IStatus convertRawEntryToStatus(LogEntry logEntry) {
        int n;
        switch (logEntry.getLevel()) {
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                n = -1;
            }
        }
        Bundle bundle = logEntry.getBundle();
        return new Status(n, bundle == null ? null : bundle.getSymbolicName(), logEntry.getMessage(), logEntry.getException());
    }
}

