/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class FindSupport {
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_ARCH = "osgi.arch";
    private static String[] NL_JAR_VARIANTS = FindSupport.buildNLVariants(Activator.getContext() == null ? System.getProperty("osgi.nl") : Activator.getContext().getProperty("osgi.nl"));

    private static String[] buildNLVariants(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = new Path("nl");
        IPath iPath = new Path(string.replace('_', '/'));
        while (iPath.segmentCount() > 0) {
            arrayList.add(path.append(iPath).toString());
            if (iPath.segmentCount() > 1) {
                arrayList.add(path.append(iPath.toString().replace('/', '_')).toString());
            }
            iPath = iPath.removeLastSegments(1);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static URL find(Bundle bundle, IPath iPath) {
        return FindSupport.find(bundle, iPath, null);
    }

    public static URL find(Bundle bundle, IPath iPath, Map map) {
        return FindSupport.find(bundle, iPath, map, null);
    }

    public static URL[] findEntries(Bundle bundle, IPath iPath) {
        return FindSupport.findEntries(bundle, iPath, null);
    }

    public static URL[] findEntries(Bundle bundle, IPath iPath, Map map) {
        ArrayList arrayList = new ArrayList(1);
        FindSupport.find(bundle, iPath, map, arrayList);
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private static URL find(Bundle bundle, IPath iPath, Map map, ArrayList arrayList) {
        if (iPath == null) {
            return null;
        }
        URL uRL = null;
        if (iPath.isEmpty() || iPath.isRoot()) {
            uRL = FindSupport.findInPlugin(bundle, Path.EMPTY, arrayList);
            if (uRL == null || arrayList != null) {
                uRL = FindSupport.findInFragments(bundle, Path.EMPTY, arrayList);
            }
            return uRL;
        }
        String string = iPath.segment(0);
        if (string.charAt(0) != '$') {
            uRL = FindSupport.findInPlugin(bundle, iPath, arrayList);
            if (uRL == null || arrayList != null) {
                uRL = FindSupport.findInFragments(bundle, iPath, arrayList);
            }
            return uRL;
        }
        IPath iPath2 = iPath.removeFirstSegments(1);
        if (string.equalsIgnoreCase("$nl$")) {
            return FindSupport.findNL(bundle, iPath2, map, arrayList);
        }
        if (string.equalsIgnoreCase("$os$")) {
            return FindSupport.findOS(bundle, iPath2, map, arrayList);
        }
        if (string.equalsIgnoreCase("$ws$")) {
            return FindSupport.findWS(bundle, iPath2, map, arrayList);
        }
        if (string.equalsIgnoreCase("$files$")) {
            return null;
        }
        return null;
    }

    private static URL findOS(Bundle bundle, IPath iPath, Map map, ArrayList arrayList) {
        String string = null;
        if (map != null) {
            try {
                string = (String)map.get("$os$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (string == null) {
            string = Activator.getContext().getProperty(PROP_OS);
        }
        if (string.length() == 0) {
            return null;
        }
        String string2 = null;
        if (map != null) {
            try {
                string2 = (String)map.get("$arch$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (string2 == null) {
            string2 = Activator.getContext().getProperty(PROP_ARCH);
        }
        if (string2.length() == 0) {
            return null;
        }
        URL uRL = null;
        IPath iPath2 = new Path("os").append(string).append(string2);
        while (iPath2.segmentCount() != 1) {
            IPath iPath3 = iPath2.append(iPath);
            uRL = FindSupport.findInPlugin(bundle, iPath3, arrayList);
            if (uRL != null && arrayList == null) {
                return uRL;
            }
            uRL = FindSupport.findInFragments(bundle, iPath3, arrayList);
            if (uRL != null && arrayList == null) {
                return uRL;
            }
            iPath2 = iPath2.removeLastSegments(1);
        }
        uRL = FindSupport.findInPlugin(bundle, iPath, arrayList);
        if (uRL != null && arrayList == null) {
            return uRL;
        }
        return FindSupport.findInFragments(bundle, iPath, arrayList);
    }

    private static URL findWS(Bundle bundle, IPath iPath, Map map, ArrayList arrayList) {
        IPath iPath2;
        URL uRL;
        String string = null;
        if (map != null) {
            try {
                string = (String)map.get("$ws$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (string == null) {
            string = Activator.getContext().getProperty(PROP_WS);
        }
        if ((uRL = FindSupport.findInPlugin(bundle, iPath2 = new Path("ws").append(string).append(iPath), arrayList)) != null && arrayList == null) {
            return uRL;
        }
        uRL = FindSupport.findInFragments(bundle, iPath2, arrayList);
        if (uRL != null && arrayList == null) {
            return uRL;
        }
        uRL = FindSupport.findInPlugin(bundle, iPath, arrayList);
        if (uRL != null && arrayList == null) {
            return uRL;
        }
        return FindSupport.findInFragments(bundle, iPath, arrayList);
    }

    private static URL findNL(Bundle bundle, IPath iPath, Map map, ArrayList arrayList) {
        String string = null;
        String[] stringArray = null;
        if (map != null) {
            try {
                string = (String)map.get("$nl$");
            }
            catch (ClassCastException classCastException) {}
        }
        String[] stringArray2 = stringArray = string == null ? NL_JAR_VARIANTS : FindSupport.buildNLVariants(string);
        if (string != null && string.length() == 0) {
            return null;
        }
        URL uRL = null;
        int n = 0;
        while (n < stringArray.length) {
            IPath iPath2 = new Path(stringArray[n]).append(iPath);
            uRL = FindSupport.findInPlugin(bundle, iPath2, arrayList);
            if (uRL != null && arrayList == null) {
                return uRL;
            }
            uRL = FindSupport.findInFragments(bundle, iPath2, arrayList);
            if (uRL != null && arrayList == null) {
                return uRL;
            }
            ++n;
        }
        uRL = FindSupport.findInPlugin(bundle, iPath, arrayList);
        if (uRL != null && arrayList == null) {
            return uRL;
        }
        return FindSupport.findInFragments(bundle, iPath, arrayList);
    }

    private static URL findInPlugin(Bundle bundle, IPath iPath, ArrayList arrayList) {
        URL uRL = bundle.getEntry(iPath.toString());
        if (uRL != null && arrayList != null) {
            arrayList.add(uRL);
        }
        return uRL;
    }

    private static URL findInFragments(Bundle bundle, IPath iPath, ArrayList arrayList) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        Bundle[] bundleArray = activator.getFragments(bundle);
        if (bundleArray == null) {
            return null;
        }
        if (arrayList != null) {
            arrayList.ensureCapacity(bundleArray.length + 1);
        }
        int n = 0;
        while (n < bundleArray.length) {
            URL uRL = bundleArray[n].getEntry(iPath.toString());
            if (uRL != null) {
                if (arrayList == null) {
                    return uRL;
                }
                arrayList.add(uRL);
            }
            ++n;
        }
        return null;
    }

    public static final InputStream openStream(Bundle bundle, IPath iPath, boolean bl) throws IOException {
        URL uRL = null;
        if (!bl) {
            uRL = FindSupport.findInPlugin(bundle, iPath, null);
            if (uRL == null) {
                uRL = FindSupport.findInFragments(bundle, iPath, null);
            }
        } else {
            uRL = FindSupport.find(bundle, iPath);
        }
        if (uRL != null) {
            return uRL.openStream();
        }
        throw new IOException("Cannot find " + iPath.toString());
    }

    public static URL find(URL uRL) {
        if (!"platform".equalsIgnoreCase(uRL.getProtocol())) {
            return null;
        }
        String string = uRL.getFile().trim();
        Object[] objectArray = null;
        try {
            objectArray = PlatformURLPluginConnection.parse(string, uRL);
        }
        catch (IOException iOException) {
            RuntimeLog.log(new Status(4, "org.eclipse.core.runtime", "Invalid input url:" + uRL, iOException));
            return null;
        }
        Bundle bundle = (Bundle)objectArray[0];
        String string2 = (String)objectArray[1];
        if ("/".equals(string2)) {
            return bundle.getEntry(string2);
        }
        return FindSupport.find(bundle, new Path(string2), null);
    }
}

