/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.EclipseAppDescriptor;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.service.runnable.ApplicationRunnable;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;

public class EclipseAppHandle
extends ApplicationHandle
implements ApplicationRunnable,
IApplicationContext {
    private static final int FLAG_STARTING = 1;
    private static final int FLAG_ACTIVE = 2;
    private static final int FLAG_STOPPING = 4;
    private static final int FLAG_STOPPED = 8;
    private static final String STARTING = "org.eclipse.equinox.app.starting";
    private static final String STOPPED = "org.eclipse.equinox.app.stopped";
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private static final Object NULL_RESULT = new Object();
    private volatile ServiceRegistration handleRegistration;
    private int status = 1;
    private final Map arguments;
    private Object application;
    private final Boolean defaultAppInstance;
    private Object result;
    private boolean setResult = false;
    private boolean setAsyncResult = false;
    private final boolean[] registrationLock = new boolean[]{true};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    EclipseAppHandle(String string, Map map, EclipseAppDescriptor eclipseAppDescriptor) {
        super(string, eclipseAppDescriptor);
        this.defaultAppInstance = map == null || map.get("eclipse.application.default") == null ? Boolean.FALSE : (Boolean)map.remove("eclipse.application.default");
        this.arguments = map == null ? new HashMap(2) : new HashMap(map);
    }

    public synchronized String getState() {
        switch (this.status) {
            case 1: {
                return STARTING;
            }
            case 2: {
                return "RUNNING";
            }
            case 4: {
                return "STOPPING";
            }
        }
        if (this.getServiceRegistration() == null) {
            throw new IllegalStateException(NLS.bind((String)Messages.application_error_state_stopped, (Object)this.getInstanceId()));
        }
        return STOPPED;
    }

    protected void destroySpecific() {
        this.setAppStatus(4);
        IApplication iApplication = this.getApplication();
        if (iApplication != null) {
            iApplication.stop();
        }
        this.setAppStatus(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceRegistration(ServiceRegistration serviceRegistration) {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            this.handleRegistration = serviceRegistration;
            this.registrationLock[0] = serviceRegistration != null;
            this.registrationLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistration getServiceRegistration() {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            if (this.handleRegistration == null && this.registrationLock[0]) {
                try {
                    this.registrationLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.handleRegistration;
        }
    }

    ServiceReference getServiceReference() {
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration == null) {
            return null;
        }
        try {
            return serviceRegistration.getReference();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    Dictionary getServiceProperties() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(6);
        ((Dictionary)hashtable).put("service.pid", this.getInstanceId());
        ((Dictionary)hashtable).put("application.state", this.getState());
        ((Dictionary)hashtable).put("application.descriptor", this.getApplicationDescriptor().getApplicationId());
        ((Dictionary)hashtable).put("eclipse.application.type", ((EclipseAppDescriptor)this.getApplicationDescriptor()).getThreadTypeString());
        ((Dictionary)hashtable).put("application.supports.exitvalue", Boolean.TRUE);
        if (this.defaultAppInstance.booleanValue()) {
            ((Dictionary)hashtable).put("eclipse.application.default", this.defaultAppInstance);
        }
        return hashtable;
    }

    private synchronized void setAppStatus(int n) {
        if (this.status == n) {
            return;
        }
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("Cannot set app status to starting");
        }
        if ((n & 4) != 0 && (this.status & 0xC) != 0) {
            return;
        }
        this.status = n;
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration == null) {
            return;
        }
        serviceRegistration.setProperties(this.getServiceProperties());
        if ((this.status & 8) != 0) {
            ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().unlock(this);
            serviceRegistration.unregister();
            this.setServiceRegistration(null);
        }
    }

    public Map getArguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(Object object) throws Exception {
        if (object != null) {
            this.arguments.put("application.args", object);
        } else {
            object = this.arguments.get("application.args");
            if (object == null) {
                object = CommandLineArgs.getApplicationArgs();
                this.arguments.put("application.args", object);
            }
        }
        Object object2 = null;
        try {
            Object object3;
            EclipseAppHandle eclipseAppHandle = this;
            synchronized (eclipseAppHandle) {
                if ((this.status & 5) == 0) {
                    throw new ApplicationException(3, NLS.bind((String)Messages.application_instance_stopped, (Object)this.getInstanceId()));
                }
                object3 = this.application = this.getConfiguration().createExecutableExtension("run");
                this.notifyAll();
            }
            if (object3 instanceof IApplication) {
                object2 = ((IApplication)object3).start(this);
            } else {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                object2 = EclipseAppContainer.callMethodWithException(object3, "run", classArray, new Object[]{object});
            }
            if (object2 == null) {
                object2 = NULL_RESULT;
            }
        }
        catch (Throwable throwable) {
            object2 = this.setInternalResult(object2, false, null);
            throw throwable;
        }
        object2 = this.setInternalResult(object2, false, null);
        if (Activator.DEBUG) {
            System.out.println(NLS.bind((String)Messages.application_returned, (Object[])new String[]{this.getApplicationDescriptor().getApplicationId(), object2 == null ? "null" : object2.toString()}));
        }
        return object2;
    }

    private synchronized Object setInternalResult(Object object, boolean bl, IApplication iApplication) {
        if (this.setResult) {
            throw new IllegalStateException("The result of the application is already set.");
        }
        if (bl) {
            if (!this.setAsyncResult) {
                throw new IllegalStateException("The application must return IApplicationContext.EXIT_ASYNC_RESULT to set asynchronous results.");
            }
            if (this.application != iApplication) {
                throw new IllegalArgumentException("The application is not the correct instance for this application context.");
            }
        } else if (object == IApplicationContext.EXIT_ASYNC_RESULT) {
            this.setAsyncResult = true;
            return NULL_RESULT;
        }
        this.result = object;
        this.setResult = true;
        this.application = null;
        this.notifyAll();
        this.setAppStatus(4);
        this.setAppStatus(8);
        if (this.isDefault() && object != null) {
            int n = object instanceof Integer ? (Integer)object : 0;
            Activator.setProperty(PROP_ECLIPSE_EXITCODE, Integer.toString(n));
        }
        return object;
    }

    public void stop() {
        try {
            this.destroy();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void applicationRunning() {
        this.setAppStatus(2);
        final ServiceReference[] serviceReferenceArray = this.getStartupMonitors();
        if (serviceReferenceArray == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable throwable) {
            }

            public void run() throws Exception {
                int n = 0;
                while (n < serviceReferenceArray.length) {
                    StartupMonitor startupMonitor = (StartupMonitor)Activator.getContext().getService(serviceReferenceArray[n]);
                    if (startupMonitor != null) {
                        startupMonitor.applicationRunning();
                        Activator.getContext().ungetService(serviceReferenceArray[n]);
                    }
                    ++n;
                }
            }
        });
    }

    private ServiceReference[] getStartupMonitors() {
        ServiceReference[] serviceReferenceArray = null;
        try {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.service.runnable.StartupMonitor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            serviceReferenceArray = bundleContext.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (serviceReferenceArray == null || serviceReferenceArray.length == 0) {
            return null;
        }
        Arrays.sort(serviceReferenceArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                ServiceReference serviceReference = (ServiceReference)object;
                ServiceReference serviceReference2 = (ServiceReference)object2;
                Object object3 = serviceReference.getProperty("service.ranking");
                int n2 = object3 instanceof Integer ? (Integer)object3 : 0;
                object3 = serviceReference2.getProperty("service.ranking");
                int n3 = n = object3 instanceof Integer ? (Integer)object3 : 0;
                if (n2 != n) {
                    return n2 > n ? -1 : 1;
                }
                long l = (Long)serviceReference.getProperty("service.id");
                long l2 = (Long)serviceReference2.getProperty("service.id");
                return l2 > l ? -1 : 1;
            }
        });
        return serviceReferenceArray;
    }

    private synchronized IApplication getApplication() {
        if (this.handleRegistration != null && this.application == null) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return (IApplication)(this.application instanceof IApplication ? this.application : null);
    }

    private IConfigurationElement getConfiguration() {
        IExtension iExtension = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAppExtension(this.getApplicationDescriptor().getApplicationId());
        if (iExtension == null) {
            throw new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)this.getApplicationDescriptor().getApplicationId(), (Object)((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAvailableAppsMsg()));
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        if (iConfigurationElementArray.length == 0) {
            throw new RuntimeException(NLS.bind((String)Messages.application_invalidExtension, (Object)this.getApplicationDescriptor().getApplicationId()));
        }
        return iConfigurationElementArray[0];
    }

    public String getBrandingApplication() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getApplication();
    }

    public Bundle getBrandingBundle() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getDefiningBundle();
    }

    public String getBrandingDescription() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getDescription();
    }

    public String getBrandingId() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getId();
    }

    public String getBrandingName() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getName();
    }

    public String getBrandingProperty(String string) {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getProperty(string);
    }

    boolean isDefault() {
        return this.defaultAppInstance;
    }

    public synchronized Object waitForResult(int n) {
        try {
            return this.getExitValue(n);
        }
        catch (ApplicationException applicationException) {
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    public synchronized Object getExitValue(long l) throws ApplicationException, InterruptedException {
        if (this.handleRegistration == null && this.application == null) {
            return this.result;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l;
        while (!(this.setResult || l3 <= 0L && l != 0L)) {
            this.wait(l3);
            if (l <= 0L) continue;
            l3 -= System.currentTimeMillis() - l2;
        }
        if (this.result == null) {
            throw new ApplicationException(6);
        }
        if (this.result == NULL_RESULT) {
            return null;
        }
        return this.result;
    }

    public void setResult(Object object, IApplication iApplication) {
        this.setInternalResult(object == null ? NULL_RESULT : object, true, iApplication);
    }
}

