/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.AnyThreadAppLauncher;
import org.eclipse.equinox.internal.app.EclipseAppHandle;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.runnable.ApplicationRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DefaultApplicationListener
implements ApplicationRunnable,
ServiceTrackerCustomizer {
    private boolean running = true;
    private EclipseAppHandle launchMainApp;
    private final ServiceTracker handleTracker;
    private Object result;

    public DefaultApplicationListener(EclipseAppHandle eclipseAppHandle) {
        ServiceReference serviceReference = eclipseAppHandle.getServiceReference();
        if (serviceReference == null) {
            this.result = eclipseAppHandle.waitForResult(100);
            this.handleTracker = null;
            return;
        }
        ServiceTracker serviceTracker = new ServiceTracker(Activator.getContext(), serviceReference, (ServiceTrackerCustomizer)this);
        serviceTracker.open();
        EclipseAppHandle eclipseAppHandle2 = (EclipseAppHandle)serviceTracker.getService();
        if (eclipseAppHandle2 == null) {
            serviceTracker.close();
            this.result = eclipseAppHandle.waitForResult(100);
            this.handleTracker = null;
        } else {
            this.handleTracker = serviceTracker;
        }
    }

    public Object run(Object object) {
        if (this.handleTracker == null) {
            return this.getResult();
        }
        EclipseAppHandle eclipseAppHandle = (EclipseAppHandle)this.handleTracker.getService();
        if (eclipseAppHandle != null) {
            AnyThreadAppLauncher.launchEclipseApplication(eclipseAppHandle);
        }
        try {
            while (this.waitOnRunning()) {
                EclipseAppHandle eclipseAppHandle2 = this.getMainHandle();
                if (eclipseAppHandle2 == null) continue;
                try {
                    eclipseAppHandle2.run(null);
                }
                catch (Throwable throwable) {
                    String string = NLS.bind((String)Messages.application_error_starting, (Object)eclipseAppHandle2.getInstanceId());
                    Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 2, 0, string, 0, throwable, null));
                }
                this.unsetMainHandle(eclipseAppHandle2);
            }
        }
        finally {
            this.handleTracker.close();
        }
        return this.getResult();
    }

    private synchronized EclipseAppHandle getMainHandle() {
        return this.launchMainApp;
    }

    private synchronized void unsetMainHandle(EclipseAppHandle eclipseAppHandle) {
        if (this.launchMainApp == eclipseAppHandle) {
            this.launchMainApp = null;
        }
    }

    private synchronized boolean waitOnRunning() {
        if (!this.running) {
            return false;
        }
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {}
        return this.running;
    }

    public void stop() {
        if (this.handleTracker == null) {
            return;
        }
        ApplicationHandle applicationHandle = (ApplicationHandle)this.handleTracker.getService();
        if (applicationHandle != null) {
            try {
                applicationHandle.destroy();
            }
            catch (Throwable throwable) {
                String string = NLS.bind((String)Messages.application_error_stopping, (Object)applicationHandle.getInstanceId());
                Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 2, 0, string, 0, throwable, null));
            }
        }
    }

    public Object addingService(ServiceReference serviceReference) {
        return Activator.getContext().getService(serviceReference);
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public synchronized void removedService(ServiceReference serviceReference, Object object) {
        this.running = false;
        this.result = ((EclipseAppHandle)object).waitForResult(5000);
        EclipseAppHandle eclipseAppHandle = this.getMainHandle();
        if (eclipseAppHandle != null) {
            try {
                eclipseAppHandle.destroy();
            }
            catch (Throwable throwable) {
                String string = NLS.bind((String)Messages.application_error_stopping, (Object)eclipseAppHandle.getInstanceId());
                Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 2, 0, string, 0, throwable, null));
            }
        }
        this.notify();
    }

    synchronized void launch(EclipseAppHandle eclipseAppHandle) {
        this.launchMainApp = eclipseAppHandle;
        this.notify();
    }

    private synchronized Object getResult() {
        return this.result;
    }
}

