/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.tools.PriorityQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GlobalLRU {
    private static final ALogger a = ALogger.getLogger(GlobalLRU.class);
    private Map<CacheID, CacheItem> b = new HashMap<CacheID, CacheItem>();
    private PriorityQueue<CacheItem> c = new PriorityQueue(31, 31);
    private ReadWriteLock d = new ReentrantReadWriteLock();
    private Lock e = this.d.readLock();
    private Lock f = this.d.writeLock();
    private List<DelayedWriteJob> g = new ArrayList<DelayedWriteJob>();
    private volatile boolean h;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsyncWithReadlock(DelayedWriteJob list) {
        if (this.e.tryLock()) {
            boolean bl;
            try {
                ((DelayedWriteJob)((Object)list)).commit();
            }
            catch (Throwable throwable) {
                boolean bl2;
                this.e.unlock();
                list = this.g;
                synchronized (list) {
                    bl2 = !this.g.isEmpty();
                }
                if (bl2) {
                    this.lockForWrite();
                    this.unlockForWrite();
                }
                throw throwable;
            }
            this.e.unlock();
            list = this.g;
            synchronized (list) {
                bl = !this.g.isEmpty();
            }
            if (bl) {
                this.lockForWrite();
                this.unlockForWrite();
                return;
            }
        } else {
            boolean bl = false;
            List<DelayedWriteJob> list2 = this.g;
            synchronized (list2) {
                if (this.e.tryLock()) {
                    bl = true;
                } else {
                    this.g.add((DelayedWriteJob)((Object)list));
                }
            }
            if (bl) {
                boolean bl3;
                try {
                    ((DelayedWriteJob)((Object)list)).commit();
                }
                catch (Throwable throwable) {
                    boolean bl4;
                    this.e.unlock();
                    List<DelayedWriteJob> list3 = this.g;
                    synchronized (list3) {
                        bl4 = !this.g.isEmpty();
                    }
                    if (bl4) {
                        this.lockForWrite();
                        this.unlockForWrite();
                    }
                    throw throwable;
                }
                this.e.unlock();
                List<DelayedWriteJob> list4 = this.g;
                synchronized (list4) {
                    bl3 = !this.g.isEmpty();
                }
                if (bl3) {
                    this.lockForWrite();
                    this.unlockForWrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CacheItem cacheItem) {
        if (this.f.tryLock()) {
            try {
                this.c.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
            }
            finally {
                this.unlockForWrite();
            }
            return;
        }
        List<DelayedWriteJob> list = this.g;
        synchronized (list) {
            if (this.f.tryLock()) {
                try {
                    this.c.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.g.add(new a(this, cacheItem));
            }
            return;
        }
    }

    public void put(CacheID cacheID, CacheItem cacheItem) {
        this.f.lock();
        try {
            CacheItem cacheItem2 = this.b.remove(cacheID);
            if (cacheItem2 != null && cacheItem2.getManagementGroup() != cacheItem.getManagementGroup()) {
                a.debug("group change for " + cacheItem.getID());
                cacheItem2.getManagementGroup().removeItem(cacheItem2);
                this.c.removeAndGetUnsynced((Object)cacheItem2);
            }
            this.b.put(cacheID, cacheItem);
            this.c.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
        }
        finally {
            this.unlockForWrite();
        }
    }

    public void putUnsynced(CacheID cacheID, CacheItem cacheItem) {
        CacheItem cacheItem2 = this.b.remove(cacheID);
        if (cacheItem2 != null && cacheItem2.getManagementGroup() != cacheItem.getManagementGroup()) {
            a.debug("group change for " + cacheItem.getID());
            cacheItem2.getManagementGroup().removeItem(cacheItem2);
            this.c.removeAndGetUnsynced((Object)cacheItem2);
        }
        this.b.put(cacheID, cacheItem);
        this.c.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
    }

    public CacheItem get(CacheID object) {
        this.e.lock();
        try {
            object = this.b.get(object);
            return object;
        }
        finally {
            this.e.unlock();
        }
    }

    public CacheItem getUnsynced(CacheID cacheID) {
        return this.b.get(cacheID);
    }

    public boolean hasItem(CacheID cacheID) {
        this.e.lock();
        try {
            boolean bl = this.b.containsKey(cacheID);
            return bl;
        }
        finally {
            this.e.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(CacheItem cacheItem) {
        if (this.f.tryLock()) {
            try {
                this.c.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
            }
            finally {
                this.unlockForWrite();
            }
            return;
        }
        List<DelayedWriteJob> list = this.g;
        synchronized (list) {
            if (this.f.tryLock()) {
                try {
                    this.c.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.g.add(new e(this, cacheItem));
            }
            return;
        }
    }

    public Set<String> getGroupNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (CacheID cacheID : this.b.keySet()) {
            hashSet.add(cacheID.getGroup());
        }
        return hashSet;
    }

    public Iterator<CacheItem> getItemIterator(int n) {
        return this.c.iterator(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CacheItem cacheItem) {
        if (this.f.tryLock()) {
            try {
                this.b.remove(cacheItem.getID());
                this.c.removeAndGetUnsynced((Object)cacheItem);
            }
            finally {
                this.unlockForWrite();
            }
            return;
        }
        List<DelayedWriteJob> list = this.g;
        synchronized (list) {
            if (this.f.tryLock()) {
                try {
                    this.b.remove(cacheItem.getID());
                    this.c.removeAndGetUnsynced((Object)cacheItem);
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.g.add(new d(this, cacheItem));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll(List<CacheItem> list) {
        if (this.f.tryLock()) {
            try {
                this.a(list);
            }
            finally {
                this.unlockForWrite();
            }
            return;
        }
        List<DelayedWriteJob> list2 = this.g;
        synchronized (list2) {
            if (this.f.tryLock()) {
                try {
                    this.a(list);
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.g.add(new b(this, list));
            }
            return;
        }
    }

    private void a(List<CacheItem> list) {
        int n = 0;
        while (n < list.size()) {
            CacheItem cacheItem = list.get(n);
            this.b.remove(cacheItem.getID());
            this.c.removeAndGetUnsynced((Object)cacheItem);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnonymousSynced(CacheItem cacheItem) {
        if (this.f.tryLock()) {
            try {
                this.c.remove((Object)cacheItem);
            }
            finally {
                this.unlockForWrite();
            }
            return;
        }
        List<DelayedWriteJob> list = this.g;
        synchronized (list) {
            if (this.f.tryLock()) {
                try {
                    this.c.remove((Object)cacheItem);
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.g.add(new c(this, cacheItem));
            }
            return;
        }
    }

    public CacheItem consumeSynced(CacheID object) {
        this.f.lock();
        try {
            object = this.b.remove(object);
            this.c.removeAndGetUnsynced(object);
            return object;
        }
        finally {
            this.unlockForWrite();
        }
    }

    public void dumpContent(boolean bl) {
        if (!a.isDebugEnabled()) {
            return;
        }
        this.e.lock();
        try {
            if (!bl) {
                a.debug("size:" + this.b.size());
                if (bl) {
                    for (CacheItem cacheItem : this.b.values()) {
                        a.debug("{}", (Object)cacheItem);
                    }
                }
            } else {
                bl = false;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                for (CacheItem cacheItem : this.b.values()) {
                    ItemState itemState = cacheItem.getUnsyncedState();
                    if (itemState == ItemState.ANONYMOUS) {
                        bl += 1;
                        continue;
                    }
                    if (itemState == ItemState.PERSONALIZED) {
                        if (cacheItem.dataAvailableUnsynced()) {
                            ++n2;
                            continue;
                        }
                        ++n;
                        continue;
                    }
                    if (itemState != ItemState.PERSISTENT) continue;
                    ++n3;
                }
                a.debug("CACHE CONTENT: a=" + (int)(bl ? 1 : 0) + " pu=" + n + " pr=" + n2 + " pers=" + n3);
            }
        }
        finally {
            this.e.unlock();
        }
    }

    public int size() {
        return this.b.size();
    }

    public void lockForWrite() {
        this.f.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void unlockForWrite() {
        block6: {
            if (this.h) break block6;
            this.h = true;
            var2_1 = 0;
            while (true) {
                var3_3 = this.g;
                synchronized (var3_3) {
                    var1_2 = this.g.size();
                    if (var1_2 == var2_1) {
                        this.f.unlock();
                        this.g.clear();
                        this.h = false;
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (true) ** GOTO lbl22
                }
                do {
                    var3_3 = this.g.get(var2_1);
                    var3_3.commit();
                    ++var2_1;
lbl22:
                    // 2 sources

                } while (var2_1 < var1_2);
            }
        }
        this.f.unlock();
    }

    public void lockForRead() {
        this.e.lock();
    }

    public void unlockForRead() {
        this.e.unlock();
    }

    public static abstract class DelayedWriteJob {
        public abstract void commit();
    }

    private final class a
    extends DelayedWriteJob {
        private final CacheItem a;
        private /* synthetic */ GlobalLRU b;

        public a(GlobalLRU globalLRU, CacheItem cacheItem) {
            this.b = globalLRU;
            this.a = cacheItem;
        }

        @Override
        public final void commit() {
            this.b.c.addAtBottomUnsynced((Object)this.a, this.a.getPriority());
        }
    }

    private final class b
    extends DelayedWriteJob {
        private final List<CacheItem> a;
        private /* synthetic */ GlobalLRU b;

        public b(GlobalLRU globalLRU, List<CacheItem> list) {
            this.b = globalLRU;
            this.a = list;
        }

        @Override
        public final void commit() {
            this.b.a(this.a);
        }
    }

    private final class c
    extends DelayedWriteJob {
        private final CacheItem a;
        private /* synthetic */ GlobalLRU b;

        public c(GlobalLRU globalLRU, CacheItem cacheItem) {
            this.b = globalLRU;
            this.a = cacheItem;
        }

        @Override
        public final void commit() {
            this.b.c.remove((Object)this.a);
        }
    }

    private final class d
    extends DelayedWriteJob {
        private final CacheItem a;
        private /* synthetic */ GlobalLRU b;

        public d(GlobalLRU globalLRU, CacheItem cacheItem) {
            this.b = globalLRU;
            this.a = cacheItem;
        }

        @Override
        public final void commit() {
            this.b.b.remove(this.a.getID());
            this.b.c.removeAndGetUnsynced((Object)this.a);
        }
    }

    private final class e
    extends DelayedWriteJob {
        private final CacheItem a;
        private /* synthetic */ GlobalLRU b;

        public e(GlobalLRU globalLRU, CacheItem cacheItem) {
            this.b = globalLRU;
            this.a = cacheItem;
        }

        @Override
        public final void commit() {
            this.b.c.addAtBottomUnsynced((Object)this.a, this.a.getPriority());
        }
    }
}

