/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.BlockedShortArray;
import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.GrouplessID;
import com.agfa.pacs.cache.ICacheItemGroup;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.cache.MemoryAlertHandler;
import com.agfa.pacs.cache.NoHandlerForObjectException;
import com.agfa.pacs.cache.ShortArrayContainer;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.core.ExtensionRecord;
import com.agfa.pacs.instrumentation.IInstrumentor;
import com.agfa.pacs.instrumentation.InstrumentorFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CacheItemGroup;
import com.agfa.pacs.memcache.CacheParameters;
import com.agfa.pacs.memcache.CachedObjectHandlerFactory;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ICachedObjectHandler;
import com.agfa.pacs.memcache.IPersistenceQueue;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.blocked.BlockedShortArrayHandler;
import com.agfa.pacs.memcache.blocked.ByteArrayContainerHandler;
import com.agfa.pacs.memcache.blocked.ShortArrayContainerHandler;
import com.agfa.pacs.memcache.internal.ByteArrayHandler;
import com.agfa.pacs.memcache.internal.CachedByteGroup;
import com.agfa.pacs.memcache.internal.CachedShortGroup;
import com.agfa.pacs.memcache.internal.DiskItemsHash;
import com.agfa.pacs.memcache.internal.DoubleArrayHandler;
import com.agfa.pacs.memcache.internal.FloatArrayHandler;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import com.agfa.pacs.memcache.internal.GroupHash;
import com.agfa.pacs.memcache.internal.IntArrayHandler;
import com.agfa.pacs.memcache.internal.PoolGuard;
import com.agfa.pacs.memcache.internal.ShortArrayHandler;
import com.agfa.pacs.tools.ComputerName;
import com.agfa.pacs.tools.PriorityQueue;
import gnu.java.util.WeakIdentityHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.log4j.Level;

public class DataCache
implements IDataCacheProvider {
    private static final ALogger a = ALogger.getLogger(DataCache.class);
    private static final boolean b = ApplicationManagement.getInstance().getApplicationType().isAgility();
    private static final CacheID c = new CacheID("", -1);
    private final String d;
    private int e = 0;
    private final Map<Object, CacheID> f;
    private final Map<Object, CacheID> g;
    private final HashMap<Object, Object> h = new HashMap<Object, Object>(this){
        private /* synthetic */ DataCache a;
        {
            this.a = dataCache;
        }

        private synchronized ICachedObjectHandler a(Object object) {
            ICachedObjectHandler iCachedObjectHandler = (ICachedObjectHandler)super.get(object = (Class)object);
            if (iCachedObjectHandler != null) {
                return iCachedObjectHandler;
            }
            iCachedObjectHandler = (ExtensionRecord)super.remove(((Class)object).getName());
            if (iCachedObjectHandler != null) {
                iCachedObjectHandler = (ICachedObjectHandler)iCachedObjectHandler.createExtension();
                iCachedObjectHandler.init(this.a);
                super.put(object, iCachedObjectHandler);
                return iCachedObjectHandler;
            }
            return null;
        }

        @Override
        public final /* synthetic */ Object get(Object object) {
            return this.a(object);
        }
    };
    private final GroupHash i = new GroupHash(this);
    private final GlobalLRU j = new GlobalLRU();
    private final IPersistenceQueue k = b ? new a(this) : new c(this);
    private final DiskItemsHash l;
    private final CacheParameters m;
    private PoolGuard n;
    private OutputStream o;

    public DataCache() {
        Object object;
        this.d = "@" + ComputerName.getComputerId() + "@" + System.currentTimeMillis() + "@";
        DataCache.persistenceModifiers[0] = String.valueOf(this.d) + persistenceModifiers[0];
        this.m = new CacheParameters();
        if (this.m.usePersistentStorage()) {
            object = new File(this.m.getLockDirectoryPath());
            if (!((File)object).mkdirs() && !((File)object).exists()) {
                a.error("Couldn't create directory for filelock: " + this.m.getLockDirectoryPath());
            }
            try {
                this.o = new FileOutputStream(new File((File)object, this.d));
            }
            catch (FileNotFoundException fileNotFoundException) {
                a.error("cache readonly", (Throwable)fileNotFoundException);
                throw new RuntimeException("CACHE READONLY");
            }
        }
        this.l = new DiskItemsHash(this, this.d);
        this.h.put(byte[].class, new ByteArrayHandler(this));
        this.h.put(short[].class, new ShortArrayHandler(this));
        this.h.put(float[].class, new FloatArrayHandler(this));
        this.h.put(double[].class, new DoubleArrayHandler(this));
        this.h.put(int[].class, new IntArrayHandler(this));
        this.h.put(ShortArrayContainer.class, new ShortArrayContainerHandler(this));
        this.h.put(BlockedShortArray.class, new BlockedShortArrayHandler(this));
        this.h.put(ByteArrayContainer.class, new ByteArrayContainerHandler(this));
        this.a();
        object = this;
        this.n = new PoolGuard((DataCache)object);
        if (!((DataCache)object).m.isSlowCacheWriting()) {
            ((DataCache)object).n.start();
        }
        this.f = Collections.synchronizedMap(new WeakIdentityHashMap());
        this.g = Collections.synchronizedMap(new WeakIdentityHashMap());
    }

    private void a() {
        ExtensionRecord extensionRecord2 = CachedObjectHandlerFactory.getHandlers();
        for (ExtensionRecord extensionRecord2 : extensionRecord2) {
            this.h.put(extensionRecord2.getAttribute("handledClass"), extensionRecord2);
        }
    }

    public GlobalLRU getGlobalLRU() {
        return this.j;
    }

    public DiskItemsHash getOnDisk() {
        return this.l;
    }

    public File getFile(CacheID cacheID, Class<?> clazz) {
        CacheItem cacheItem = this.j.get(cacheID);
        if (cacheItem == null) {
            cacheItem = this.l.getItem(cacheID, clazz, this);
        }
        if (cacheItem == null) {
            return null;
        }
        return new File(cacheItem.getPersistenceGroup().getPersistentLocation(cacheID));
    }

    public CacheParameters getParameters() {
        return this.m;
    }

    public synchronized CacheID createID() {
        return new GrouplessID(String.valueOf(persistenceModifiers[0]) + File.separatorChar + Integer.toString(++this.e), 0);
    }

    public CacheID createID(String string, String string2, int n) {
        if (n == 2) {
            return new CacheID(String.valueOf(persistenceModifiers[n]) + File.separatorChar + string + File.separatorChar + string2, 2);
        }
        if (n == 0) {
            string = String.valueOf(string) + "_temp";
        }
        if (this.m.isPermanent()) {
            return new CacheID(String.valueOf(persistenceModifiers[n]) + File.separatorChar + string + File.separatorChar + string2, n);
        }
        if (n == 1) {
            n = 0;
        }
        StringBuilder stringBuilder = new StringBuilder(180);
        stringBuilder.append(persistenceModifiers[n]).append(File.separatorChar);
        stringBuilder.append(string).append(File.separatorChar);
        stringBuilder.append(string2);
        return new CacheID(stringBuilder.toString(), n);
    }

    public byte[] allocBytes(long l) {
        return this.allocBytes(l, 30);
    }

    public byte[] allocBytes(long l, int n) {
        Object object = this.i.getByteGroup(l);
        if (this.g.put(object = (Object)((byte[])object.allocateObject(false, n)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public byte[] allocAndClearBytes(long l) {
        Object object = this.i.getByteGroup(l);
        if (this.g.put(object = (Object)((byte[])object.allocateObject(true, 30)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public void free(byte[] byArray) {
        this.g.remove(byArray);
        if (this.f.put(byArray, c) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(byArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getByteGroup(byArray.length);
        iCachedObjectGroup.free(byArray);
    }

    public byte[] getContentBytes(CacheID cacheID) {
        Object object = this.j.consumeSynced(cacheID);
        if (object == null) {
            return null;
        }
        ((CacheItem)object).removeFromGroupUnsynced();
        object = (byte[])((CacheItem)object).claimItemSynced();
        if (this.g.remove(object) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.remove(object);
        return object;
    }

    public byte[] referencePersistentBytes(CacheID cacheID) {
        Object object = this.j.get(cacheID);
        if (object == null && (object = this.l.getItem(cacheID, byte[].class, this)) == null) {
            throw new IllegalArgumentException("id not known to cache " + cacheID);
        }
        CacheID cacheID2 = this.g.put(object = (Object)((byte[])((CacheItem)object).getPersistenceGroup().getPersistent((CacheItem)object, cacheID)), cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.put(object, cacheID);
        return object;
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID) {
        this.putContentBytes(byArray, cacheID, 30);
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID, int n) {
        this.g.remove(byArray);
        if (this.f.put(byArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getByteGroup(byArray.length);
        iCachedObjectGroup.putPersonalized(byArray, cacheID, n);
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID) {
        this.addPersistentBytes(byArray, cacheID, 30);
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID, int n) {
        Object object = this.g.remove(byArray);
        if (object != null && object != c && !object.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + object + " and not " + cacheID);
        }
        if (this.f.put(byArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        object = this.i.getByteGroup(byArray.length);
        object.addPersistent(byArray, cacheID, n);
    }

    public void releaseModifiedReference(CacheID cacheID) {
        CacheItem cacheItem = this.j.get(cacheID);
        if (cacheItem == null) {
            throw new IllegalStateException("reference count underrun for " + cacheID);
        }
        this.g.remove(cacheItem.getItemUnsynced());
        cacheItem.updateAndReleaseReferenceSynced();
        cacheItem.touch();
        this.k.addAtBottom(cacheItem);
    }

    public short[] allocShorts(long l) {
        return this.allocShorts(l, 30);
    }

    public short[] allocShorts(long l, int n) {
        Object object = this.i.getShortGroup(l);
        if (this.g.put(object = (Object)((short[])object.allocateObject(false, n)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public short[] allocAndClearShorts(long l) {
        Object object = this.i.getShortGroup(l);
        if (this.g.put(object = (Object)((short[])object.allocateObject(true, 30)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public void free(short[] sArray) {
        this.g.remove(sArray);
        if (this.f.put(sArray, c) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(sArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getShortGroup(sArray.length);
        iCachedObjectGroup.free(sArray);
    }

    public short[] getContentShorts(CacheID cacheID) {
        Object object = this.j.consumeSynced(cacheID);
        if (object == null) {
            return null;
        }
        ((CacheItem)object).removeFromGroupUnsynced();
        object = (short[])((CacheItem)object).claimItemSynced();
        if (this.g.remove(object) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.remove(object);
        return object;
    }

    public short[] referencePersistentShorts(CacheID cacheID) {
        Object object = this.j.get(cacheID);
        if (object == null && (object = this.l.getItem(cacheID, short[].class, this)) == null) {
            throw new IllegalArgumentException();
        }
        CacheID cacheID2 = this.g.put(object = (Object)((short[])((CacheItem)object).getPersistenceGroup().getPersistent((CacheItem)object, cacheID)), cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.put(object, cacheID);
        return object;
    }

    public void putContentShorts(short[] sArray, CacheID cacheID) {
        this.putContentShorts(sArray, cacheID, 30);
    }

    public void putContentShorts(short[] sArray, CacheID cacheID, int n) {
        this.g.remove(sArray);
        if (this.f.put(sArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getShortGroup(sArray.length);
        iCachedObjectGroup.putPersonalized(sArray, cacheID, n);
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID) {
        this.addPersistentShorts(sArray, cacheID, 30);
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID, int n) {
        Object object = this.g.remove(sArray);
        if (object != null && object != c && !object.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + object + " and not " + cacheID);
        }
        if (this.f.put(sArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        object = this.i.getShortGroup(sArray.length);
        object.addPersistent(sArray, cacheID, n);
    }

    public int[] allocInts(long l) {
        return this.allocInts(l, 30);
    }

    public int[] allocInts(long l, int n) {
        Object object = this.i.getIntGroup(l);
        if (this.g.put(object = (Object)((int[])object.allocateObject(false, n)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public int[] allocAndClearInts(long l) {
        Object object = this.i.getIntGroup(l);
        if (this.g.put(object = (Object)((int[])object.allocateObject(true, 30)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public void free(int[] nArray) {
        this.g.remove(nArray);
        if (this.f.put(nArray, c) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(nArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getIntGroup(nArray.length);
        iCachedObjectGroup.free(nArray);
    }

    public int[] getContentInts(CacheID cacheID) {
        Object object = this.j.consumeSynced(cacheID);
        if (object == null) {
            return null;
        }
        ((CacheItem)object).removeFromGroupUnsynced();
        object = (int[])((CacheItem)object).claimItemSynced();
        if (this.g.remove(object) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.remove(object);
        return object;
    }

    public int[] referencePersistentInts(CacheID cacheID) {
        Object object = this.j.get(cacheID);
        if (object == null && (object = this.l.getItem(cacheID, int[].class, this)) == null) {
            throw new IllegalArgumentException();
        }
        CacheID cacheID2 = this.g.put(object = (Object)((int[])((CacheItem)object).getPersistenceGroup().getPersistent((CacheItem)object, cacheID)), cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.put(object, cacheID);
        return object;
    }

    public void putContentInts(int[] nArray, CacheID cacheID) {
        this.putContentInts(nArray, cacheID, 30);
    }

    public void putContentInts(int[] nArray, CacheID cacheID, int n) {
        this.g.remove(nArray);
        if (this.f.put(nArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getIntGroup(nArray.length);
        iCachedObjectGroup.putPersonalized(nArray, cacheID, n);
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID) {
        this.addPersistentInts(nArray, cacheID, 30);
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID, int n) {
        Object object = this.g.remove(nArray);
        if (object != null && object != c && !object.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + object + " and not " + cacheID);
        }
        if (this.f.put(nArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        object = this.i.getIntGroup(nArray.length);
        object.addPersistent(nArray, cacheID, n);
    }

    public float[] allocFloats(long l) {
        Object object = this.i.getFloatGroup(l);
        if (this.g.put(object = (Object)((float[])object.allocateObject(false, 30)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public float[] allocAndClearFloats(long l) {
        Object object = this.i.getFloatGroup(l);
        if (this.g.put(object = (Object)((float[])object.allocateObject(true, 30)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public void free(float[] fArray) {
        this.g.remove(fArray);
        if (this.f.put(fArray, c) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(fArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getFloatGroup(fArray.length);
        iCachedObjectGroup.free(fArray);
    }

    public float[] getContentFloats(CacheID cacheID) {
        Object object = this.j.consumeSynced(cacheID);
        if (object == null) {
            return null;
        }
        ((CacheItem)object).removeFromGroupUnsynced();
        object = (float[])((CacheItem)object).claimItemSynced();
        if (this.g.remove(object) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.remove(object);
        return object;
    }

    public float[] referencePersistentFloats(CacheID cacheID) {
        Object object = this.j.get(cacheID);
        if (object == null && (object = this.l.getItem(cacheID, float[].class, this)) == null) {
            throw new IllegalArgumentException();
        }
        CacheID cacheID2 = this.g.put(object = (Object)((float[])((CacheItem)object).getPersistenceGroup().getPersistent((CacheItem)object, cacheID)), cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.put(object, cacheID);
        return object;
    }

    public void putContentFloats(float[] fArray, CacheID cacheID) {
        this.g.remove(fArray);
        if (this.f.put(fArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getFloatGroup(fArray.length);
        iCachedObjectGroup.putPersonalized(fArray, cacheID, 30);
    }

    public void addPersistentFloats(float[] fArray, CacheID cacheID) {
        Object object = this.g.remove(fArray);
        if (object != null && object != c && !object.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + object + " and not " + cacheID);
        }
        if (this.f.put(fArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        object = this.i.getFloatGroup(fArray.length);
        object.addPersistent(fArray, cacheID, 30);
    }

    public double[] allocDoubles(long l) {
        Object object = this.i.getDoubleGroup(l);
        if (this.g.put(object = (Object)((double[])object.allocateObject(false, 30)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public double[] allocAndClearDoubles(long l) {
        Object object = this.i.getDoubleGroup(l);
        if (this.g.put(object = (Object)((double[])object.allocateObject(true, 30)), c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(object));
        }
        this.f.remove(object);
        return object;
    }

    public void free(double[] dArray) {
        this.g.remove(dArray);
        if (this.f.put(dArray, c) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(dArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getDoubleGroup(dArray.length);
        iCachedObjectGroup.free(dArray);
    }

    public double[] getContentDoubles(CacheID cacheID) {
        Object object = this.j.consumeSynced(cacheID);
        if (object == null) {
            return null;
        }
        ((CacheItem)object).removeFromGroupUnsynced();
        object = (double[])((CacheItem)object).claimItemSynced();
        if (this.g.remove(object) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.remove(object);
        return object;
    }

    public double[] referencePersistentDoubles(CacheID cacheID) {
        Object object = this.j.get(cacheID);
        if (object == null && (object = this.l.getItem(cacheID, double[].class, this)) == null) {
            throw new IllegalArgumentException();
        }
        CacheID cacheID2 = this.g.put(object = (Object)((double[])((CacheItem)object).getPersistenceGroup().getPersistent((CacheItem)object, cacheID)), cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.put(object, cacheID);
        return object;
    }

    public void putContentDoubles(double[] dArray, CacheID cacheID) {
        this.g.remove(dArray);
        if (this.f.put(dArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.i.getDoubleGroup(dArray.length);
        iCachedObjectGroup.putPersonalized(dArray, cacheID, 30);
    }

    public void addPersistentDoubles(double[] dArray, CacheID cacheID) {
        Object object = this.g.remove(dArray);
        if (object != null && object != c && !object.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + object + " and not " + cacheID);
        }
        if (this.f.put(dArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        object = this.i.getDoubleGroup(dArray.length);
        object.addPersistent(dArray, cacheID, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocObject(Class<?> object, Object[] objectArray) {
        ICachedObjectGroup iCachedObjectGroup;
        object = this.a((Class<?>)object);
        Object object2 = object.getGroupID(objectArray);
        Object object3 = this.i;
        synchronized (object3) {
            iCachedObjectGroup = (ICachedObjectGroup)this.i.get(object2);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = object.createGroup(object2, objectArray);
                this.i.put(object2, iCachedObjectGroup);
            }
        }
        object3 = iCachedObjectGroup.allocateObject(false, objectArray, 30);
        if (this.g.put(object3, c) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + object3);
        }
        this.f.remove(object3);
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Object object) {
        ICachedObjectGroup iCachedObjectGroup;
        this.g.remove(object);
        if (this.f.put(object, c) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + object);
        }
        ICachedObjectHandler iCachedObjectHandler = this.a(object.getClass());
        Object object2 = iCachedObjectHandler.getGroupID(null, object);
        if (object2 == null) {
            return;
        }
        GroupHash groupHash = this.i;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.i.get(object2);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup(object2, object);
                this.i.put(object2, iCachedObjectGroup);
            }
        }
        iCachedObjectGroup.free(object);
    }

    private ICachedObjectHandler a(Class<?> clazz) {
        do {
            ICachedObjectHandler iCachedObjectHandler;
            if ((iCachedObjectHandler = (ICachedObjectHandler)this.h.get(clazz)) != null) {
                return iCachedObjectHandler;
            }
            iCachedObjectHandler = this.b(clazz);
            if (iCachedObjectHandler == null) continue;
            return iCachedObjectHandler;
        } while ((clazz = clazz.getSuperclass()) != null);
        throw new NoHandlerForObjectException();
    }

    private ICachedObjectHandler b(Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            clazz = classArray[n2];
            ICachedObjectHandler iCachedObjectHandler = (ICachedObjectHandler)this.h.get(clazz);
            if (iCachedObjectHandler != null) {
                return iCachedObjectHandler;
            }
            iCachedObjectHandler = this.b(clazz);
            if (iCachedObjectHandler != null) {
                return iCachedObjectHandler;
            }
            ++n2;
        }
        return null;
    }

    public Object getContentObject(CacheID cacheID) {
        Object object = this.j.consumeSynced(cacheID);
        if (object == null) {
            return null;
        }
        ((CacheItem)object).removeFromGroupUnsynced();
        object = ((CacheItem)object).claimItemSynced();
        if (this.g.remove(object) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.remove(object);
        return object;
    }

    public Object referencePersistentObject(CacheID cacheID, Class<?> object) {
        CacheItem cacheItem = this.j.get(cacheID);
        if (cacheItem == null && (cacheItem = this.l.getItem(cacheID, (Class<?>)object, this)) == null) {
            if (this.a((Class<?>)object) == null) {
                throw new NoHandlerForObjectException();
            }
            throw new IllegalArgumentException("Item " + cacheID + " of type " + object + " not found in memory or on disk!");
        }
        object = cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        if ((cacheItem = this.g.put(object, cacheID)) != null && !cacheItem.equals(cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.f.put(object, cacheID);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContentObject(Object object, CacheID cacheID) {
        ICachedObjectGroup iCachedObjectGroup;
        this.g.remove(object);
        if (this.f.put(object, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectHandler iCachedObjectHandler = this.a(object.getClass());
        Object object2 = iCachedObjectHandler.getGroupID(cacheID, object);
        if (object2 == null) {
            return;
        }
        GroupHash groupHash = this.i;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.i.get(object2);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup(object2, object);
                this.i.put(object2, iCachedObjectGroup);
            }
        }
        iCachedObjectGroup.putPersonalized(object, cacheID, 30);
    }

    public void addPersistentObject(Object object, CacheID cacheID) {
        this.addPersistentObject(object, object.getClass(), cacheID);
    }

    public void addPersistentObject(Object object, CacheID cacheID, int n) {
        this.addPersistentObject(object, object.getClass(), cacheID);
    }

    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID) {
        this.addPersistentObject(object, clazz, cacheID, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentObject(Object object, Class<?> object2, CacheID cacheID, int n) {
        ICachedObjectGroup iCachedObjectGroup;
        Object object3 = this.g.remove(object);
        if (object3 != null && object3 != c && !object3.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + object3 + " and not " + cacheID);
        }
        if (this.f.put(object, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        object3 = (object2 = this.a((Class<?>)object2)).getGroupID(cacheID, object);
        if (object3 == null) {
            return;
        }
        GroupHash groupHash = this.i;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.i.get(object3);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = object2.createGroup((Object)cacheID, object);
                this.i.put(object3, iCachedObjectGroup);
            }
        }
        iCachedObjectGroup.addPersistent(object, cacheID, n);
    }

    public Iterator<ICacheItemGroup> listItemGroups() {
        ArrayList<CacheItemGroup> arrayList;
        Collections.emptyList();
        this.j.lockForRead();
        try {
            Object object = this.j.getGroupNames();
            object.addAll(Arrays.asList(this.l.getGroupNames()));
            arrayList = new ArrayList<CacheItemGroup>(object.size());
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                arrayList.add(new CacheItemGroup((String)object, this));
            }
        }
        finally {
            this.j.unlockForRead();
        }
        return arrayList.iterator();
    }

    public void remove(CacheID cacheID) {
        this.j.runAsyncWithReadlock(new b(this, cacheID));
    }

    public void flush(CacheID object) {
        if ((object = this.j.get((CacheID)object)) == null) {
            return;
        }
        ((CacheItem)object).writePersistent();
    }

    public void flushGroup(Class<?> object, CacheID cacheID) {
        if ((object = this.getGroupFor((Class<?>)object, cacheID, 0L, false)) != null) {
            Object object2 = object.getItemMembers();
            String[] stringArray = object2;
            int n = ((String[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object2 = stringArray[n2];
                object2 = this.j.get(this.createID(cacheID.getGroup(), (String)object2, cacheID.getType()));
                if (object2 != null) {
                    ((CacheItem)object2).writePersistent();
                }
                ++n2;
            }
            object.flush();
        }
    }

    public void releaseModifiedArrayReference(CacheID cacheID, long[] lArray, long[] lArray2) {
        this.releaseModifiedReference(cacheID);
    }

    public void ensureFreeMemory(long l) {
        this.j.dumpContent(false);
        if (l == -1L) {
            l = Long.MAX_VALUE;
        }
        if ((l -= this.m.getFreeMem()) <= 0L) {
            return;
        }
        l = Math.max(2000000L, l);
        IInstrumentor iInstrumentor = InstrumentorFactory.getInstrumentor();
        String string = iInstrumentor.createTUID();
        iInstrumentor.recordStart(string, "ia_low_memory", "toFree=" + l, Level.WARN);
        try {
            l -= this.n.memoryAlert(l, false);
            if (l <= 0L) {
                return;
            }
            if ((l = MemoryAlertHandler.fireMemoryAlert((long)l, (boolean)false)) > 0L) {
                l = MemoryAlertHandler.fireMemoryAlert((long)l, (boolean)true);
            }
            if (l > 0L) {
                l = this.n.memoryAlert(l, true);
            }
        }
        finally {
            iInstrumentor.recordStop(string, "ia_low_memory", "toFree=" + l, Level.WARN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Class<?> clazz, CacheID object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        CacheItem cacheItem = this.j.get((CacheID)object);
        if (cacheItem == null) {
            cacheItem = this.l.getItem((CacheID)object, clazz, this);
        }
        if (bl = cacheItem != null) {
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                object = cacheItem;
                synchronized (object) {
                    block8: {
                        if (cacheItem.getUnsyncedState() != ItemState.DELETED) break block8;
                        cacheItem.removeUnsynced(false);
                        return false;
                    }
                    cacheItem.touch();
                }
            }
            cacheItem.touch();
        }
        return bl;
    }

    public boolean isInCache(Class<?> clazz, CacheID cacheID) {
        return this.exists(clazz, cacheID);
    }

    public boolean isInMemory(CacheID object) {
        if (object == null) {
            return false;
        }
        if ((object = this.j.get((CacheID)object)) == null) {
            return false;
        }
        return ((CacheItem)object).dataAvailableUnsynced();
    }

    public ICachedObjectGroup getGroupFor(Class<?> clazz, CacheID cacheID, long l) {
        return this.getGroupFor(clazz, cacheID, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedObjectGroup getGroupFor(Class<?> object, CacheID cacheID, long l, boolean bl) {
        ICachedObjectGroup iCachedObjectGroup;
        Object object2 = (object = this.a((Class<?>)object)).getGroupID(cacheID, l);
        if (object2 == null) {
            return null;
        }
        GroupHash groupHash = this.i;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.i.get(object2);
            if (iCachedObjectGroup == null && bl) {
                iCachedObjectGroup = object.createGroup(cacheID, l);
                if (iCachedObjectGroup != null) {
                    this.i.put(object2, iCachedObjectGroup);
                }
            } else if (iCachedObjectGroup != null && iCachedObjectGroup.isDestroyed()) {
                throw new IllegalStateException();
            }
        }
        return iCachedObjectGroup;
    }

    public IPersistenceQueue getPersistenceQueue() {
        return this.k;
    }

    public void dumpByteGroup(long l, boolean bl) {
        ((CachedByteGroup)this.i.get(Long.toString(Long.MIN_VALUE | l))).dumpContent(bl);
    }

    public void releaseReference(CacheID cacheID) {
        CacheItem cacheItem = this.j.get(cacheID);
        if (cacheItem == null) {
            throw new IllegalStateException("reference count underrun " + cacheID);
        }
        this.g.remove(cacheItem.getItemUnsynced());
        cacheItem.releaseReferenceSynced();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        this.n.writePersistentQueueContent(false);
        this.n.waitUntilPersistentFinished();
        GroupHash groupHash = this.i;
        synchronized (groupHash) {
            for (ICachedObjectGroup iCachedObjectGroup : this.i.values()) {
                iCachedObjectGroup.flush();
            }
        }
        this.l.ensureDiskSize();
    }

    public void clearTempData() {
        this.l.clearTempData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWriting() {
        this.n.shutdownWithoutWriting();
        GroupHash groupHash = this.i;
        synchronized (groupHash) {
            for (ICachedObjectGroup iCachedObjectGroup : this.i.values()) {
                iCachedObjectGroup.flush();
            }
            return;
        }
    }

    public void deleteCache() {
        int n;
        Object object = this;
        try {
            ((DataCache)object).o.close();
        }
        catch (IOException iOException) {
            a.warn("Error while releasing the cache lock: ", (Throwable)iOException);
        }
        System.gc();
        object = new File(this.m.getLockDirectoryPath());
        Object object2 = ((File)object).list();
        boolean bl = true;
        if (object2 != null) {
            String[] stringArray = object2;
            n = ((String[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object2 = stringArray[n2];
                bl = (object2 = new File((File)object, (String)object2)).delete();
                if (!bl) break;
                ++n2;
            }
        }
        if (bl) {
            object2 = new File(this.m.getLocation());
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = DataCache.a((File)object2, stringBuilder);
            n = bl2 ? 1 : 0;
            if (!bl2) {
                a.warn("Some files / directories could not be deleted from the cache during application shutdown:\n" + stringBuilder.toString());
                return;
            }
            a.info("Cache was successfully deleted.");
            return;
        }
        a.info("Cache was not deleted, because probably another instance of the Diagnostic Desktop is currently running!");
    }

    private static boolean a(File file, StringBuilder stringBuilder) {
        boolean bl;
        Object object;
        boolean bl2 = true;
        if (file.isDirectory() && (object = file.listFiles()) != null) {
            File[] fileArray = object;
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                object = fileArray[n2];
                boolean bl3 = DataCache.a((File)object, stringBuilder);
                if (!bl3) {
                    bl2 = false;
                    DataCache.a(stringBuilder, (File)object);
                }
                ++n2;
            }
        }
        if (!(bl = !file.exists() || file.delete())) {
            bl2 = false;
            DataCache.a(stringBuilder, file);
        }
        return bl2;
    }

    private static void a(StringBuilder stringBuilder, File file) {
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append(System.getProperty("line.separator"));
    }

    public CachedShortGroup getShortGroup(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.i.getShortGroup(l);
        return (CachedShortGroup)iCachedObjectGroup;
    }

    public CachedByteGroup getByteGroup(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.i.getByteGroup(l);
        return (CachedByteGroup)iCachedObjectGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object;
        Object object2;
        ArrayList<CacheID> arrayList;
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("currently outside:\n");
        Map<Object, CacheID> map = this.g;
        synchronized (map) {
            arrayList = new ArrayList<CacheID>(this.g.values());
        }
        int n = 0;
        while (n < arrayList.size()) {
            object2 = this.j.get(arrayList.get(n));
            object = object2 != null ? ((CacheItem)object2).getItemUnsynced() : null;
            int n2 = 0;
            if (object instanceof short[]) {
                n2 = ((short[])object).length;
            } else if (object instanceof int[]) {
                n2 = ((int[])object).length;
            } else if (object instanceof byte[]) {
                n2 = ((byte[])object).length;
            }
            if (object2 != null) {
                stringBuilder.append("s:" + n2 + " " + ((CacheItem)object2).toString() + "\n");
            } else {
                stringBuilder.append("s:" + n2 + " unmanaged " + arrayList.get(n) + "\n");
            }
            ++n;
        }
        stringBuilder.append(String.valueOf(arrayList.size()) + " items\n");
        n = 0;
        this.j.lockForRead();
        try {
            object2 = this.j.getItemIterator(30);
            while (object2.hasNext()) {
                object = (CacheItem)object2.next();
                if (!((CacheItem)object).isReferencedUnsynced()) continue;
                ++n;
                stringBuilder.append("referenced " + ((CacheItem)object).toString() + "\n");
            }
        }
        finally {
            this.j.unlockForRead();
        }
        stringBuilder.append(String.valueOf(n) + " referenced items");
        return stringBuilder.toString();
    }

    public void setItemPriority(CacheID object, int n) {
        if (b && (object = this.j.get((CacheID)object)) != null) {
            ((CacheItem)object).setPriority(n);
        }
    }

    public int getItemPriority(CacheID cacheID) {
        CacheItem cacheItem = this.j.get(cacheID);
        if (cacheItem != null) {
            return cacheItem.getPriority();
        }
        cacheItem = this.l.sniffItem(cacheID);
        if (cacheItem != null) {
            return cacheItem.getPriority();
        }
        return 0;
    }

    public long availableMemory(int n) {
        long l = this.m.getFreeMem();
        this.j.lockForRead();
        try {
            Iterator<CacheItem> iterator = this.j.getItemIterator(n);
            while (iterator.hasNext()) {
                CacheItem cacheItem = iterator.next();
                if (!cacheItem.dataAvailableUnsynced()) continue;
                l += cacheItem.getManagementGroup().getSizeEstimate(null);
            }
        }
        finally {
            this.j.unlockForRead();
        }
        return l;
    }

    public long getFreeMemory() {
        return this.m.getFreeMem();
    }

    public void removeFromOutside(Object object) {
        this.g.remove(object);
    }

    public boolean startupComplete() {
        return this.l.startupComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPoolActive(Object object, CacheID cacheID) {
        ICachedObjectGroup iCachedObjectGroup;
        ICachedObjectHandler iCachedObjectHandler = this.a(object.getClass());
        Object object2 = iCachedObjectHandler.getGroupID(cacheID, object);
        if (object2 == null) {
            return false;
        }
        GroupHash groupHash = this.i;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.i.get(object2);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup((Object)cacheID, object);
                this.i.put(object2, iCachedObjectGroup);
            }
        }
        return iCachedObjectGroup.usesPool();
    }

    public String getGroupAttribute(CacheID object, Class<?> clazz, String string) {
        if ((object = this.getGroupFor(clazz, (CacheID)object, 0L, true)) != null) {
            try {
                return object.getGroupAttribute(string);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public void setGroupAttribute(CacheID object, Class<?> clazz, String string, String string2) {
        object = this.getGroupFor(clazz, (CacheID)object, 0L, true);
        try {
            object.setGroupAttribute(string, string2);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("failed to set group attribute: " + string + " to: " + string2, iOException);
        }
    }

    public void deleteGroupAttribute(CacheID object, Class<?> clazz, String string) {
        if ((object = this.getGroupFor(clazz, (CacheID)object, 0L, true)) != null) {
            try {
                object.deleteGroupAttribute(string);
                return;
            }
            catch (IOException iOException) {
                throw new IllegalStateException("failed to delete group attribute: " + string, iOException);
            }
        }
    }

    public ICacheItemGroup getItemGroup(String string) {
        if (this.i.containsKey(string)) {
            return new CacheItemGroup(string, this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ICachedObjectGroup a(Class<?> object, CacheID object2) {
        object = this.a((Class<?>)object);
        if ((object = object.getGroupID((CacheID)object2, 0L)) == null) {
            return null;
        }
        object2 = this.i;
        synchronized (object2) {
            block6: {
                object = (ICachedObjectGroup)this.i.remove(object);
                if (object != null) break block6;
                return null;
            }
            if (object.isDestroyed()) {
                throw new IllegalStateException();
            }
        }
        return object;
    }

    public void purgeEmptyGroups() {
        this.i.purgeEmptyGroups();
    }

    private final class a
    extends PriorityQueue<CacheItem>
    implements IPersistenceQueue {
        private /* synthetic */ DataCache a;

        a(DataCache dataCache) {
            this.a = dataCache;
            super(31, 31);
        }

        @Override
        public final void clear() {
        }

        @Override
        public final void addAtBottom(CacheItem cacheItem) {
            this.a(cacheItem, cacheItem.getPriority());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean a(CacheItem cacheItem, int n) {
            if (this.a.m.usePersistentStorage()) {
                a a2 = this;
                synchronized (a2) {
                    return super.addAtBottom((Object)cacheItem, n);
                }
            }
            return false;
        }

        @Override
        public final void addAtTop(CacheItem cacheItem) {
            this.b(cacheItem, cacheItem.getPriority());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean b(CacheItem cacheItem, int n) {
            if (this.a.m.usePersistentStorage()) {
                a a2 = this;
                synchronized (a2) {
                    return super.addAtBottom((Object)cacheItem, n);
                }
            }
            return false;
        }

        @Override
        public final CacheItem poll() {
            return (CacheItem)this.consume(Integer.MAX_VALUE);
        }

        @Override
        public final void updatePriority(CacheItem cacheItem) {
            this.changePriority(cacheItem, cacheItem.getPriority(), true);
        }

        public final /* synthetic */ boolean addAtTop(Object object, int n) {
            return this.b((CacheItem)object, n);
        }

        public final /* synthetic */ boolean addAtBottom(Object object, int n) {
            return this.a((CacheItem)object, n);
        }
    }

    private final class b
    extends GlobalLRU.DelayedWriteJob {
        private final CacheID a;
        private /* synthetic */ DataCache b;

        public b(DataCache dataCache, CacheID cacheID) {
            this.b = dataCache;
            this.a = cacheID;
        }

        @Override
        public final void commit() {
            CacheItem cacheItem = this.b.j.getUnsynced(this.a);
            if (cacheItem == null && (cacheItem = this.b.l.sniffItem(this.a)) == null) {
                return;
            }
            cacheItem.removeUnsynced(false);
        }
    }

    private final class c
    extends LinkedBlockingDeque<CacheItem>
    implements IPersistenceQueue {
        private /* synthetic */ DataCache a;

        c(DataCache dataCache) {
            this.a = dataCache;
        }

        @Override
        public final void addAtBottom(CacheItem cacheItem) {
            if (this.a.m.usePersistentStorage()) {
                super.addLast(cacheItem);
            }
        }

        @Override
        public final void addAtTop(CacheItem cacheItem) {
            if (this.a.m.usePersistentStorage()) {
                super.addFirst(cacheItem);
            }
        }

        @Override
        public final void updatePriority(CacheItem cacheItem) {
        }
    }
}

