/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.lw.datainfo.impl;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.instanceinfo.Availability;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.DicomGetInstanceInfo;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.lw.impl.IntermediateDataInfo;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class SeriesInfo
extends IntermediateDataInfo
implements ISeriesInfo {
    private static final ALogger log = ALogger.getLogger(SeriesInfo.class);
    private Availability availability = null;

    public SeriesInfo(IDataInfo iDataInfo, Attributes attributes, String string) {
        super(attributes, iDataInfo, string);
    }

    public SeriesInfo(IDataInfo iDataInfo, String string) {
        super(iDataInfo, string);
    }

    public String toString() {
        return "      Series (" + this.key + "): " + this.getSeriesUID() + ", " + this.getString(524384) + "\n" + super.toString();
    }

    public String getSeriesUID() {
        return this.key;
    }

    public String getUID() {
        return this.key;
    }

    public void setUID(String string) {
        this.dataset.setString(0x20000E, VR.UI, string);
        this.key = string;
    }

    public Level getLevel() {
        return Level.Series;
    }

    public List<IObjectInfo> getInstances() {
        return this.children();
    }

    public Availability getAvailability() {
        if (this.availability == null) {
            this.availability = Availability.get((Attributes)this.dataset, (String)this.getSource().getSourceAET());
            if (this.availability == null) {
                this.availability = Availability.ONLINE;
            }
        }
        return this.availability;
    }

    public boolean canBeCached() {
        return false;
    }

    public List<IObjectInfo> getAllInstances() {
        return this.children();
    }

    public int[] getFrameSelection() {
        throw new UnsupportedOperationException();
    }

    public IInstanceInfo getInstanceInfo() {
        return DicomGetInstanceInfo.singleton;
    }

    public String getStudyUID() {
        return ((IStudyInfo)this.getTreeParent()).getStudyUID();
    }

    public boolean isFrameSelection() {
        return false;
    }

    public ILoadableInfo.LoadableType getType() {
        return ILoadableInfo.LoadableType.Serie;
    }

    public IPatientInfo getPatient() {
        return (IPatientInfo)this.getTreeParent().getTreeParent();
    }

    public String getSOPClassUID() {
        return ((IObjectInfo)this.children().get(0)).getSOPClassUID();
    }

    public String getSOPInstanceUID() {
        throw new IllegalStateException();
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    public IStudyInfo getStudy() {
        return (IStudyInfo)this.treeParent;
    }

    public synchronized <U extends IObjectInfo> U createInstance(Class<U> clazz, String string, String string2, boolean bl) {
        return this.createInstance(clazz, string, string2, bl, new Attributes());
    }

    public <U extends IObjectInfo> U createInstance(Class<U> clazz, String string, String string2, boolean bl, Attributes attributes) {
        IObjectInfo iObjectInfo;
        String string3;
        Date date = new Date();
        try {
            Constructor<U> constructor = clazz.getConstructor(IDataInfo.class, Attributes.class, String.class);
            string3 = UIDUtils.createUID();
            iObjectInfo = (IObjectInfo)constructor.newInstance(new Object[]{this, attributes, string3});
        }
        catch (Exception exception) {
            log.error("Could not create a new instance", (Throwable)exception);
            throw new IllegalArgumentException(exception);
        }
        if (string2 != null) {
            iObjectInfo.getAttributes().setString(131088, VR.UI, string2);
        }
        if (string != null) {
            iObjectInfo.getAttributes().setString(524310, VR.UI, string);
        }
        iObjectInfo.getAttributes().setString(524312, VR.UI, string3);
        iObjectInfo.getAttributes().setInt(2097171, VR.IS, new int[]{this.getMaxInstanceNumber() + 1});
        iObjectInfo.getAttributes().setDate(2251877123620883L, date);
        if (bl) {
            this.addChild((IDataInfo)iObjectInfo);
        }
        return (U)iObjectInfo;
    }

    private int getMaxInstanceNumber() {
        int n = 0;
        for (IDataInfo iDataInfo : this.children()) {
            int n2 = iDataInfo.getInt(2097171);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public Level getHierarchyLevel() {
        return Level.Series;
    }

    public boolean hasInstance(String string) {
        return this.duplicateCheck.contains(string);
    }
}

