/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.remote;

import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.util.CancelableCollector;
import com.agfa.pacs.listtext.dicomobject.module.print.ImageFormat;
import com.agfa.pacs.listtext.dicomobject.module.print.Media;
import com.agfa.pacs.listtext.dicomobject.module.print.PrinterConfigurationItem;
import com.agfa.pacs.listtext.dicomobject.type.print.Density;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmDestination;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmOrientation;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmSizeID;
import com.agfa.pacs.listtext.dicomobject.type.print.PrintPriority;
import com.agfa.pacs.listtext.lta.print.IFormat;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import com.agfa.pacs.listtext.lta.print.IPrintConfigurationListener;
import com.agfa.pacs.listtext.lta.print.IPrintSetting;
import com.agfa.pacs.listtext.lta.print.IPrinter;
import com.agfa.pacs.listtext.lta.print.PageSetting;
import com.agfa.pacs.listtext.lta.print.impl.PreviewMedium;
import com.agfa.pacs.listtext.lta.print.impl.PrintJob;
import com.agfa.pacs.listtext.lta.print.remote.AnnotationUtils;
import com.agfa.pacs.listtext.lta.print.remote.DicomConfigProvider;
import com.agfa.pacs.listtext.lta.print.remote.DicomSettingPanel;
import com.agfa.pacs.listtext.lta.print.util.ConfigurationUtils;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.IFilmSize;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.IPrintContextListener;
import com.agfa.pacs.listtext.print.PrintColor;
import com.agfa.pacs.listtext.print.dicompm.DicomDisplayFormat;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmSessionConfiguration;
import com.agfa.pacs.listtext.print.dicompm.DicomFilmSize;
import com.agfa.pacs.listtext.print.dicompm.DicomPrintManagement;
import com.agfa.pacs.listtext.print.dicompm.SingleImageDicomPrintManagement;
import com.agfa.pacs.listtext.print.dicompm.dicom.DicomPrinter;
import com.agfa.pacs.listtext.print.localprint.LocalPrintDisplayFormat;
import com.agfa.pacs.listtext.print.mapper.MapperFilmSession;
import com.agfa.pacs.listtext.print.preview.PreviewPrintManagement;
import com.agfa.pacs.logging.ALogger;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComponent;

public class DicomPrinterWrapper
implements IPrinter {
    public static final int DEFAULT_DICOM_PRINTER_RESOLUTION = 300;
    private String name;
    private boolean agfaPrinter;
    private int copies = 1;
    private FilmDestination destination = null;
    private IDicomNode node;
    private DicomPrinter printer;
    private PrintPriority priority = null;
    private Density borderDensity = null;
    private Density emptyDensity = null;
    private boolean supportReal = true;
    private Boolean trim = null;
    private Media selectedMedium;
    private Media[] medias;
    private Integer illumination = null;
    private String presentationLUT = null;
    private Integer ambient = null;
    private String label;
    private boolean isLandscape = false;
    private PrinterConfigurationItem config;
    private DicomSettingPanel ui = null;
    private Hashtable<FilmSizeID, PageSetting> pages = new Hashtable();
    private IPrintConfigurationListener listener;
    private static ALogger log = ALogger.getLogger(DicomPrinterWrapper.class);

    public DicomPrinterWrapper(String string, String string2, int n, String string3, String string4, String string5) throws DicomException {
        this.name = string;
        this.node = new SimpleDicomNode(string2, n, string3, string4);
        if (string5 != null) {
            try {
                ConfigurationUtils.extractXML(this, string5);
            }
            catch (Exception exception) {
                log.error("Parse config error", (Throwable)exception);
            }
        }
        this.printer = new DicomPrinter(this.node);
    }

    public void setPrinterConfiguration(PrinterConfigurationItem printerConfigurationItem) throws DicomException {
        this.config = printerConfigurationItem;
        this.printer = new DicomPrinter(this.node);
        this.printer.initPrinting(printerConfigurationItem);
        this.medias = printerConfigurationItem.installedMedia().toArray(new Media[0]);
        this.selectedMedium = this.medias[0];
    }

    @Override
    public PageSetting getPageSetting() {
        PageSetting pageSetting = this.pages.get(this.selectedMedium.getFilmSizeID());
        if (pageSetting == null) {
            pageSetting = this.getDefaultPageSizes(this.selectedMedium.getFilmSizeID());
            this.pages.put(this.selectedMedium.getFilmSizeID(), pageSetting);
        }
        return pageSetting;
    }

    private PageSetting getDefaultPageSizes(FilmSizeID filmSizeID) {
        return new PageSetting(filmSizeID.getWidth(), filmSizeID.getHeight());
    }

    @Override
    public boolean checkFormat(IFormat iFormat) {
        return true;
    }

    private PageSetting getPageSetting(boolean bl) {
        PageSetting pageSetting = this.getPageSetting();
        if (bl) {
            pageSetting = new PageSetting(pageSetting.height, pageSetting.width);
        }
        return pageSetting;
    }

    private DicomFilmSize getFilmSize(FilmSizeID filmSizeID) {
        if (this.pages.containsKey(filmSizeID)) {
            PageSetting pageSetting = this.pages.get(filmSizeID);
            return new DicomFilmSize(filmSizeID, pageSetting.width, pageSetting.height);
        }
        return new DicomFilmSize(filmSizeID);
    }

    @Override
    public IPrintContext createPagePreview(IFormat iFormat, IPrintSetting iPrintSetting, int n, IPrintContextListener iPrintContextListener) {
        PreviewMedium previewMedium = new PreviewMedium((IFilmSize)this.getFilmSize(this.selectedMedium.getFilmSizeID()), this.isLandscape);
        LocalPrintDisplayFormat localPrintDisplayFormat = new LocalPrintDisplayFormat((IFilmSize)previewMedium, iPrintSetting.previewResolution(this.getPageSetting(this.isLandscape)), false, iFormat.getLayout(this.isLandscape));
        MapperFilmSession mapperFilmSession = iFormat.getMapperFilmSession((IDisplayFormat)localPrintDisplayFormat, null, iPrintSetting, n);
        PreviewPrintManagement previewPrintManagement = new PreviewPrintManagement();
        previewPrintManagement.setResolutionDPI(iPrintSetting.previewResolution(this.getPageSetting()).getResolutionDPI());
        IPrintContext iPrintContext = previewPrintManagement.printFilmSession(mapperFilmSession);
        iPrintContext.addListener(iPrintContextListener);
        Thread thread = new Thread((Runnable)iPrintContext);
        thread.start();
        return iPrintContext;
    }

    @Override
    public IBackgroundTask print(IFormat iFormat, IPrintSetting iPrintSetting, CancelableCollector cancelableCollector) {
        DicomConfigProvider dicomConfigProvider;
        Integer n;
        boolean bl = false;
        ImageFormat imageFormat = iFormat.chooseFormat(this.config.supportedImageFormats(), false);
        if (imageFormat == null) {
            bl = true;
            imageFormat = iFormat.chooseFormat(this.config.supportedImageFormats(), bl);
        }
        if ((n = this.config.getPrinterDPI()) == null) {
            n = 300;
        }
        FilmOrientation filmOrientation = this.isLandscape ? FilmOrientation.Landscape : FilmOrientation.Portrait;
        PageSetting pageSetting = this.getPageSetting();
        DicomDisplayFormat dicomDisplayFormat = new DicomDisplayFormat(this.selectedMedium.getFilmSizeID(), pageSetting.width, pageSetting.height, n.intValue(), filmOrientation, imageFormat.getImageDisplayFormat());
        MapperFilmSession mapperFilmSession = iFormat.getMapperFilmSession((IDisplayFormat)dicomDisplayFormat, dicomConfigProvider = new DicomConfigProvider(this.config, this), iPrintSetting, null);
        DicomFilmSessionConfiguration dicomFilmSessionConfiguration = (DicomFilmSessionConfiguration)mapperFilmSession.getMapperConfiguration(DicomFilmSessionConfiguration.class);
        if (dicomFilmSessionConfiguration == null) {
            dicomFilmSessionConfiguration = new DicomFilmSessionConfiguration();
            mapperFilmSession.mapperConfigurations().add(dicomFilmSessionConfiguration);
        }
        if (this.destination != null) {
            dicomFilmSessionConfiguration.setFilmDestination(this.destination);
        }
        Iterator<IImageBoxInfo> iterator = iFormat.getAllData().iterator();
        IImageBoxInfo iImageBoxInfo = iterator.next();
        while (iImageBoxInfo == null && iterator.hasNext()) {
            iImageBoxInfo = iterator.next();
        }
        if (iImageBoxInfo != null) {
            dicomFilmSessionConfiguration.setFilmSessionLabel(this.getLabel((IDataInfo)iImageBoxInfo.getObjectInfo()));
        }
        dicomFilmSessionConfiguration.setMediumType(this.selectedMedium.getMediumType());
        dicomFilmSessionConfiguration.setNumberOfCopies(Integer.valueOf(this.copies));
        dicomFilmSessionConfiguration.setPrintPriority(this.priority);
        String[] stringArray = this.config.getSopClassesSupported();
        if (this.contains(stringArray, "1.2.840.10008.5.1.1.18")) {
            dicomFilmSessionConfiguration.setPrintColor(PrintColor.Color);
        } else {
            dicomFilmSessionConfiguration.setPrintColor(PrintColor.Gray);
        }
        dicomFilmSessionConfiguration.setCreatePresentationLUT(this.contains(stringArray, "1.2.840.10008.5.1.1.23"));
        dicomFilmSessionConfiguration.setUseProposedStudySequence(dicomConfigProvider.isAgfaPrinter() && this.contains(stringArray, "1.2.840.10008.5.1.1.15"));
        this.printer.setSessionConfiguration(dicomFilmSessionConfiguration);
        IPrintContext iPrintContext = null;
        if (bl) {
            log.info("Using single image dicom print");
            SingleImageDicomPrintManagement singleImageDicomPrintManagement = new SingleImageDicomPrintManagement(this.printer);
            iPrintContext = singleImageDicomPrintManagement.printFilmSession(mapperFilmSession);
        } else {
            log.info("Using direct dicom print");
            DicomPrintManagement dicomPrintManagement = new DicomPrintManagement(this.printer);
            iPrintContext = dicomPrintManagement.printFilmSession(mapperFilmSession);
        }
        return new PrintJob(iPrintContext, iFormat.getPageCount());
    }

    private boolean contains(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public PresentationLUT getPresentationLUT() {
        if (this.presentationLUT == null) {
            return null;
        }
        return PresentationLUT.valueOf(this.presentationLUT);
    }

    public void setPresentationLUT(PresentationLUT presentationLUT) {
        this.presentationLUT = presentationLUT.toString();
        if (this.listener != null) {
            this.listener.redraw();
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    public Density getBorderDensity() {
        return this.borderDensity;
    }

    public Density getEmptyDensity() {
        return this.emptyDensity;
    }

    public PrintPriority getPriority() {
        return this.priority;
    }

    public void setPriority(PrintPriority printPriority) {
        this.priority = printPriority;
    }

    public void setDestination(FilmDestination filmDestination) {
        this.destination = filmDestination;
    }

    public boolean isSupportReal() {
        return this.supportReal;
    }

    public Boolean getTrim() {
        return this.trim;
    }

    public void setBorderDensity(Density density) {
        this.borderDensity = density;
    }

    public void setEmptyDensity(Density density) {
        this.emptyDensity = density;
    }

    public void setSupportReal(boolean bl) {
        this.supportReal = bl;
    }

    public void setTrim(Boolean bl) {
        this.trim = bl;
    }

    public Media[] getMedias() {
        return this.medias;
    }

    public Media getSelectedMedium() {
        return this.selectedMedium;
    }

    public void setSelectedMedium(Media media) {
        this.selectedMedium = media;
        this.listener.resetWholeLayout();
    }

    @Override
    public String getCompleteSetting() {
        return String.valueOf(this.name) + " - " + this.selectedMedium + " " + (this.isLandscape ? "L" : "P");
    }

    @Override
    public JComponent getUI() {
        if (this.ui == null) {
            this.ui = new DicomSettingPanel(this);
        }
        return this.ui;
    }

    @Override
    public void initFromConfig(IConfigurationProvider iConfigurationProvider) {
        int n;
        this.isLandscape = !iConfigurationProvider.getBoolean("isPortrait");
        IConfigurationList iConfigurationList = iConfigurationProvider.getList("dicom_printers");
        IConfigurationProvider iConfigurationProvider2 = null;
        for (IConfigurationProvider iConfigurationProvider3 : iConfigurationList) {
            if (!iConfigurationProvider3.getString("name").equals(this.name)) continue;
            iConfigurationProvider2 = iConfigurationProvider3;
            break;
        }
        if (iConfigurationProvider2 != null && iConfigurationProvider2.exists("medium") && (n = (int)iConfigurationProvider2.getLong("medium")) < this.medias.length) {
            this.selectedMedium = this.medias[n];
        }
        if (this.selectedMedium == null) {
            this.selectedMedium = this.medias[0];
        }
    }

    @Override
    public void registerListener(IPrintConfigurationListener iPrintConfigurationListener) {
        this.listener = iPrintConfigurationListener;
    }

    @Override
    public void saveToConfig(IConfigurationProvider iConfigurationProvider) {
        IConfigurationList iConfigurationList = iConfigurationProvider.getList("dicom_printers");
        IConfigurationProvider iConfigurationProvider2 = null;
        for (IConfigurationProvider iConfigurationProvider3 : iConfigurationList) {
            if (!iConfigurationProvider3.getString("name").equals(this.name)) continue;
            iConfigurationProvider2 = iConfigurationProvider3;
            break;
        }
        iConfigurationProvider.setBoolean("isPortrait", !this.isLandscape);
        if (iConfigurationProvider2 != null) {
            iConfigurationProvider2.setLong("medium", (long)this.selectedMedium.getItemNumber().intValue());
        }
    }

    public boolean isLandscape() {
        return this.isLandscape;
    }

    public void setLandscape(boolean bl) {
        this.isLandscape = bl;
        this.listener.resetWholeLayout();
    }

    public void putPageSetting(FilmSizeID filmSizeID, double d, double d2) {
        this.pages.put(filmSizeID, new PageSetting(d, d2));
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int n) {
        this.copies = n;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    private String getLabel(IDataInfo iDataInfo) {
        String string = this.label;
        string = AnnotationUtils.evaluate(string, iDataInfo.getAttributes());
        return string;
    }

    public void setAmbient(Integer n) {
        this.ambient = n;
    }

    public void setIllumination(Integer n) {
        this.illumination = n;
    }

    public boolean isAgfaPrinter() {
        return this.agfaPrinter;
    }

    public void setAgfaPrinter(boolean bl) {
        this.agfaPrinter = bl;
    }

    public static enum PresentationLUT {
        FILM,
        SESSION,
        IMAGE;

    }
}

