/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.local;

import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.util.CancelableCollector;
import com.agfa.pacs.listtext.lta.print.IFormat;
import com.agfa.pacs.listtext.lta.print.IPrintConfigurationListener;
import com.agfa.pacs.listtext.lta.print.IPrintSetting;
import com.agfa.pacs.listtext.lta.print.IPrinter;
import com.agfa.pacs.listtext.lta.print.PageSetting;
import com.agfa.pacs.listtext.lta.print.impl.PreviewMedium;
import com.agfa.pacs.listtext.lta.print.impl.PrintJob;
import com.agfa.pacs.listtext.lta.print.local.LocaleSettingPanel;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.IFilmBoxResolution;
import com.agfa.pacs.listtext.print.IFilmSize;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.IPrintContextListener;
import com.agfa.pacs.listtext.print.InvalidResolution;
import com.agfa.pacs.listtext.print.localprint.LocalPrintDisplayFormat;
import com.agfa.pacs.listtext.print.localprint.LocalPrintFilmSessionConfiguration;
import com.agfa.pacs.listtext.print.localprint.LocalPrintManagement;
import com.agfa.pacs.listtext.print.mapper.MapperFilmSession;
import com.agfa.pacs.listtext.print.preview.PreviewPrintManagement;
import java.awt.Color;
import java.util.Iterator;
import javax.print.PrintService;
import javax.swing.JComponent;

public class LocalPrinter
implements IPrinter {
    private PrintService service;
    private boolean isLandscape;
    private IFilmSize selectedMedium = null;
    private IFilmBoxResolution selectedResolution = null;
    private IFilmSize[] medias = null;
    private IFilmBoxResolution[] resolutions = null;
    private IPrintConfigurationListener listener = null;
    private LocaleSettingPanel ui = null;
    private LocalPrintManagement managment = null;
    private int copies = 1;
    private Color borderColor;
    private Color gapColor;
    private double borderSize;
    private double gapSize;
    private IConfigurationProvider configToBeInit = null;

    public LocalPrinter(PrintService printService) {
        this.service = printService;
    }

    @Override
    public boolean checkFormat(IFormat iFormat) {
        return true;
    }

    public synchronized void initDelayed() {
        IFilmSize iFilmSize;
        if (this.configToBeInit == null) {
            return;
        }
        this.managment = new LocalPrintManagement(this.service, 1);
        this.medias = this.managment.getFilmSessionMedia().toArray(new IFilmSize[0]);
        this.resolutions = this.managment.getFilmSessionResolutions().toArray(new IFilmBoxResolution[0]);
        IConfigurationList iConfigurationList = this.configToBeInit.getList("locale_printers");
        String string = this.configToBeInit.getString("default_medium");
        this.configToBeInit = null;
        IFilmSize[] iFilmSizeArray = this.medias;
        int n = this.medias.length;
        int n2 = 0;
        while (n2 < n) {
            iFilmSize = iFilmSizeArray[n2];
            if (iFilmSize.getName().equals(string)) {
                this.selectedMedium = iFilmSize;
                break;
            }
            ++n2;
        }
        iFilmSize = null;
        for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
            if (!iConfigurationProvider.getString("name").equals(this.service.getName())) continue;
            iFilmSize = iConfigurationProvider;
            break;
        }
        if (iFilmSize != null) {
            if (iFilmSize.exists("resolution")) {
                int n3 = (int)iFilmSize.getLong("resolution");
                IFilmBoxResolution[] iFilmBoxResolutionArray = this.resolutions;
                int n4 = this.resolutions.length;
                int n5 = 0;
                while (n5 < n4) {
                    Iterator iterator = iFilmBoxResolutionArray[n5];
                    if (iterator.getResolutionDPI() == n3) {
                        this.selectedResolution = iterator;
                        break;
                    }
                    ++n5;
                }
            }
            if (iFilmSize.exists("medium")) {
                string = iFilmSize.getString("medium");
                IFilmSize[] iFilmSizeArray2 = this.medias;
                int n6 = this.medias.length;
                int n7 = 0;
                while (n7 < n6) {
                    IFilmSize iFilmSize2 = iFilmSizeArray2[n7];
                    if (iFilmSize2.getName().equals(string)) {
                        this.selectedMedium = iFilmSize2;
                        break;
                    }
                    ++n7;
                }
            }
        }
        if (this.medias.length == 0) {
            throw new IllegalArgumentException("No medias supported " + this.toString());
        }
        if (this.selectedMedium == null) {
            this.selectedMedium = this.medias[0];
        }
        this.resolutions = new IFilmBoxResolution[0];
        if (this.resolutions.length == 0) {
            this.resolutions = new IFilmBoxResolution[]{new InvalidResolution()};
        }
        if (this.selectedResolution == null) {
            this.selectedResolution = this.resolutions[0];
        }
    }

    @Override
    public void initFromConfig(IConfigurationProvider iConfigurationProvider) {
        this.configToBeInit = iConfigurationProvider;
        this.isLandscape = !iConfigurationProvider.getBoolean("isPortrait");
        this.borderColor = new Color((int)iConfigurationProvider.getLong("default_local.border_color"));
        this.gapColor = new Color((int)iConfigurationProvider.getLong("default_local.gap_color"));
        this.borderSize = iConfigurationProvider.getDouble("default_local.border_size");
        this.gapSize = iConfigurationProvider.getDouble("default_local.gap_size");
    }

    @Override
    public void saveToConfig(IConfigurationProvider iConfigurationProvider) {
        IConfigurationList iConfigurationList;
        try {
            iConfigurationList = iConfigurationProvider.getList("locale_printers");
        }
        catch (Exception exception) {
            iConfigurationList = iConfigurationProvider.createList("locale_printers");
        }
        IConfigurationProvider iConfigurationProvider2 = null;
        for (IConfigurationProvider iConfigurationProvider3 : iConfigurationList) {
            if (!iConfigurationProvider3.getString("name").equals(this.service.getName())) continue;
            iConfigurationProvider2 = iConfigurationProvider3;
            break;
        }
        if (iConfigurationProvider2 == null) {
            iConfigurationProvider2 = iConfigurationList.appendItem();
            iConfigurationProvider2.setString("name", this.service.getName());
        }
        iConfigurationProvider.setBoolean("isPortrait", !this.isLandscape);
        iConfigurationProvider2.setString("medium", this.selectedMedium.getName());
        if (!(this.selectedResolution instanceof InvalidResolution)) {
            iConfigurationProvider2.setLong("resolution", (long)this.selectedResolution.getResolutionDPI());
        }
    }

    @Override
    public IBackgroundTask print(IFormat iFormat, IPrintSetting iPrintSetting, CancelableCollector cancelableCollector) {
        LocalPrintDisplayFormat localPrintDisplayFormat = new LocalPrintDisplayFormat(this.selectedMedium, this.selectedResolution, this.isLandscape, iFormat.getLayout(false));
        MapperFilmSession mapperFilmSession = iFormat.getMapperFilmSession((IDisplayFormat)localPrintDisplayFormat, null, iPrintSetting, null);
        LocalPrintManagement localPrintManagement = new LocalPrintManagement(this.service, this.copies);
        LocalPrintFilmSessionConfiguration localPrintFilmSessionConfiguration = (LocalPrintFilmSessionConfiguration)mapperFilmSession.getMapperConfiguration(LocalPrintFilmSessionConfiguration.class);
        if (localPrintFilmSessionConfiguration == null) {
            localPrintFilmSessionConfiguration = new LocalPrintFilmSessionConfiguration();
            mapperFilmSession.mapperConfigurations().add(localPrintFilmSessionConfiguration);
        }
        IPrintContext iPrintContext = localPrintManagement.printFilmSession(mapperFilmSession);
        return new PrintJob(iPrintContext, iFormat.getPageCount());
    }

    @Override
    public IPrintContext createPagePreview(IFormat iFormat, IPrintSetting iPrintSetting, int n, IPrintContextListener iPrintContextListener) {
        this.initDelayed();
        PreviewMedium previewMedium = new PreviewMedium(this.selectedMedium, this.isLandscape);
        LocalPrintDisplayFormat localPrintDisplayFormat = new LocalPrintDisplayFormat((IFilmSize)previewMedium, iPrintSetting.previewResolution(this.getPageSetting(this.isLandscape)), false, iFormat.getLayout(this.isLandscape));
        MapperFilmSession mapperFilmSession = iFormat.getMapperFilmSession((IDisplayFormat)localPrintDisplayFormat, null, iPrintSetting, n);
        PreviewPrintManagement previewPrintManagement = new PreviewPrintManagement();
        previewPrintManagement.setResolutionDPI(iPrintSetting.previewResolution(this.getPageSetting()).getResolutionDPI());
        IPrintContext iPrintContext = previewPrintManagement.printFilmSession(mapperFilmSession);
        iPrintContext.addListener(iPrintContextListener);
        Thread thread = new Thread((Runnable)iPrintContext);
        thread.start();
        return iPrintContext;
    }

    IFilmBoxResolution[] getResolutions() {
        return this.resolutions;
    }

    IFilmSize[] getMedias() {
        return this.medias;
    }

    void setResolution(IFilmBoxResolution iFilmBoxResolution) {
        this.selectedResolution = iFilmBoxResolution;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int n) {
        this.copies = n;
    }

    IFilmSize getSelectedMedium() {
        return this.selectedMedium;
    }

    IFilmBoxResolution getSelectedResolution() {
        return this.selectedResolution;
    }

    void setMedium(IFilmSize iFilmSize) {
        this.selectedMedium = iFilmSize;
        this.listener.resetWholeLayout();
    }

    void setIsLandscape(boolean bl) {
        this.isLandscape = bl;
        this.listener.redraw();
    }

    boolean isLandscape() {
        return this.isLandscape;
    }

    @Override
    public String toString() {
        String string = this.service.getName();
        if (string.length() > 31) {
            return String.valueOf(string.substring(0, 31)) + "...";
        }
        return string;
    }

    @Override
    public String getName() {
        return this.service.getName();
    }

    @Override
    public String getCompleteSetting() {
        return String.valueOf(this.service.getName()) + "-[" + this.selectedMedium.getName() + "](" + this.selectedResolution.getFeedResolutionDPI() + "dpi)-" + (this.isLandscape ? "L" : "P");
    }

    @Override
    public JComponent getUI() {
        if (this.ui == null) {
            this.initDelayed();
            this.ui = new LocaleSettingPanel(this);
        }
        return this.ui;
    }

    @Override
    public void registerListener(IPrintConfigurationListener iPrintConfigurationListener) {
        this.listener = iPrintConfigurationListener;
    }

    @Override
    public PageSetting getPageSetting() {
        return new PageSetting(this.selectedMedium.getWidth(), this.selectedMedium.getHeight());
    }

    private PageSetting getPageSetting(boolean bl) {
        if (bl) {
            return new PageSetting(this.selectedMedium.getHeight(), this.selectedMedium.getWidth());
        }
        return new PageSetting(this.selectedMedium.getWidth(), this.selectedMedium.getHeight());
    }
}

