/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.impl;

import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.IPrintContextListener;
import com.agfa.pacs.listtext.print.mapper.MapperFilmBox;
import org.dcm4che3.util.UIDUtils;

public class PrintJob
implements IBackgroundTask,
IPrintContextListener {
    private IPrintContext context;
    private IBackgroundProgress advancer = null;
    private boolean ok = false;
    private int numOfPages;
    private final String uid = UIDUtils.createUID();

    public PrintJob(IPrintContext iPrintContext, int n) {
        this.context = iPrintContext;
        this.numOfPages = n;
    }

    public boolean execute() {
        this.context.addListener((IPrintContextListener)this);
        this.context.run();
        return this.ok;
    }

    public String getInfo() {
        return Messages.getString("PrintJob.PrintingJobTitle");
    }

    public void take(IBackgroundProgress iBackgroundProgress) {
        this.advancer = iBackgroundProgress;
    }

    public void terminate() {
        this.context.cancel();
    }

    public void printFinished(IPrintContext iPrintContext, IPrintContext.Status status) {
        if (status.equals((Object)IPrintContext.Status.Finished)) {
            this.ok = true;
            this.advancer.progress(1.0);
        }
    }

    public void printProgressed(IPrintContext iPrintContext, IPrintContext.Status status, MapperFilmBox mapperFilmBox) {
        int n = (int)Math.round((double)this.numOfPages * iPrintContext.getProgress());
        this.advancer.progress(iPrintContext.getProgress(), String.valueOf(Messages.getString("PrintJob.Page")) + " " + n + " " + Messages.getString("PrintJob.of") + " " + this.numOfPages);
        if (status.equals((Object)IPrintContext.Status.Failed)) {
            iPrintContext.cancel();
            this.ok = false;
            this.advancer.progress(1.0, Messages.getString("PrintJob.FailedJob"));
        }
    }

    public String getUID() {
        return this.uid;
    }
}

