/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.CancelableCollector;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRenderer;
import com.agfa.pacs.listtext.lta.print.IFormat;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import com.agfa.pacs.listtext.lta.print.IPreview;
import com.agfa.pacs.listtext.lta.print.IPrintConfigurationListener;
import com.agfa.pacs.listtext.lta.print.IPrintSetting;
import com.agfa.pacs.listtext.lta.print.IPrinter;
import com.agfa.pacs.listtext.lta.print.ImageBoxInfo;
import com.agfa.pacs.listtext.lta.print.ImageBoxInfoCreator;
import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.lta.print.formats.PrintFormatFactory;
import com.agfa.pacs.listtext.lta.print.impl.PrintDialog;
import com.agfa.pacs.listtext.lta.print.impl.PrinterSetting;
import com.agfa.pacs.listtext.lta.print.local.LocalPrinterFactory;
import com.agfa.pacs.listtext.lta.print.plaf.PrintManagerUI;
import com.agfa.pacs.listtext.lta.print.remote.DicomPrinterFactory;
import com.agfa.pacs.listtext.lta.progress.IProgressStateManager;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import com.agfa.pacs.listtext.lta.util.job.JobControl;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectProviderFactory;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.pixeldata.frame.IFrameSelection;
import com.agfa.pacs.listtext.print.renderer.FilmSession;
import com.agfa.pacs.listtext.swingx.controls.AbstractComponent;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class PrintManager
extends AbstractComponent
implements IPrintConfigurationListener {
    private static ALogger log = ALogger.getLogger(PrintManager.class);
    public static final String UPDATE_ICONS = "UPDATE_ICONS";
    public static final String UPDATE_TITLES = "UPDATE_TITLES";
    private List<IImageBoxInfo> originalData;
    private List<IImageBoxInfo> notSelectedData;
    private List<IImageBoxInfo> keyData;
    private List<IImageBoxInfo> notSelectedKeyData;
    private boolean addFooter;
    private SPLIT_TYPE actualSplitting = SPLIT_TYPE.NO_SPLIT;
    private IFormat selectedFormat = null;
    private boolean useDemographics;
    private Color demographicsColor;
    private JDialog dialog = null;
    private PropertyChangeSupport changeSupport = null;
    private Vector<IPrinter> printers;
    private Vector<IFormat> formats;
    private IPreview previewManager = null;
    private boolean uiInitialized = false;
    private IPrinter selectedPrinter = null;
    private boolean showOnlyKeyimages = false;
    private ImageBoxInfoCreator ibiCreator = new ImageBoxInfoCreator();
    private int returnValue = 0;

    public PrintManager() {
        this.changeSupport = new PropertyChangeSupport(this);
        this.originalData = new ArrayList<IImageBoxInfo>();
        this.init();
    }

    public void closeWindow() {
        this.previewManager.resetPreview();
        this.dialog.setVisible(false);
    }

    public void cleanup() {
        this.printers.clear();
        this.formats.clear();
        this.keyData.clear();
        this.notSelectedData.clear();
        this.notSelectedKeyData.clear();
        this.originalData.clear();
        this.selectedFormat = null;
        this.selectedPrinter = null;
        this.previewManager = null;
        this.dialog.dispose();
        this.dialog = null;
        this.ui.uninstallUI((JComponent)((Object)this));
        this.ui = null;
        this.uiInitialized = false;
    }

    @Override
    public void resetWholeLayout() {
        this.changeSupport.firePropertyChange(UPDATE_ICONS, null, (Object)true);
        this.previewManager.drawPreview();
    }

    @Override
    public void redraw() {
        this.changeSupport.firePropertyChange(UPDATE_TITLES, false, true);
    }

    public void print() {
        this.dialog.setVisible(false);
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        iConfigurationProvider = iConfigurationProvider.getNode("listtext.print");
        this.selectedFormat.saveToConfig(iConfigurationProvider);
        this.selectedPrinter.saveToConfig(iConfigurationProvider);
        iConfigurationProvider.setString("printer", this.selectedPrinter.getName());
        iConfigurationProvider.setString("format", this.selectedFormat.toString());
        iConfigurationProvider.setBoolean("demographics", this.useDemographics);
        iConfigurationProvider.setBoolean("use_footer", this.addFooter);
        iConfigurationProvider.setString("splitting", this.actualSplitting.name());
        if (this.selectedFormat.getAllData().isEmpty() && !this.getNotSelectedData().isEmpty()) {
            this.selectedFormat.addData(this.ibiCreator.createImageBoxInfos(this.getNotSelectedData(), true, this.showOnlyKeyimages), this.actualSplitting);
        }
        List<IObjectInfo> list = ImageBoxInfo.extractObjectInfos(this.selectedFormat.getAllData(), true);
        JobControl jobControl = new JobControl(Messages.getString("PrintManager.PrintingJobTitle"), JobControl.createDetailedInformation((String)Messages.getString("PrintManager.PrintingJobTitle"), (String)this.selectedPrinter.toString(), list));
        IProgressStateManager iProgressStateManager = ProgressManagerFactory.getManager();
        iProgressStateManager.addProgressState(jobControl.getModel());
        jobControl.getModel().addAuditMessage(Audit.getInstance().logDataExport(DataInfoUtilities.forAuditing(list), "print://" + this.selectedPrinter.toString()));
        Map map = DataInfoUtilities.forStudyManagment(list);
        DicomCacheFactory.getInstance().getDicomCache().registerStudyUsage(map);
        jobControl.getModel().storeStudyUsageRegistration(map);
        IBackgroundTask iBackgroundTask = this.selectedPrinter.print(this.selectedFormat, this.getGeneralSetting(), (CancelableCollector)jobControl.getModel());
        jobControl.addTask(iBackgroundTask);
        Thread thread = new Thread((Runnable)jobControl);
        thread.start();
        this.returnValue = 1;
    }

    public void reset() {
        this.originalData = null;
        this.notSelectedData = null;
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var2_10;
        this.printers = new Vector();
        this.formats = new Vector();
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        iConfigurationProvider = iConfigurationProvider.getNode("listtext.print");
        try {
            this.printers.addAll(LocalPrinterFactory.getInstance().getLocalPrinters());
        }
        catch (Exception exception) {
            log.warn("Could not add local printers", (Throwable)exception);
        }
        try {
            this.printers.addAll(DicomPrinterFactory.getInstance().getDicomPrinters());
        }
        catch (Exception exception) {
            log.warn("Could not load dicom printers", (Throwable)exception);
        }
        if (this.printers.isEmpty()) {
            return;
        }
        Collections.sort(this.printers, new PrinterComparator());
        this.formats.addAll(PrintFormatFactory.getInstance().getPrintFormats());
        this.useDemographics = iConfigurationProvider.getBoolean("demographics");
        this.demographicsColor = new Color((int)iConfigurationProvider.getLong("demographics_color"));
        this.addFooter = iConfigurationProvider.getBoolean("use_footer");
        for (IFormat iFormat : this.formats) {
            iFormat.initFromConfig(iConfigurationProvider);
            iFormat.registerListener(this);
        }
        Object var2_7 = null;
        if (iConfigurationProvider.exists("printer")) {
            String string = iConfigurationProvider.getString("printer");
        } else {
            String string = LocalPrinterFactory.getInstance().getDefaultPrinterName();
        }
        if (var2_10 == null && this.printers.size() > 0) {
            String string = this.printers.get(0).toString();
        }
        Iterator<Object> iterator = this.printers.iterator();
        while (iterator.hasNext()) {
            IPrinter iPrinter = (IPrinter)iterator.next();
            try {
                iPrinter.initFromConfig(iConfigurationProvider);
                iPrinter.registerListener(this);
            }
            catch (Exception exception) {
                iterator.remove();
                log.warn("Could not init printer:" + iPrinter.toString(), (Throwable)exception);
            }
        }
        if (this.printers.isEmpty()) {
            return;
        }
        for (IPrinter iPrinter : this.printers) {
            void var2_12;
            if (!iPrinter.getName().equals(var2_12)) continue;
            this.selectedPrinter = iPrinter;
        }
        if (this.selectedPrinter == null) {
            this.selectedPrinter = this.printers.get(0);
        }
        Object var4_17 = null;
        if (iConfigurationProvider.exists("format")) {
            String string = iConfigurationProvider.getString("format");
        } else {
            String string = this.formats.get(0).toString();
        }
        for (IFormat iFormat : this.formats) {
            void var4_20;
            if (!iFormat.toString().equals(var4_20)) continue;
            this.selectedFormat = iFormat;
        }
        try {
            this.actualSplitting = SPLIT_TYPE.valueOf(iConfigurationProvider.getString("splitting"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.error("Error splitting format string.", (Throwable)illegalArgumentException);
        }
        this.getSelectedFormat().createEmptyPage();
    }

    public List<IImageBoxInfo> getNotSelectedData() {
        if (this.showOnlyKeyimages) {
            return this.notSelectedKeyData;
        }
        return this.notSelectedData;
    }

    public List<IImageBoxInfo> createImageBoxInfos(List<IImageBoxInfo> list, boolean bl, boolean bl2) {
        return this.ibiCreator.createImageBoxInfos(list, bl, bl2);
    }

    public void selectData(List<IImageBoxInfo> list) {
        if (this.showOnlyKeyimages) {
            this.notSelectedKeyData.removeAll(list);
        } else {
            this.notSelectedData.removeAll(list);
        }
        this.changeSupport.firePropertyChange(UPDATE_ICONS, null, (Object)true);
    }

    public void deselectData(List<IImageBoxInfo> list) {
        if (list == null) {
            return;
        }
        if (this.showOnlyKeyimages) {
            this.notSelectedKeyData.addAll(list);
        } else {
            this.notSelectedData.addAll(list);
        }
        this.changeSupport.firePropertyChange(UPDATE_ICONS, null, (Object)true);
    }

    public IPrintSetting getGeneralSetting() {
        return new PrinterSetting(this.useDemographics, this.addFooter, new Dimension(500, 580), this.demographicsColor);
    }

    private void addAnnotations(FilmSession filmSession) {
    }

    public boolean isAddFooter() {
        return this.addFooter;
    }

    public SPLIT_TYPE getSelectedSplitting() {
        return this.actualSplitting;
    }

    public void setAddFooter(boolean bl) {
        this.addFooter = bl;
        this.previewManager.drawPreview();
    }

    public void setSplitting(SPLIT_TYPE sPLIT_TYPE) {
        this.actualSplitting = sPLIT_TYPE;
    }

    public void setPreviewManager(IPreview iPreview) {
        this.previewManager = iPreview;
    }

    public void setUseDemogrpahics(boolean bl) {
        this.useDemographics = bl;
        this.previewManager.drawPreview();
    }

    public boolean isUsingDemographics() {
        return this.useDemographics;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Vector<IPrinter> getAvailablePrinters() {
        return this.printers;
    }

    public IPrinter getSelectedPrinter() {
        return this.selectedPrinter;
    }

    public void setSelectedPrinter(IPrinter iPrinter) {
        if (iPrinter == null) {
            return;
        }
        if (!this.printers.contains(iPrinter)) {
            return;
        }
        if (this.selectedPrinter == iPrinter) {
            return;
        }
        this.selectedPrinter = iPrinter;
        this.resetWholeLayout();
    }

    public Vector<IFormat> getPrintFormats() {
        return this.formats;
    }

    public IFormat getSelectedFormat() {
        return this.selectedFormat;
    }

    public void setSelectedFormat(IFormat iFormat) {
        if (iFormat == null) {
            return;
        }
        if (!this.formats.contains(iFormat)) {
            return;
        }
        if (this.selectedFormat == iFormat) {
            this.selectedFormat = iFormat;
        }
        this.previewManager.drawPreview();
    }

    public boolean isShowOnlyKeyimages() {
        return this.showOnlyKeyimages;
    }

    public void setShowOnlyKeyimages(boolean bl) {
        this.showOnlyKeyimages = bl;
        this.changeSupport.firePropertyChange(UPDATE_ICONS, null, (Object)true);
    }

    public String getUIClassID() {
        return "PrintManagerUI";
    }

    public Class<?> getComponentUIClass() {
        return PrintManagerUI.class;
    }

    public void registerUIClassPaths(Map<String, String> map) {
        map.put("Basic", "com.agfa.pacs.listtext.lta.print.plaf.basic.BasicPrintManagerUI");
    }

    private void loadKeyObject(List<? extends IDataInfo> list, Map<String, BitSet> map) {
        Object object;
        if (!list.isEmpty()) {
            object = ReferencedObjectProviderFactory.getInstance().getSupportedReferencedObjectProvider(list.get(0).getSource());
            if (object == null) {
                return;
            }
            List object2 = DataInfoUtilities.getLevel(list, IStudyInfo.class);
            List list2 = DataInfoUtilities.getLevel((Collection)object2, IObjectInfo.class);
            ArrayList<? extends IDataInfo> arrayList = new ArrayList<IDataInfo>(list);
            for (IDataInfo iDataInfo : arrayList) {
                try {
                    List list3 = object.getReferencedObjects(iDataInfo, list2, ReferencedObjectUtilities.getAllTypes(), true, false);
                    List list4 = ReferencedObjectUtilities.extractReferencedObjects((Collection)list3);
                    HashMap<String, BitSet> hashMap = new HashMap<String, BitSet>();
                    for (ReferencedObject referencedObject : list3) {
                        BitSet bitSet = (BitSet)hashMap.get(referencedObject.getObject().getSOPInstanceUID());
                        if (bitSet == null) {
                            bitSet = new BitSet();
                            hashMap.put(referencedObject.getObject().getSOPInstanceUID(), bitSet);
                        }
                        if (referencedObject.getFrameNumber() == null) continue;
                        bitSet.set(referencedObject.getFrameNumber());
                    }
                    this.keyData = this.createImageBoxes(list4, hashMap);
                }
                catch (Exception exception) {
                    log.error("Parsing/Retrieving key-object(s) failed!", (Throwable)exception);
                }
            }
        }
        if (map != null && !map.isEmpty()) {
            for (IImageBoxInfo iImageBoxInfo : this.originalData) {
                if (!map.containsKey(iImageBoxInfo.getObjectInfo().getSOPInstanceUID()) || (object = map.get(iImageBoxInfo.getObjectInfo().getSOPInstanceUID())) != null && !((BitSet)object).get(iImageBoxInfo.getFrameNumber())) continue;
                this.keyData.add(iImageBoxInfo);
            }
        }
    }

    public static Integer getFrameNumber(IObjectInfo iObjectInfo) {
        if (UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.Multiframe)) {
            int n = iObjectInfo.getKey().indexOf(95);
            if (n >= 0) {
                return Integer.parseInt(iObjectInfo.getKey().substring(n + 1));
            }
            return 1;
        }
        return 1;
    }

    public List<IImageBoxInfo> createImageBoxes(List<IObjectInfo> list, Map<String, BitSet> map) {
        ArrayList<IImageBoxInfo> arrayList = new ArrayList<IImageBoxInfo>(list.size());
        for (IObjectInfo iObjectInfo : list) {
            int n;
            int n2;
            if (iObjectInfo instanceof IFrameSelection) {
                int[] nArray = ((IFrameSelection)iObjectInfo).getContainedFrames();
                int n3 = nArray.length;
                n2 = 0;
                while (n2 < n3) {
                    n = nArray[n2];
                    arrayList.add(new ImageBoxInfo(iObjectInfo, n));
                    ++n2;
                }
                continue;
            }
            if (map != null && map.containsKey(iObjectInfo.getSOPInstanceUID())) {
                BitSet bitSet = map.get(iObjectInfo.getSOPInstanceUID());
                if (bitSet.isEmpty()) {
                    n2 = 0;
                    while (n2 < iObjectInfo.getAttributes().getInt(0x280008, 1)) {
                        arrayList.add(new ImageBoxInfo(iObjectInfo, n2));
                        ++n2;
                    }
                    continue;
                }
                n2 = bitSet.nextSetBit(0);
                while (n2 >= 0) {
                    arrayList.add(new ImageBoxInfo(iObjectInfo, n2));
                    n2 = bitSet.nextSetBit(n2 + 1);
                }
                continue;
            }
            if (iObjectInfo.getKey().contains("_")) {
                arrayList.add(new ImageBoxInfo(iObjectInfo, PrintManager.getFrameNumber(iObjectInfo)));
                continue;
            }
            n = iObjectInfo.getAttributes().getInt(0x280008, 1);
            n2 = 0;
            while (n2 < n) {
                arrayList.add(new ImageBoxInfo(iObjectInfo, n2));
                ++n2;
            }
        }
        return arrayList;
    }

    public int showModalDialog(Component component, Rectangle rectangle, List<? extends IDataInfo> list, Map<String, BitSet> map) {
        if (this.printers.isEmpty()) {
            JOptionPane.showMessageDialog(component, Messages.getString("PrintManager.NoPrintersConfigured"), Messages.getString("PrintManager.NoPrintersConfigured"), 0);
            return -1;
        }
        List list2 = DataInfoUtilities.getLevel(list, IObjectInfo.class);
        this.originalData = this.createImageBoxes(list2, null);
        this.keyData = new ArrayList<IImageBoxInfo>();
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        Iterator<IImageBoxInfo> iterator = this.originalData.iterator();
        IDicomDataRequester iDicomDataRequester = DicomDataRequester.getInstance();
        while (iterator.hasNext()) {
            IImageBoxInfo iImageBoxInfo = iterator.next();
            String string = iImageBoxInfo.getObjectInfo().getSOPClassUID();
            if (UIDUtilities.isType((String)string, (UIDType)UIDType.KeyObject)) {
                iterator.remove();
                arrayList.add(iImageBoxInfo.getObjectInfo());
            }
            if (UIDUtilities.isType((String)string, (UIDType)UIDType.StructuredReport)) {
                iterator.remove();
            }
            if (!UIDUtilities.isType((String)string, (UIDType)UIDType.Presentation)) continue;
            iterator.remove();
            IDicomDataRequest iDicomDataRequest = iDicomDataRequester.createDicomDataRequest(iImageBoxInfo.getObjectInfo());
            iDicomDataRequest.setListener((IDicomDataListener)this.ibiCreator);
            iDicomDataRequester.addRequest(iDicomDataRequest);
            iDicomDataRequest.waitUntilFinished();
        }
        this.notSelectedData = new ArrayList<IImageBoxInfo>(this.originalData);
        this.loadKeyObject(arrayList, map);
        this.notSelectedKeyData = new ArrayList<IImageBoxInfo>(this.keyData);
        if (!this.uiInitialized) {
            this.initUI();
        }
        this.uiInitialized = true;
        this.changeSupport.firePropertyChange(UPDATE_ICONS, null, (Object)true);
        this.dialog = new PrintDialog(component, this);
        this.dialog.pack();
        if (this.previewManager != null) {
            this.previewManager.drawPreview();
        }
        this.dialog.setModal(true);
        if (rectangle != null) {
            SwingUtilities2.showDialogCentered((Rectangle)rectangle, (JDialog)this.dialog);
        } else {
            SwingUtilities2.showDialogCentered((Component)component, (JDialog)this.dialog);
        }
        return this.returnValue;
    }

    public static boolean isSupportedCompositeObject(IObjectInfo iObjectInfo) {
        return UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.Composite) && iObjectInfo instanceof IDicomObjectRenderer;
    }

    private static class PrinterComparator
    implements Comparator<IPrinter> {
        private PrinterComparator() {
        }

        @Override
        public int compare(IPrinter iPrinter, IPrinter iPrinter2) {
            return iPrinter.toString().compareTo(iPrinter2.toString());
        }
    }

    public static enum SPLIT_TYPE {
        NO_SPLIT,
        SPLIT_ON_PATIENT,
        SPLIT_ON_STUDY,
        SPLIT_ON_SERIE;


        public String toString() {
            return Messages.getString(this.name());
        }
    }
}

