/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public final class Log4jLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger,
Serializable {
    private static final long serialVersionUID = 6182834493563598289L;
    final transient Logger logger;
    static final String FQCN = Log4jLoggerAdapter.class.getName();
    final boolean traceCapable;

    Log4jLoggerAdapter(Logger logger) {
        this.logger = logger;
        this.name = logger.getName();
        this.traceCapable = this.isTraceCapable();
    }

    private boolean isTraceCapable() {
        try {
            this.logger.isTraceEnabled();
            return true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    public boolean isTraceEnabled() {
        if (this.traceCapable) {
            return this.logger.isTraceEnabled();
        }
        return this.logger.isDebugEnabled();
    }

    public void trace(String string) {
        this.logger.log(FQCN, this.traceCapable ? Level.TRACE : Level.DEBUG, string, null);
    }

    public void trace(String string, Object object) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.logger.log(FQCN, this.traceCapable ? Level.TRACE : Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void trace(String string, Object object, Object object2) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.logger.log(FQCN, this.traceCapable ? Level.TRACE : Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void trace(String string, Object ... objectArray) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.logger.log(FQCN, this.traceCapable ? Level.TRACE : Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void trace(String string, Throwable throwable) {
        this.logger.log(FQCN, this.traceCapable ? Level.TRACE : Level.DEBUG, string, throwable);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String string) {
        this.logger.log(FQCN, Level.DEBUG, string, null);
    }

    public void debug(String string, Object object) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.logger.log(FQCN, Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void debug(String string, Object object, Object object2) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.logger.log(FQCN, Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.logger.log(FQCN, Level.DEBUG, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void debug(String string, Throwable throwable) {
        this.logger.log(FQCN, Level.DEBUG, string, throwable);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String string) {
        this.logger.log(FQCN, Level.INFO, string, null);
    }

    public void info(String string, Object object) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.logger.log(FQCN, Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void info(String string, Object object, Object object2) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.logger.log(FQCN, Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.logger.log(FQCN, Level.INFO, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void info(String string, Throwable throwable) {
        this.logger.log(FQCN, Level.INFO, string, throwable);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Level.WARN);
    }

    public void warn(String string) {
        this.logger.log(FQCN, Level.WARN, string, null);
    }

    public void warn(String string, Object object) {
        if (this.logger.isEnabledFor(Level.WARN)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.logger.log(FQCN, Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void warn(String string, Object object, Object object2) {
        if (this.logger.isEnabledFor(Level.WARN)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.logger.log(FQCN, Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void warn(String string, Object ... objectArray) {
        if (this.logger.isEnabledFor(Level.WARN)) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.logger.log(FQCN, Level.WARN, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void warn(String string, Throwable throwable) {
        this.logger.log(FQCN, Level.WARN, string, throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor(Level.ERROR);
    }

    public void error(String string) {
        this.logger.log(FQCN, Level.ERROR, string, null);
    }

    public void error(String string, Object object) {
        if (this.logger.isEnabledFor(Level.ERROR)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object);
            this.logger.log(FQCN, Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void error(String string, Object object, Object object2) {
        if (this.logger.isEnabledFor(Level.ERROR)) {
            FormattingTuple formattingTuple = MessageFormatter.format(string, object, object2);
            this.logger.log(FQCN, Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void error(String string, Object ... objectArray) {
        if (this.logger.isEnabledFor(Level.ERROR)) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string, objectArray);
            this.logger.log(FQCN, Level.ERROR, formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void error(String string, Throwable throwable) {
        this.logger.log(FQCN, Level.ERROR, string, throwable);
    }

    public void log(Marker marker, String string, int n, String string2, Object[] objectArray, Throwable throwable) {
        Level level;
        switch (n) {
            case 0: {
                level = this.traceCapable ? Level.TRACE : Level.DEBUG;
                break;
            }
            case 10: {
                level = Level.DEBUG;
                break;
            }
            case 20: {
                level = Level.INFO;
                break;
            }
            case 30: {
                level = Level.WARN;
                break;
            }
            case 40: {
                level = Level.ERROR;
                break;
            }
            default: {
                throw new IllegalStateException("Level number " + n + " is not recognized.");
            }
        }
        this.logger.log(string, level, string2, throwable);
    }
}

