/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.spi.MDCAdapter;

public class BasicMDCAdapter
implements MDCAdapter {
    private InheritableThreadLocal inheritableThreadLocal = new InheritableThreadLocal();
    static boolean IS_JDK14 = BasicMDCAdapter.isJDK14();

    static boolean isJDK14() {
        try {
            String string = System.getProperty("java.version");
            return string.startsWith("1.4");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void put(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> map = (Map<String, String>)this.inheritableThreadLocal.get();
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            this.inheritableThreadLocal.set(map);
        }
        map.put(string, string2);
    }

    public String get(String string) {
        Map map = (Map)this.inheritableThreadLocal.get();
        if (map != null && string != null) {
            return (String)map.get(string);
        }
        return null;
    }

    public void remove(String string) {
        Map map = (Map)this.inheritableThreadLocal.get();
        if (map != null) {
            map.remove(string);
        }
    }

    public void clear() {
        Map map = (Map)this.inheritableThreadLocal.get();
        if (map != null) {
            map.clear();
            if (BasicMDCAdapter.isJDK14()) {
                this.inheritableThreadLocal.set(null);
            } else {
                this.inheritableThreadLocal.remove();
            }
        }
    }

    public Set getKeys() {
        Map map = (Map)this.inheritableThreadLocal.get();
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCopyOfContextMap() {
        Map map = (Map)this.inheritableThreadLocal.get();
        if (map != null) {
            Map map2 = Collections.synchronizedMap(new HashMap());
            Map map3 = map;
            synchronized (map3) {
                map2.putAll(map);
            }
            return map2;
        }
        return null;
    }

    public void setContextMap(Map map) {
        Map map2 = Collections.synchronizedMap(new HashMap(map));
        this.inheritableThreadLocal.set(map2);
    }
}

