/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.varia.ExternallyRolledFileAppender;

class HUPNode
implements Runnable {
    Socket socket;
    DataInputStream dis;
    DataOutputStream dos;
    ExternallyRolledFileAppender er;

    public HUPNode(Socket socket, ExternallyRolledFileAppender externallyRolledFileAppender) {
        this.socket = socket;
        this.er = externallyRolledFileAppender;
        try {
            this.dis = new DataInputStream(socket.getInputStream());
            this.dos = new DataOutputStream(socket.getOutputStream());
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            interruptedIOException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String string = this.dis.readUTF();
            LogLog.debug("Got external roll over signal.");
            if ("RollOver".equals(string)) {
                ExternallyRolledFileAppender externallyRolledFileAppender = this.er;
                synchronized (externallyRolledFileAppender) {
                    this.er.rollOver();
                }
                this.dos.writeUTF("OK");
            } else {
                this.dos.writeUTF("Expecting [RollOver] string.");
            }
            this.dos.close();
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            LogLog.error("Unexpected exception. Exiting HUPNode.", interruptedIOException);
        }
        catch (IOException iOException) {
            LogLog.error("Unexpected exception. Exiting HUPNode.", iOException);
        }
        catch (RuntimeException runtimeException) {
            LogLog.error("Unexpected exception. Exiting HUPNode.", runtimeException);
        }
    }
}

