/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;

public class LocationInfo
implements Serializable {
    transient String lineNumber;
    transient String fileName;
    transient String className;
    transient String methodName;
    public String fullInfo;
    private static StringWriter sw = new StringWriter();
    private static PrintWriter pw = new PrintWriter(sw);
    private static Method getStackTraceMethod;
    private static Method getClassNameMethod;
    private static Method getMethodNameMethod;
    private static Method getFileNameMethod;
    private static Method getLineNumberMethod;
    public static final String NA = "?";
    static final long serialVersionUID = -1325822038990805636L;
    public static final LocationInfo NA_LOCATION_INFO;
    static boolean inVisualAge;
    static /* synthetic */ Class class$java$lang$Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationInfo(Throwable throwable, String string) {
        int n;
        String string2;
        if (throwable == null || string == null) {
            return;
        }
        if (getLineNumberMethod != null) {
            try {
                Object[] objectArray = null;
                Object[] objectArray2 = (Object[])getStackTraceMethod.invoke((Object)throwable, objectArray);
                String string3 = NA;
                for (int i = objectArray2.length - 1; i >= 0; --i) {
                    String string4 = (String)getClassNameMethod.invoke(objectArray2[i], objectArray);
                    if (string.equals(string4)) {
                        int n2 = i + 1;
                        if (n2 < objectArray2.length) {
                            int n3;
                            this.className = string3;
                            this.methodName = (String)getMethodNameMethod.invoke(objectArray2[n2], objectArray);
                            this.fileName = (String)getFileNameMethod.invoke(objectArray2[n2], objectArray);
                            if (this.fileName == null) {
                                this.fileName = NA;
                            }
                            this.lineNumber = (n3 = ((Integer)getLineNumberMethod.invoke(objectArray2[n2], objectArray)).intValue()) < 0 ? NA : String.valueOf(n3);
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(this.className);
                            stringBuffer.append(".");
                            stringBuffer.append(this.methodName);
                            stringBuffer.append("(");
                            stringBuffer.append(this.fileName);
                            stringBuffer.append(":");
                            stringBuffer.append(this.lineNumber);
                            stringBuffer.append(")");
                            this.fullInfo = stringBuffer.toString();
                        }
                        return;
                    }
                    string3 = string4;
                }
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                LogLog.debug("LocationInfo failed using JDK 1.4 methods", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof InterruptedException || invocationTargetException.getTargetException() instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.debug("LocationInfo failed using JDK 1.4 methods", invocationTargetException);
            }
            catch (RuntimeException runtimeException) {
                LogLog.debug("LocationInfo failed using JDK 1.4 methods", runtimeException);
            }
        }
        StringWriter stringWriter = sw;
        synchronized (stringWriter) {
            throwable.printStackTrace(pw);
            string2 = sw.toString();
            sw.getBuffer().setLength(0);
        }
        int n4 = string2.lastIndexOf(string);
        if (n4 == -1) {
            return;
        }
        if (n4 + string.length() < string2.length() && string2.charAt(n4 + string.length()) != '.' && (n = string2.lastIndexOf(string + ".")) != -1) {
            n4 = n;
        }
        if ((n4 = string2.indexOf(Layout.LINE_SEP, n4)) == -1) {
            return;
        }
        int n5 = string2.indexOf(Layout.LINE_SEP, n4 += Layout.LINE_SEP_LEN);
        if (n5 == -1) {
            return;
        }
        if (!inVisualAge) {
            n4 = string2.lastIndexOf("at ", n5);
            if (n4 == -1) {
                return;
            }
            n4 += 3;
        }
        this.fullInfo = string2.substring(n4, n5);
    }

    private static final void appendFragment(StringBuffer stringBuffer, String string) {
        if (string == null) {
            stringBuffer.append(NA);
        } else {
            stringBuffer.append(string);
        }
    }

    public LocationInfo(String string, String string2, String string3, String string4) {
        this.fileName = string;
        this.className = string2;
        this.methodName = string3;
        this.lineNumber = string4;
        StringBuffer stringBuffer = new StringBuffer();
        LocationInfo.appendFragment(stringBuffer, string2);
        stringBuffer.append(".");
        LocationInfo.appendFragment(stringBuffer, string3);
        stringBuffer.append("(");
        LocationInfo.appendFragment(stringBuffer, string);
        stringBuffer.append(":");
        LocationInfo.appendFragment(stringBuffer, string4);
        stringBuffer.append(")");
        this.fullInfo = stringBuffer.toString();
    }

    public String getClassName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.className == null) {
            int n = this.fullInfo.lastIndexOf(40);
            if (n == -1) {
                this.className = NA;
            } else {
                n = this.fullInfo.lastIndexOf(46, n);
                int n2 = 0;
                if (inVisualAge) {
                    n2 = this.fullInfo.lastIndexOf(32, n) + 1;
                }
                this.className = n == -1 ? NA : this.fullInfo.substring(n2, n);
            }
        }
        return this.className;
    }

    public String getFileName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.fileName == null) {
            int n = this.fullInfo.lastIndexOf(58);
            if (n == -1) {
                this.fileName = NA;
            } else {
                int n2 = this.fullInfo.lastIndexOf(40, n - 1);
                this.fileName = this.fullInfo.substring(n2 + 1, n);
            }
        }
        return this.fileName;
    }

    public String getLineNumber() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.lineNumber == null) {
            int n = this.fullInfo.lastIndexOf(41);
            int n2 = this.fullInfo.lastIndexOf(58, n - 1);
            this.lineNumber = n2 == -1 ? NA : this.fullInfo.substring(n2 + 1, n);
        }
        return this.lineNumber;
    }

    public String getMethodName() {
        if (this.fullInfo == null) {
            return NA;
        }
        if (this.methodName == null) {
            int n = this.fullInfo.lastIndexOf(40);
            int n2 = this.fullInfo.lastIndexOf(46, n);
            this.methodName = n2 == -1 ? NA : this.fullInfo.substring(n2 + 1, n);
        }
        return this.methodName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NA_LOCATION_INFO = new LocationInfo(NA, NA, NA, NA);
        inVisualAge = false;
        try {
            inVisualAge = Class.forName("com.ibm.uvm.tools.DebugSupport") != null;
            LogLog.debug("Detected IBM VisualAge environment.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class<?>[] classArray = null;
            getStackTraceMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = LocationInfo.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getStackTrace", classArray);
            Class<?> clazz = Class.forName("java.lang.StackTraceElement");
            getClassNameMethod = clazz.getMethod("getClassName", classArray);
            getMethodNameMethod = clazz.getMethod("getMethodName", classArray);
            getFileNameMethod = clazz.getMethod("getFileName", classArray);
            getLineNumberMethod = clazz.getMethod("getLineNumber", classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.debug("LocationInfo will use pre-JDK 1.4 methods to determine location.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.debug("LocationInfo will use pre-JDK 1.4 methods to determine location.");
        }
    }
}

