/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.osgi.logging;

import com.agfa.hap.osgi.logging.Activator;
import com.agfa.hap.osgi.logging.ConfigurationXMLHandler;
import com.agfa.hap.osgi.logging.IBasicLogConfiguration;
import com.agfa.hap.osgi.logging.LogConfigurationComparator;
import com.agfa.hap.osgi.logging.SystemOutRedirector;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.xml.DOMConfigurator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Controller {
    private static final Controller INSTANCE = new Controller();
    private static final Logger logger = LoggerFactory.getLogger("com.agfa.hap.osgi.logging");
    static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String XML_CONFIGURATIONS_TAG = "configurations";
    static final String XML_CONFIGURATION_TAG = "configuration";
    static final String XML_ESCALATION_TAG = "escalation";
    static final String XML_INSTRUMENTATION_TAG = "instrumentation";
    static final String XML_ID_ATTR = "id";
    private List<IBasicLogConfiguration> logConfigurations = null;
    private List<IBasicLogConfiguration> logEscalations = null;
    private List<IBasicLogConfiguration> logInstrumentations = null;
    private PrintStream out = null;
    private PrintStream err = null;

    private Controller() {
    }

    public static Controller getInstance() {
        return INSTANCE;
    }

    protected void manualConfiguration(URL uRL) {
        System.out.println("Explicitly applying log configuration.");
        DOMConfigurator.configure(uRL);
    }

    protected void start() {
        SLF4JBridgeHandler.install();
        try {
            final ConfigurationXMLHandler configurationXMLHandler = new ConfigurationXMLHandler(this.getConfigurationFile());
            final List<IBasicLogConfiguration> list = this.findLogConfigurationPlugins();
            final boolean bl = list.size() > 0 && this.initialize(configurationXMLHandler.getConfiguration(), Arrays.asList(list.get(0)), !Activator.getInstance().isConfigurationOverriden());
            new Thread("Log Configuration"){

                @Override
                public void run() {
                    boolean bl2 = bl;
                    if (list.size() > 1) {
                        bl2 &= Controller.this.initialize(configurationXMLHandler.getConfiguration(), list.subList(1, list.size()), !Activator.getInstance().isConfigurationOverriden());
                    }
                    bl2 &= Controller.this.initialize(configurationXMLHandler.getEscalation(), Controller.this.findLogEscalationPlugins(), true);
                    bl2 &= Controller.this.initialize(configurationXMLHandler.getInstrumentation(), Controller.this.findLogInstrumentationPlugins(), true);
                    if (list.size() == 0 && !Activator.getInstance().isConfigurationOverriden()) {
                        System.out.println("No plugins available and the log configuration is not overriden by a configuration file... using a minimal log configuration.");
                        BasicConfigurator.configure();
                    }
                    if (bl2) {
                        Controller.this.saveLogConfigurations();
                    }
                    if (Activator.getInstance().redirectStdOut()) {
                        System.out.println("Redirecting stdout and stderr");
                        Controller.this.out = System.out;
                        Controller.this.err = System.err;
                        System.setOut(new SystemOutRedirector("System.out", Level.INFO));
                        System.setErr(new SystemOutRedirector("System.err", Level.ERROR));
                    }
                    logger.info("Log system is up and running.");
                }
            }.start();
        }
        catch (Exception exception) {
            logger.error("Could not read log configuration from " + this.getConfigurationFile());
        }
    }

    protected void stop() {
        SLF4JBridgeHandler.uninstall();
        this.logConfigurations = null;
        this.logEscalations = null;
        this.logInstrumentations = null;
        if (Activator.getInstance().redirectStdOut()) {
            System.out.println("Restoring redirected stdout and stderr");
            System.setOut(this.out);
            System.setErr(this.err);
        }
    }

    public List<IBasicLogConfiguration> findLogConfigurationPlugins() {
        if (this.logConfigurations == null) {
            this.logConfigurations = new ArrayList<IBasicLogConfiguration>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.agfa.hap.osgi.logging.configuration");
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
                try {
                    Object object = iConfigurationElement.createExecutableExtension("class");
                    if (object == null || !(object instanceof IBasicLogConfiguration)) continue;
                    this.logConfigurations.add((IBasicLogConfiguration)object);
                    continue;
                }
                catch (CoreException coreException) {
                    logger.warn("Unable to retrieve log configuration extension point.", coreException);
                }
            }
            Collections.sort(this.logConfigurations, new LogConfigurationComparator());
        }
        return this.logConfigurations;
    }

    public void resetConfiguration() {
        try {
            ConfigurationXMLHandler configurationXMLHandler = new ConfigurationXMLHandler(this.getConfigurationFile());
            this.reset(configurationXMLHandler.getConfiguration(), this.findLogConfigurationPlugins());
            this.reset(configurationXMLHandler.getEscalation(), this.findLogEscalationPlugins());
            this.reset(configurationXMLHandler.getInstrumentation(), this.findLogInstrumentationPlugins());
        }
        catch (Exception exception) {
            logger.error("Could not read log configuration from " + this.getConfigurationFile());
        }
    }

    public List<IBasicLogConfiguration> findLogEscalationPlugins() {
        if (this.logEscalations == null) {
            this.logEscalations = new ArrayList<IBasicLogConfiguration>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.agfa.hap.osgi.logging.escalation");
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
                try {
                    Object object = iConfigurationElement.createExecutableExtension("class");
                    if (object == null || !(object instanceof IBasicLogConfiguration)) continue;
                    this.logEscalations.add((IBasicLogConfiguration)object);
                    continue;
                }
                catch (CoreException coreException) {
                    logger.warn("Unable to retrieve log escalation extension point.", coreException);
                }
            }
            Collections.sort(this.logEscalations, new LogConfigurationComparator());
        }
        return this.logEscalations;
    }

    public List<IBasicLogConfiguration> findLogInstrumentationPlugins() {
        if (this.logInstrumentations == null) {
            this.logInstrumentations = new ArrayList<IBasicLogConfiguration>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.agfa.hap.osgi.logging.instrumentation");
            for (int i = 0; i < iConfigurationElementArray.length; ++i) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
                try {
                    Object object = iConfigurationElement.createExecutableExtension("class");
                    if (object == null || !(object instanceof IBasicLogConfiguration)) continue;
                    this.logInstrumentations.add((IBasicLogConfiguration)object);
                    continue;
                }
                catch (CoreException coreException) {
                    logger.warn("Unable to retrieve log instrumentation extension point.", coreException);
                }
            }
            Collections.sort(this.logInstrumentations, new LogConfigurationComparator());
        }
        return this.logInstrumentations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLogConfigurations() {
        File file = this.getConfigurationFile();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(XML_HEADER).append("\n");
        stringBuilder.append("<").append(XML_CONFIGURATIONS_TAG).append(">\n");
        for (IBasicLogConfiguration iBasicLogConfiguration : this.findLogConfigurationPlugins()) {
            stringBuilder.append("  <").append(XML_CONFIGURATION_TAG).append(" ").append(XML_ID_ATTR).append("=\"").append(iBasicLogConfiguration.getProfileId()).append("\">");
            stringBuilder.append("<![CDATA[").append(iBasicLogConfiguration.getConfiguration()).append("]]>");
            stringBuilder.append("</").append(XML_CONFIGURATION_TAG).append(">\n");
        }
        for (IBasicLogConfiguration iBasicLogConfiguration : this.findLogEscalationPlugins()) {
            stringBuilder.append("  <").append(XML_ESCALATION_TAG).append(" ").append(XML_ID_ATTR).append("=\"").append(iBasicLogConfiguration.getProfileId()).append("\">");
            stringBuilder.append("<![CDATA[").append(iBasicLogConfiguration.getConfiguration()).append("]]>");
            stringBuilder.append("</").append(XML_ESCALATION_TAG).append(">\n");
        }
        for (IBasicLogConfiguration iBasicLogConfiguration : this.findLogInstrumentationPlugins()) {
            stringBuilder.append("  <").append(XML_INSTRUMENTATION_TAG).append(" ").append(XML_ID_ATTR).append("=\"").append(iBasicLogConfiguration.getProfileId()).append("\">");
            stringBuilder.append("<![CDATA[").append(iBasicLogConfiguration.getConfiguration()).append("]]>");
            stringBuilder.append("</").append(XML_INSTRUMENTATION_TAG).append(">\n");
        }
        stringBuilder.append("</").append(XML_CONFIGURATIONS_TAG).append(">\n");
        Object object = null;
        try {
            object = new PrintWriter(new FileWriter(file));
            ((PrintWriter)object).print(stringBuilder.toString());
            ((PrintWriter)object).flush();
        }
        catch (IOException iOException) {
            logger.warn("Unable to cache log configuration!", iOException);
        }
        finally {
            if (object != null) {
                ((PrintWriter)object).close();
            }
        }
    }

    private File getConfigurationFile() {
        File file = null;
        String string = System.getProperty("osgi.instance.area", ".");
        if (string.startsWith("file:")) {
            try {
                URL uRL = new URL(string);
                try {
                    file = new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(uRL.getPath());
                }
            }
            catch (Exception exception) {
                file = new File(".");
            }
        } else {
            file = new File(string);
        }
        if (!(file = new File(file, ".logging")).exists()) {
            file.mkdirs();
        }
        return new File(file, "logConfig.xml");
    }

    private boolean initialize(Map<String, String> map, List<IBasicLogConfiguration> list, boolean bl) {
        boolean bl2 = false;
        for (IBasicLogConfiguration iBasicLogConfiguration : list) {
            String string = map.get(iBasicLogConfiguration.getProfileId());
            if (string != null) {
                iBasicLogConfiguration.setConfiguration(string);
            } else {
                bl2 = true;
            }
            if (!bl) continue;
            iBasicLogConfiguration.applyConfiguration();
        }
        return bl2;
    }

    private void reset(Map<String, String> map, List<IBasicLogConfiguration> list) {
        for (IBasicLogConfiguration iBasicLogConfiguration : list) {
            String string = map.get(iBasicLogConfiguration.getProfileId());
            if (string == null) continue;
            iBasicLogConfiguration.setConfiguration(string);
        }
    }
}

