/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.osgi.logging;

import com.agfa.hap.osgi.logging.Controller;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class Activator
implements BundleActivator {
    private static final String USE_LOG4J_RESOURCE = "log4j.useResource";
    private static final String USE_LOG4J_RESOURCE_BUNDLE = "log4j.useResourceBundle";
    public static final String DEFAULT_CONFIGURATION_KEY = "log4j.configuration";
    public static final String REDIRECT_STD_OUT_ERR = "log4j.redirectStdOutErr";
    private boolean configurationViaFile = System.getProperty("log4j.configuration", null) != null;
    private boolean useLog4jResource = "true".equalsIgnoreCase(System.getProperty("log4j.useResource", "false"));
    private String useLog4jResourceBundle = System.getProperty("log4j.useResourceBundle");
    private boolean redirectStdOutErr = "true".equalsIgnoreCase(System.getProperty("log4j.redirectStdOutErr", "false"));
    private static Activator instance;
    private BundleContext context;

    public void start(BundleContext bundleContext) {
        this.context = bundleContext;
        Logger.class.getName();
        LoggingEvent.class.getName();
        NDC.class.getName();
        LogLog.setQuietMode(true);
        System.out.println("Starting the logging subsystem (log4j.useResource=" + System.getProperty(USE_LOG4J_RESOURCE, "Not set") + ", " + USE_LOG4J_RESOURCE_BUNDLE + "=" + System.getProperty(USE_LOG4J_RESOURCE_BUNDLE, "Not set") + ", " + DEFAULT_CONFIGURATION_KEY + "=" + System.getProperty(DEFAULT_CONFIGURATION_KEY, "Not set") + ", " + REDIRECT_STD_OUT_ERR + "=" + System.getProperty(REDIRECT_STD_OUT_ERR, "Not set") + ")");
        instance = this;
        if (this.useLog4jResource) {
            URL uRL = null;
            for (Bundle bundle : bundleContext.getBundles()) {
                if (this.useLog4jResourceBundle != null && !this.useLog4jResourceBundle.equals(bundle.getSymbolicName()) || (uRL = bundle.getEntry("log4j.xml")) == null) continue;
                System.out.println("Using log4j configuration from bundle " + bundle.getSymbolicName() + " : " + uRL.toString());
                Controller.getInstance().manualConfiguration(uRL);
                System.setProperty(DEFAULT_CONFIGURATION_KEY, uRL.toString());
                this.configurationViaFile = true;
                break;
            }
            if (uRL == null) {
                System.err.println("Unable to find log4j.xml resource, proceeding with default configuration");
            }
        }
        Controller.getInstance().start();
    }

    public boolean redirectStdOut() {
        return this.useLog4jResource && this.redirectStdOutErr;
    }

    public boolean isConfigurationOverriden() {
        return this.configurationViaFile;
    }

    public void stop(BundleContext bundleContext) {
        Logger.getLogger("flush").fatal("FLUSHING LOGS -- THIS IS NOT AN ERROR MESSAGE");
        System.out.println("Stopping the logging subsystem.");
        Controller.getInstance().stop();
        instance = null;
        this.context = null;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public static Activator getInstance() {
        return instance;
    }
}

