/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login;

import com.agfa.pacs.login.Log4jSystemOutRedirector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class Log4jInitializer {
    private static final String LOG4J_XML_CONFIGURATION_FILE = "log4j.xml";
    private static final String LOG4J_XML_DEFAULT_FILE = "log4.xml";

    private Log4jInitializer() {
    }

    static void initialise() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        ClassLoader classLoader2 = null;
        try {
            try {
                InputStream inputStream;
                FileOutputStream fileOutputStream;
                File file = new File(LOG4J_XML_CONFIGURATION_FILE);
                thread.setContextClassLoader(Log4jInitializer.class.getClassLoader());
                if (!file.exists()) {
                    fileOutputStream = new FileOutputStream(LOG4J_XML_CONFIGURATION_FILE);
                    classLoader2 = Log4jInitializer.class.getClassLoader();
                    inputStream = classLoader2.getResourceAsStream(LOG4J_XML_DEFAULT_FILE);
                    if (!Log4jInitializer.copyFiles(fileOutputStream, inputStream)) {
                        DOMConfigurator.configure((Element)Log4jInitializer.getRessourceConfiguration(classLoader2));
                    } else {
                        DOMConfigurator.configure((String)LOG4J_XML_CONFIGURATION_FILE);
                    }
                } else {
                    DOMConfigurator.configure((String)file.getAbsolutePath());
                }
                LogLog.debug((String)"log4j is initialized");
                System.setOut(new Log4jSystemOutRedirector("System.out", (Priority)Level.INFO));
                System.setErr(new Log4jSystemOutRedirector("System.err", (Priority)Level.ERROR));
                inputStream = Logger.getLogger((String)"org.dcm4che3");
                fileOutputStream = inputStream.getLevel();
                if (fileOutputStream == null) {
                    inputStream.setLevel(Level.WARN);
                    classLoader2 = Log4jInitializer.class.getClassLoader();
                    InputStream inputStream2 = classLoader2.getResourceAsStream(LOG4J_XML_DEFAULT_FILE);
                    FileOutputStream fileOutputStream2 = new FileOutputStream(LOG4J_XML_CONFIGURATION_FILE);
                    Log4jInitializer.copyFiles(fileOutputStream2, inputStream2);
                    System.err.println("Replacing old log4j.xml file, by a newer version");
                }
            }
            catch (IOException iOException) {
                System.out.println("log4j is not initialized, Skipping log4j.xml taking internal");
                DOMConfigurator.configure((URL)classLoader2.getResource(LOG4J_XML_DEFAULT_FILE));
                thread.setContextClassLoader(classLoader);
            }
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private static Element getRessourceConfiguration(ClassLoader classLoader) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            LogLog.setQuietMode((boolean)true);
            Document document = documentBuilder.parse(classLoader.getResourceAsStream(LOG4J_XML_DEFAULT_FILE));
            Element element = (Element)document.getElementsByTagName("configuration").item(0);
            return element;
        }
        catch (Exception exception) {
            System.err.println("Could not read default logger configuration");
            return null;
        }
    }

    private static boolean copyFiles(OutputStream outputStream, InputStream inputStream) {
        block30: {
            if (inputStream != null && outputStream != null) break block30;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
        try {
            try {
                int n;
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException2) {}
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
        return true;
    }
}

