/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.logging;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.MDC;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public final class ClientLogXMLLayout
extends Layout {
    public static final String USER_KEY = "User";
    public static final String CLIENT_HOST_KEY = "ClientHost";
    private static final int DEFAULT_SIZE = 256;
    private static final int UPPER_LIMIT = 2048;
    private StringBuffer buf = new StringBuffer(256);
    private boolean locationInfo = false;
    private String clientHostName = null;
    private String user = "";

    public ClientLogXMLLayout(String string) {
        this.user = string;
        try {
            this.clientHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.clientHostName = "local";
        }
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void activateOptions() {
    }

    public String format(LoggingEvent loggingEvent) {
        String[] stringArray;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuffer(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event logger=\"");
        this.buf.append(loggingEvent.getLoggerName());
        this.buf.append("\" timestamp=\"");
        this.buf.append(loggingEvent.timeStamp);
        this.buf.append("\" level=\"");
        this.buf.append(loggingEvent.getLevel());
        this.buf.append("\" thread=\"");
        this.buf.append(loggingEvent.getThreadName());
        this.buf.append("\">\r\n");
        this.buf.append("<log4j:message><![CDATA[");
        Transform.appendEscapingCDATA((StringBuffer)this.buf, (String)loggingEvent.getRenderedMessage());
        this.buf.append("]]></log4j:message>\r\n");
        String string = loggingEvent.getNDC();
        if (string != null) {
            this.buf.append("<log4j:NDC><![CDATA[");
            this.buf.append(string);
            this.buf.append("]]></log4j:NDC>\r\n");
        }
        if ((stringArray = loggingEvent.getThrowableStrRep()) != null) {
            this.buf.append("<log4j:throwable><![CDATA[");
            int n = 0;
            while (n < stringArray.length) {
                this.buf.append(stringArray[n]);
                this.buf.append("\r\n");
                ++n;
            }
            this.buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            LocationInfo locationInfo = loggingEvent.getLocationInformation();
            this.buf.append("<log4j:locationInfo class=\"");
            this.buf.append(Transform.escapeTags((String)locationInfo.getClassName()));
            this.buf.append("\" method=\"");
            this.buf.append(Transform.escapeTags((String)locationInfo.getMethodName()));
            this.buf.append("\" file=\"");
            this.buf.append(locationInfo.getFileName());
            this.buf.append("\" line=\"");
            this.buf.append(locationInfo.getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        Set<?> set = this.getMDCKeySet(loggingEvent);
        boolean bl = false;
        boolean bl2 = false;
        this.buf.append("<log4j:properties>\r\n");
        if (set != null && set.size() > 0) {
            ArrayList arrayList = new ArrayList(set);
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (CLIENT_HOST_KEY.equals(string2)) {
                    bl = true;
                }
                if (USER_KEY.equals(string2)) {
                    bl2 = true;
                }
                this.buf.append(" <log4j:data name=\"" + string2);
                String string3 = loggingEvent.getMDC(string2).toString();
                this.buf.append("\" value=\"" + string3);
                this.buf.append("\"/>\r\n");
            }
        }
        if (!bl) {
            this.buf.append(" <log4j:data name=\"ClientHost");
            this.buf.append("\" value=\"" + this.clientHostName);
            this.buf.append("\"/>\r\n");
        }
        if (!bl2) {
            this.buf.append(" <log4j:data name=\"User");
            this.buf.append("\" value=\"" + this.user);
            this.buf.append("\"/>\r\n");
        }
        this.buf.append("</log4j:properties>\r\n");
        this.buf.append("</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    private Set<?> getMDCKeySet(LoggingEvent loggingEvent) {
        Field[] fieldArray;
        Set set = null;
        Field[] fieldArray2 = fieldArray = LoggingEvent.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if ("mdcCopy".equals(field.getName())) {
                Hashtable hashtable;
                field.setAccessible(true);
                try {
                    hashtable = (Hashtable)field.get(loggingEvent);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                set = hashtable != null ? hashtable.keySet() : (MDC.getContext() != null ? MDC.getContext().keySet() : new HashSet());
                field.setAccessible(false);
                break;
            }
            ++n2;
        }
        return set;
    }

    public boolean ignoresThrowable() {
        return false;
    }
}

