/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.logging;

import com.agfa.pacs.logging.LoggerCategories;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public abstract class ALogger
implements Logger {
    private static final String USE_EXTENDED_LOGGERS_PROPERTY_KEY = "aLogger.useExtendedLoggers";
    private static final boolean useExtendedLoggers = Boolean.getBoolean("aLogger.useExtendedLoggers");
    private static final List<org.apache.log4j.Logger> allExtendedLoggers = new ArrayList<org.apache.log4j.Logger>();
    private static final String EXTENDED_LOGGER_APPENDER_PREFIX = "extendedLogger-";
    private static final String DEFAULT_FILE_APPENDER_FILENAME_PREFIX = "agility_";
    private static final String DEFAULT_FILE_APPENDER_LOG_LAYOUT = "%d %-5r %-5p [%c]@%m%n";

    public static ALogger getLogger(Class<?> clazz) {
        String string = clazz.getName();
        if (useExtendedLoggers) {
            String[] stringArray = null;
            LoggerCategories loggerCategories = clazz.getAnnotation(LoggerCategories.class);
            if (loggerCategories != null) {
                stringArray = loggerCategories.value();
            }
            if (stringArray != null) {
                return ALogger.getLogger(string, stringArray);
            }
        }
        return ALogger.getLogger(string);
    }

    public static ALogger getLogger(String string) {
        Logger logger = LoggerFactory.getLogger((String)string);
        return new SimpleAdapter(logger);
    }

    private static ALogger getLogger(String string, String[] stringArray) {
        Logger logger = LoggerFactory.getLogger((String)string);
        ArrayList<org.apache.log4j.Logger> arrayList = null;
        if (stringArray != null) {
            arrayList = new ArrayList<org.apache.log4j.Logger>(3);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                org.apache.log4j.Logger logger2 = org.apache.log4j.Logger.getLogger((String)string2);
                ALogger.configureExtendedLogger(logger2);
                if (!allExtendedLoggers.contains(logger2)) {
                    allExtendedLoggers.add(logger2);
                }
                arrayList.add(logger2);
                ++n2;
            }
        }
        return new ExtendedAdapter(string, logger, arrayList);
    }

    public static List<org.apache.log4j.Logger> getAllExtendedLoggers() {
        return new ArrayList<org.apache.log4j.Logger>(allExtendedLoggers);
    }

    private static void configureExtendedLogger(org.apache.log4j.Logger logger) {
        String string = logger.getName();
        String string2 = EXTENDED_LOGGER_APPENDER_PREFIX + string;
        Appender appender = logger.getAppender(string2);
        logger.setAdditivity(false);
        if (appender == null) {
            logger.removeAllAppenders();
            RollingFileAppender rollingFileAppender = new RollingFileAppender();
            rollingFileAppender.setName(string2);
            File file = new File(DEFAULT_FILE_APPENDER_FILENAME_PREFIX + string + ".log");
            rollingFileAppender.setFile(file.getAbsolutePath());
            rollingFileAppender.setMaxBackupIndex(5);
            rollingFileAppender.setAppend(false);
            rollingFileAppender.setBufferedIO(true);
            PatternLayout patternLayout = new PatternLayout(DEFAULT_FILE_APPENDER_LOG_LAYOUT);
            rollingFileAppender.setLayout((Layout)patternLayout);
            rollingFileAppender.activateOptions();
            logger.addAppender((Appender)rollingFileAppender);
        }
    }

    private static class ExtendedAdapter
    extends ALogger {
        private final Logger delegate;
        private final org.apache.log4j.Logger delegateLog4j;
        private final List<org.apache.log4j.Logger> extendedLoggers;
        private final String simpleName;

        ExtendedAdapter(String string, Logger logger, List<org.apache.log4j.Logger> list) {
            this.delegate = logger;
            this.delegateLog4j = org.apache.log4j.Logger.getLogger((String)string);
            this.extendedLoggers = list;
            int n = string.lastIndexOf(46);
            this.simpleName = n == -1 ? string : string.substring(n + 1, string.length());
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isTraceEnabled() {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isTraceEnabled()) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isTraceEnabled();
        }

        public void trace(String string) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2);
                    ++n;
                }
            }
        }

        public void trace(String string, Object object) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void trace(String string, Object object, Object object2) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void trace(String string, Object[] objectArray) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void trace(String string, Throwable throwable) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isTraceEnabled(Marker marker) {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isTraceEnabled()) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isTraceEnabled(marker);
        }

        public void trace(Marker marker, String string) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(marker, string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2);
                    ++n;
                }
            }
        }

        public void trace(Marker marker, String string, Object object) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(marker, string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void trace(Marker marker, String string, Object object, Object object2) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(marker, string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void trace(Marker marker, String string, Object[] objectArray) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(marker, string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void trace(Marker marker, String string, Throwable throwable) {
            if (!this.isTraceEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.TRACE);
            this.delegate.trace(marker, string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).trace((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isDebugEnabled() {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isDebugEnabled()) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isDebugEnabled();
        }

        public void debug(String string) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2);
                    ++n;
                }
            }
        }

        public void debug(String string, Object object) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void debug(String string, Object object, Object object2) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void debug(String string, Object[] objectArray) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void debug(String string, Throwable throwable) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isDebugEnabled(Marker marker) {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isDebugEnabled()) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isDebugEnabled(marker);
        }

        public void debug(Marker marker, String string) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(marker, string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2);
                    ++n;
                }
            }
        }

        public void debug(Marker marker, String string, Object object) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(marker, string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void debug(Marker marker, String string, Object object, Object object2) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(marker, string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void debug(Marker marker, String string, Object[] objectArray) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(marker, string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void debug(Marker marker, String string, Throwable throwable) {
            if (!this.isDebugEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.DEBUG);
            this.delegate.debug(marker, string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).debug((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isInfoEnabled() {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isInfoEnabled()) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isInfoEnabled();
        }

        public void info(String string) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2);
                    ++n;
                }
            }
        }

        public void info(String string, Object object) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void info(String string, Object object, Object object2) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void info(String string, Object[] objectArray) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void info(String string, Throwable throwable) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isInfoEnabled(Marker marker) {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isInfoEnabled()) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isInfoEnabled(marker);
        }

        public void info(Marker marker, String string) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(marker, string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2);
                    ++n;
                }
            }
        }

        public void info(Marker marker, String string, Object object) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(marker, string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void info(Marker marker, String string, Object object, Object object2) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(marker, string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void info(Marker marker, String string, Object[] objectArray) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(marker, string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void info(Marker marker, String string, Throwable throwable) {
            if (!this.isInfoEnabled()) {
                return;
            }
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.INFO);
            this.delegate.info(marker, string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).info((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isWarnEnabled() {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isEnabledFor((Priority)Level.WARN)) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isWarnEnabled();
        }

        public void warn(String string) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2);
                    ++n;
                }
            }
        }

        public void warn(String string, Object object) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void warn(String string, Object[] objectArray) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void warn(String string, Object object, Object object2) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void warn(String string, Throwable throwable) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isWarnEnabled(Marker marker) {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isEnabledFor((Priority)Level.WARN)) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isWarnEnabled(marker);
        }

        public void warn(Marker marker, String string) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(marker, string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2);
                    ++n;
                }
            }
        }

        public void warn(Marker marker, String string, Object object) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(marker, string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void warn(Marker marker, String string, Object object, Object object2) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(marker, string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void warn(Marker marker, String string, Object[] objectArray) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(marker, string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void warn(Marker marker, String string, Throwable throwable) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.WARN);
            this.delegate.warn(marker, string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).warn((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isErrorEnabled() {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isEnabledFor((Priority)Level.ERROR)) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isErrorEnabled();
        }

        public void error(String string) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2);
                    ++n;
                }
            }
        }

        public void error(String string, Object object) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void error(String string, Object object, Object object2) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void error(String string, Object[] objectArray) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void error(String string, Throwable throwable) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2, throwable);
                    ++n;
                }
            }
        }

        public boolean isErrorEnabled(Marker marker) {
            if (this.extendedLoggers != null) {
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    if (this.extendedLoggers.get(n).isEnabledFor((Priority)Level.ERROR)) {
                        return true;
                    }
                    ++n;
                }
            }
            return this.delegate.isErrorEnabled(marker);
        }

        public void error(Marker marker, String string) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(marker, string);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2);
                    ++n;
                }
            }
        }

        public void error(Marker marker, String string, Object object) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(marker, string, object);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void error(Marker marker, String string, Object object, Object object2) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(marker, string, object, object2);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)object, (Object)object2);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void error(Marker marker, String string, Object[] objectArray) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(marker, string, objectArray);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                FormattingTuple formattingTuple = MessageFormatter.format((String)string, (Object)objectArray);
                String string2 = this.extendMessage(formattingTuple.getMessage());
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2, formattingTuple.getThrowable());
                    ++n;
                }
            }
        }

        public void error(Marker marker, String string, Throwable throwable) {
            Level level = this.delegateLog4j.getLevel();
            this.delegateLog4j.setLevel(Level.ERROR);
            this.delegate.error(marker, string, throwable);
            this.delegateLog4j.setLevel(level);
            if (this.extendedLoggers != null) {
                String string2 = this.extendMessage(string);
                int n = 0;
                while (n < this.extendedLoggers.size()) {
                    this.extendedLoggers.get(n).error((Object)string2, throwable);
                    ++n;
                }
            }
        }

        protected String extendMessage(String string) {
            return "[" + this.simpleName + "] " + string;
        }
    }

    private static class SimpleAdapter
    extends ALogger {
        private Logger delegate;

        public SimpleAdapter(Logger logger) {
            this.delegate = logger;
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isTraceEnabled() {
            return this.delegate.isTraceEnabled();
        }

        public void trace(String string) {
            this.delegate.trace(string);
        }

        public void trace(String string, Object object) {
            this.delegate.trace(string, object);
        }

        public void trace(String string, Object object, Object object2) {
            this.delegate.trace(string, object, object2);
        }

        public void trace(String string, Object[] objectArray) {
            this.delegate.trace(string, objectArray);
        }

        public void trace(String string, Throwable throwable) {
            this.delegate.trace(string, throwable);
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.delegate.isTraceEnabled(marker);
        }

        public void trace(Marker marker, String string) {
            this.delegate.trace(marker, string);
        }

        public void trace(Marker marker, String string, Object object) {
            this.delegate.trace(marker, string, object);
        }

        public void trace(Marker marker, String string, Object object, Object object2) {
            this.delegate.trace(marker, string, object, object2);
        }

        public void trace(Marker marker, String string, Object[] objectArray) {
            this.delegate.trace(marker, string, objectArray);
        }

        public void trace(Marker marker, String string, Throwable throwable) {
            this.delegate.trace(marker, string, throwable);
        }

        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }

        public void debug(String string) {
            this.delegate.debug(string);
        }

        public void debug(String string, Object object) {
            this.delegate.debug(string, object);
        }

        public void debug(String string, Object object, Object object2) {
            this.delegate.debug(string, object, object2);
        }

        public void debug(String string, Object[] objectArray) {
            this.delegate.debug(string, objectArray);
        }

        public void debug(String string, Throwable throwable) {
            this.delegate.debug(string, throwable);
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.delegate.isDebugEnabled(marker);
        }

        public void debug(Marker marker, String string) {
            this.delegate.debug(marker, string);
        }

        public void debug(Marker marker, String string, Object object) {
            this.delegate.debug(marker, string, object);
        }

        public void debug(Marker marker, String string, Object object, Object object2) {
            this.delegate.debug(marker, string, object, object2);
        }

        public void debug(Marker marker, String string, Object[] objectArray) {
            this.delegate.debug(marker, string, objectArray);
        }

        public void debug(Marker marker, String string, Throwable throwable) {
            this.delegate.debug(marker, string, throwable);
        }

        public boolean isInfoEnabled() {
            return this.delegate.isInfoEnabled();
        }

        public void info(String string) {
            this.delegate.info(string);
        }

        public void info(String string, Object object) {
            this.delegate.info(string, object);
        }

        public void info(String string, Object object, Object object2) {
            this.delegate.info(string, object, object2);
        }

        public void info(String string, Object[] objectArray) {
            this.delegate.info(string, objectArray);
        }

        public void info(String string, Throwable throwable) {
            this.delegate.info(string, throwable);
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.delegate.isInfoEnabled(marker);
        }

        public void info(Marker marker, String string) {
            this.delegate.info(marker, string);
        }

        public void info(Marker marker, String string, Object object) {
            this.delegate.info(marker, string, object);
        }

        public void info(Marker marker, String string, Object object, Object object2) {
            this.delegate.info(marker, string, object, object2);
        }

        public void info(Marker marker, String string, Object[] objectArray) {
            this.delegate.info(marker, string, objectArray);
        }

        public void info(Marker marker, String string, Throwable throwable) {
            this.delegate.info(marker, string, throwable);
        }

        public boolean isWarnEnabled() {
            return this.delegate.isWarnEnabled();
        }

        public void warn(String string) {
            this.delegate.warn(string);
        }

        public void warn(String string, Object object) {
            this.delegate.warn(string, object);
        }

        public void warn(String string, Object[] objectArray) {
            this.delegate.warn(string, objectArray);
        }

        public void warn(String string, Object object, Object object2) {
            this.delegate.warn(string, object, object2);
        }

        public void warn(String string, Throwable throwable) {
            this.delegate.warn(string, throwable);
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.delegate.isWarnEnabled(marker);
        }

        public void warn(Marker marker, String string) {
            this.delegate.warn(marker, string);
        }

        public void warn(Marker marker, String string, Object object) {
            this.delegate.warn(marker, string, object);
        }

        public void warn(Marker marker, String string, Object object, Object object2) {
            this.delegate.warn(marker, string, object, object2);
        }

        public void warn(Marker marker, String string, Object[] objectArray) {
            this.delegate.warn(marker, string, objectArray);
        }

        public void warn(Marker marker, String string, Throwable throwable) {
            this.delegate.warn(marker, string, throwable);
        }

        public boolean isErrorEnabled() {
            return this.delegate.isErrorEnabled();
        }

        public void error(String string) {
            this.delegate.error(string);
        }

        public void error(String string, Object object) {
            this.delegate.error(string, object);
        }

        public void error(String string, Object object, Object object2) {
            this.delegate.error(string, object, object2);
        }

        public void error(String string, Object[] objectArray) {
            this.delegate.error(string, objectArray);
        }

        public void error(String string, Throwable throwable) {
            this.delegate.error(string, throwable);
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.delegate.isErrorEnabled(marker);
        }

        public void error(Marker marker, String string) {
            this.delegate.error(marker, string);
        }

        public void error(Marker marker, String string, Object object) {
            this.delegate.error(marker, string, object);
        }

        public void error(Marker marker, String string, Object object, Object object2) {
            this.delegate.error(marker, string, object, object2);
        }

        public void error(Marker marker, String string, Object[] objectArray) {
            this.delegate.error(marker, string, objectArray);
        }

        public void error(Marker marker, String string, Throwable throwable) {
            this.delegate.error(marker, string, throwable);
        }
    }
}

