/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.web;

import com.agfa.pacs.listtext.swingx.controls.AbstractComponent;
import com.agfa.pacs.logging.ALogger;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;

public class EmbeddedWebsitesView {
    private static final ALogger LOG = ALogger.getLogger(EmbeddedWebsitesView.class);
    private static final String HTTP = "http";
    public static final String HTTP_FULL = "http://";
    protected static final Color ORANGE = new Color(255, 177, 70);
    protected static final Color GRAY_ORANGE = new Color(212, 167, 118);
    protected static final Color DIRTY_ORANGE = new Color(110, 76, 30);
    protected JFXPanel fxPanel;
    private WebView webview;
    private final AbstractComponent parent;

    public EmbeddedWebsitesView(AbstractComponent abstractComponent) {
        this.parent = abstractComponent;
        this.init();
    }

    public void showUrl(String string) {
        if (string != null) {
            if (!StringUtils.startsWithIgnoreCase((String)string, (String)HTTP)) {
                string = HTTP_FULL + string;
            }
            this.parent.removeAll();
            this.parent.add((Component)this.fxPanel, (Object)"Center");
            final String string2 = string;
            Platform.setImplicitExit((boolean)false);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (EmbeddedWebsitesView.this.webview == null) {
                        EmbeddedWebsitesView.this.webview = new WebView();
                        EmbeddedWebsitesView.this.fxPanel.setScene(new Scene((Parent)EmbeddedWebsitesView.this.webview));
                    }
                    LOG.debug("Trying to load URL: " + string2);
                    EmbeddedWebsitesView.this.webview.getEngine().load(string2);
                }
            });
        }
    }

    private void init() {
        this.parent.setBorder((Border)new DashedBorder(ORANGE, GRAY_ORANGE, 15, 4));
        this.parent.setLayout((LayoutManager)new BorderLayout());
        this.fxPanel = new JFXPanel();
        this.fxPanel.setBorder(BorderFactory.createLineBorder(DIRTY_ORANGE, 2));
    }

    private static class DashedBorder
    extends AbstractBorder {
        private int margin;
        private Color color1;
        private Color color2;
        private int length;
        private int thickness;

        public DashedBorder(Color color, Color color2, int n, int n2) {
            this.color1 = color;
            this.color2 = color2;
            this.length = n;
            this.thickness = n2;
            this.margin = n2 * 2 - n2 / 2;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n + this.thickness, n2 + this.thickness, n3 - this.margin, n4 - this.margin, 5.0, 5.0);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.color1);
            graphics2D.setStroke(new BasicStroke(this.thickness, 0, 0, 1.0f, new float[]{this.length, this.length}, 0.0f));
            graphics2D.draw(double_);
            graphics2D.setColor(this.color2);
            graphics2D.setStroke(new BasicStroke(this.thickness, 0, 0, 1.0f, new float[]{this.length, this.length}, this.length));
            graphics2D.draw(double_);
            graphics2D.dispose();
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(this.margin, this.margin, this.margin - this.thickness / 2, this.margin - this.thickness / 2);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = this.margin;
            insets.top = this.margin;
            insets.right = this.margin - this.thickness / 2;
            insets.bottom = this.margin - this.thickness / 2;
            return insets;
        }
    }
}

