/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports.ui;

import com.agfa.pacs.base.swing.busylabel.JXBusyLabel;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.dnd.DataInfoTransferable;
import com.agfa.pacs.data.shared.icon.DefaultIconFactory;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.listtext.cycling.ICycleListProvider;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedWaveform;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.dicomobject.type.CompletionFlag;
import com.agfa.pacs.listtext.dicomobject.type.VerificationFlag;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.ReportType;
import com.agfa.pacs.listtext.lta.reports.ui.IReportView;
import com.agfa.pacs.listtext.lta.reports.ui.IReportsView;
import com.agfa.pacs.listtext.lta.util.DataFinderUtilities;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.listtext.lta.util.imageobject.IImageObjectLoader;
import com.agfa.pacs.listtext.lta.util.imageobject.IImageObjectLoaderListener;
import com.agfa.pacs.listtext.lta.util.imageobject.ImageObjectLoaderProviderFactory;
import com.agfa.pacs.listtext.swingx.controls.IPopupWindowClosingCallback;
import com.agfa.pacs.listtext.swingx.controls.PopupWindow;
import com.agfa.pacs.listtext.swingx.layout.GridLayout2;
import com.agfa.pacs.listtext.swingx.plaf.nimbus.NimbusUtilities;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.UID;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.SAXWriter;
import org.dcm4che3.util.DateUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class EnhancedHTMLStructuredReportView
implements IReportView {
    private static final ALogger logger = ALogger.getLogger(EnhancedHTMLStructuredReportView.class);
    private static final DatePrecision PERFECT_PRECISION = new DatePrecision();
    public static final String SR_VIEW_TYPE = "ENHANCED_HTML";
    public static final ReportType[] SUPPORTED_REPORT_TYPES = new ReportType[]{ReportType.StructuredReport, ReportType.OrbisReport, ReportType.DoseReport};
    private static final String STYLESHEET = "/SRToEnhancedHtml.xslt";
    private static final int IMG_DIM = GUI.getScaledInt((int)128);
    private static final Charset processingCharset = StandardCharsets.UTF_8;
    private IReportsView view;
    private IReport report;
    private boolean reducedView;
    private Collection<String> filteredCodeValues;
    private Map<Integer, List<SRReferencedImage>> refImageMap = new Hashtable<Integer, List<SRReferencedImage>>();
    private Map<Integer, List<ReferencedSOP>> refCompositeMap = new Hashtable<Integer, List<ReferencedSOP>>();
    private Map<Integer, List<ReferencedWaveform>> refWaveformMap = new Hashtable<Integer, List<ReferencedWaveform>>();
    private Cancelable imgLoadingCancelable;
    private ImageObjectLoaderListener imgLoadingListener = new ImageObjectLoaderListener();
    private ResizeListener resizeListener = new ResizeListener();
    private JPanel contentView;
    private JPanel imagesView;
    private JEditorPane htmlView;
    private JLayeredPane imagesLayerPane;
    private JPanel imagesPanel;
    private JXBusyLabel imagesLoadingLabel;
    private JScrollPane htmlPanelScp;
    private JScrollPane imagesPanelScp;
    private static final Object transformerLock = new Object();
    private static volatile Transformer transformer = null;

    public EnhancedHTMLStructuredReportView(IReportsView iReportsView, IReport iReport) {
        this.view = iReportsView;
        this.reducedView = this.isReducedViewEnabled();
        this.filteredCodeValues = this.getReducedViewFilteredCodeValues();
        this.report = iReport;
    }

    public EnhancedHTMLStructuredReportView() {
        this(null, null);
    }

    @Override
    public String getReportViewType() {
        return SR_VIEW_TYPE;
    }

    @Override
    public boolean isReportTypeSupported(ReportType reportType) {
        return EnhancedHTMLStructuredReportView.supportsReport(reportType);
    }

    private synchronized void init() {
        this.createComponents();
        this.installLayout();
        this.init(this.report);
        this.initTransformer(true);
    }

    @Override
    public synchronized Component getAWTRootComponent() {
        if (this.contentView == null) {
            this.init();
        }
        return this.contentView;
    }

    @Override
    public JComponent getPrintComponent() {
        JEditorPane jEditorPane = this.createHtmlView();
        jEditorPane.setSize(this.htmlView.getSize());
        jEditorPane.setForeground(Color.BLACK);
        this.initHtmlView(jEditorPane);
        return jEditorPane;
    }

    @Override
    public IReport getReport() {
        return this.report;
    }

    public static boolean supportsReport(ReportType reportType) {
        return Arrays.asList(SUPPORTED_REPORT_TYPES).contains((Object)reportType);
    }

    @Override
    public void init(IReport iReport) {
        this.refImageMap.clear();
        this.refCompositeMap.clear();
        this.refWaveformMap.clear();
        this.report = iReport;
        this.initComponents();
    }

    private boolean isReducedViewEnabled() {
        try {
            return ConfigurationProviderFactory.getConfig().getBoolean("listtext.lta.textarea.structuredreport.reducedView");
        }
        catch (Exception exception) {
            logger.warn("Reading configuration setting for listtext.lta.textarea.structuredreport.reducedView failed! Use default: true");
            return true;
        }
    }

    private Collection<String> getReducedViewFilteredCodeValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = ConfigurationProviderFactory.getConfig().getText("listtext.lta.textarea.structuredreport.reducedViewFilteredCodeValues");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            NodeList nodeList = document.getElementsByTagName("item");
            int n = 0;
            while (n < nodeList.getLength()) {
                NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
                arrayList2.add(namedNodeMap.getNamedItem("value").getNodeValue());
                ++n;
            }
            arrayList.addAll(arrayList2);
        }
        catch (Exception exception) {
            logger.warn("Reading configuration settings for listtext.lta.textarea.structuredreport.reducedViewFilteredCodeValues failed: No codes are filtered");
        }
        return arrayList;
    }

    protected void createComponents() {
        this.contentView = new JPanel();
        this.imagesView = new JPanel();
        this.imagesPanel = new JPanel();
        this.imagesLoadingLabel = this.createImageLoadingView();
        this.imagesLayerPane = new JLayeredPane();
        this.htmlView = this.createHtmlView();
        this.htmlPanelScp = this.createScrollPane(this.htmlView, 20, 30);
        this.imagesPanelScp = this.createScrollPane(this.imagesPanel, 20, 31);
    }

    protected void initComponents() {
        this.initHtmlView(this.htmlView);
        this.initImagesView(null);
    }

    protected void installLayout() {
        this.imagesPanel.setLayout((LayoutManager)new GridLayout2(1, 0, 10));
        this.imagesPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Dimension dimension = new Dimension(IMG_DIM + 20, IMG_DIM);
        this.imagesLayerPane.setPreferredSize(dimension);
        this.imagesLayerPane.setMaximumSize(dimension);
        this.imagesLayerPane.setLayer(this.imagesPanelScp, 0);
        this.imagesLayerPane.setLayer((Component)this.imagesLoadingLabel, 1);
        this.imagesLayerPane.add(this.imagesPanelScp);
        this.imagesLayerPane.add((Component)this.imagesLoadingLabel);
        this.imagesLayerPane.addComponentListener(this.resizeListener);
        this.imagesView.setLayout(new BorderLayout());
        this.imagesView.add((Component)this.imagesLayerPane, "Center");
        this.contentView.setLayout(new BorderLayout(10, 0));
        this.contentView.add((Component)this.htmlPanelScp, "Center");
        this.contentView.add((Component)this.imagesView, "East");
    }

    protected JEditorPane createHtmlView() {
        HtmlHyperlinkListener htmlHyperlinkListener = new HtmlHyperlinkListener();
        JEditorPane jEditorPane = new JEditorPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        jEditorPane.setName("ReportView");
        jEditorPane.setContentType("text/html");
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        jEditorPane.setEditable(false);
        NimbusUtilities.setNimbusProperty((JComponent)jEditorPane, (String)"EditorPane.background", (Object)new Color(0, 0, 0, 0));
        jEditorPane.setOpaque(false);
        jEditorPane.setBorder(null);
        jEditorPane.addHyperlinkListener(htmlHyperlinkListener);
        return jEditorPane;
    }

    protected JScrollPane createScrollPane(Component component, int n, int n2) {
        return SwingUtilities2.createScrollPane((Component)component, (Integer)n, (Integer)n2, (Boolean)true, (Boolean)false);
    }

    protected JXBusyLabel createImageLoadingView() {
        JXBusyLabel jXBusyLabel = new JXBusyLabel();
        jXBusyLabel.setHorizontalAlignment(0);
        jXBusyLabel.setText(Messages.getString("EnhancedHtmlStructuredReportView.LoadingImages"));
        return jXBusyLabel;
    }

    protected void initHtmlView(JEditorPane jEditorPane) {
        String string = this.report != null ? this.convertSRToHTML(this.report) : null;
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        String string2 = "";
        try {
            Object object;
            if (string != null) {
                string = string.replace("&#13;", "<p>");
                object = new StringBuilder();
                int n = string.indexOf("<DEFAULT>Conclusion</DEFAULT>");
                if (n > 0) {
                    int n2 = string.indexOf("<b>", n);
                    int n3 = string.indexOf("</b>", n2);
                    if (n2 > 0 && n3 > 0) {
                        ((StringBuilder)object).append(string.substring(0, n2));
                        String string3 = string.substring(n2 + 3, n3);
                        string3 = string3.replace(".br", "<br>");
                        if (string3.contains("<p>")) {
                            ((StringBuilder)object).append("<b>");
                            ((StringBuilder)object).append(string3);
                            ((StringBuilder)object).append("</b>");
                        } else {
                            ((StringBuilder)object).append("<pre style=\"font-family:sans-serif;\"><b>");
                            ((StringBuilder)object).append(string3);
                            ((StringBuilder)object).append("</b></pre>");
                        }
                        ((StringBuilder)object).append(string.substring(n3 + 4));
                        string = ((StringBuilder)object).toString();
                    }
                }
                string2 = this.doPostProcessing(string);
            }
            hTMLEditorKit.read(new StringReader(string2), (Document)hTMLDocument, 0);
            jEditorPane.setDocument(hTMLDocument);
            if (this.report.isInvalid()) {
                object = jEditorPane.getFont().getAttributes();
                object.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                jEditorPane.setFont(new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)object));
            }
        }
        catch (Exception exception) {
            logger.error("Parsing html text failed!", (Throwable)exception);
            this.htmlView.setText("");
        }
    }

    protected void initImagesView(List<SRReferencedImage> list) {
        this.imagesPanel.removeAll();
        this.imagesLoadingLabel.setVisible(false);
        if (this.imgLoadingCancelable != null && this.imgLoadingCancelable.isRunning()) {
            this.imgLoadingListener.cancelled = true;
            this.imgLoadingCancelable.cancel();
        }
        if (list == null || list.isEmpty()) {
            this.imagesView.setVisible(false);
        } else {
            Map.Entry<SRReferencedImage, IObjectInfo> entry2;
            Map<SRReferencedImage, IObjectInfo> map = this.findImageObjects(list);
            ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
            for (Map.Entry<SRReferencedImage, IObjectInfo> entry2 : map.entrySet()) {
                if (entry2.getValue() != null) {
                    arrayList.add((IObjectInfo)entry2.getValue());
                    continue;
                }
                Image image = this.getDefaultImage(((SRReferencedImage)entry2.getKey()).getSOPClassUID());
                if (image == null) continue;
                this.imagesPanel.add(new ImagePanel(null, image));
            }
            entry2 = ImageObjectLoaderProviderFactory.getInstance().getImageObjectLoader(arrayList);
            this.imgLoadingCancelable = entry2.getImagesAsync(arrayList, this.loadImageWhenIconUnavailable() ? entry2.getSupportedLoadingPolicies() : entry2.getSupportedIconLoadingPolicies(), new Dimension(IMG_DIM, IMG_DIM), this.imgLoadingListener);
            this.imagesView.setVisible(true);
        }
        this.contentView.revalidate();
        this.contentView.repaint();
    }

    protected void initWaveformView(List<ReferencedWaveform> list) {
        this.imagesPanel.removeAll();
        this.imagesLoadingLabel.setVisible(false);
        if (this.imgLoadingCancelable != null && this.imgLoadingCancelable.isRunning()) {
            this.imgLoadingListener.cancelled = true;
            this.imgLoadingCancelable.cancel();
        }
        if (list == null || list.isEmpty()) {
            this.imagesView.setVisible(false);
        } else {
            Map.Entry<ReferencedWaveform, IObjectInfo> entry2;
            Map<ReferencedWaveform, IObjectInfo> map = this.findWaveformObjects(list);
            ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
            for (Map.Entry<ReferencedWaveform, IObjectInfo> entry2 : map.entrySet()) {
                if (entry2.getValue() != null) {
                    arrayList.add((IObjectInfo)entry2.getValue());
                    continue;
                }
                Image image = this.getDefaultImage(((ReferencedWaveform)entry2.getKey()).getSOPClassUID());
                if (image == null) continue;
                this.imagesPanel.add(new ImagePanel(null, image));
            }
            entry2 = ImageObjectLoaderProviderFactory.getInstance().getImageObjectLoader(arrayList);
            this.imgLoadingCancelable = entry2.getImagesAsync(arrayList, entry2.getSupportedIconLoadingPolicies(), new Dimension(IMG_DIM, IMG_DIM), this.imgLoadingListener);
            this.imagesView.setVisible(true);
        }
        this.contentView.revalidate();
        this.contentView.repaint();
    }

    protected String convertSRToXML(Attributes attributes) {
        try {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
            transformerHandler.getTransformer().setOutputProperty("indent", "yes");
            transformerHandler.getTransformer().setOutputProperty("encoding", processingCharset.name());
            transformerHandler.getTransformer().setOutputProperty("omit-xml-declaration", "no");
            transformerHandler.setResult(new StreamResult(byteArrayOutputStream));
            SAXWriter sAXWriter = new SAXWriter((ContentHandler)transformerHandler);
            sAXWriter.write(attributes);
            return new String(byteArrayOutputStream.toByteArray(), processingCharset);
        }
        catch (Exception exception) {
            logger.error("SR to XML conversion failed!", (Throwable)exception);
            return null;
        }
    }

    private static Transformer createTransformer(boolean bl, String string) {
        try {
            InputStream inputStream = EnhancedHTMLStructuredReportView.class.getResourceAsStream(STYLESHEET);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(inputStream));
            transformer.setParameter("FILTERED_CODE_VALUES", string);
            transformer.setParameter("LANGUAGE", Locale.getDefault().getLanguage());
            return transformer;
        }
        catch (Exception exception) {
            logger.error("Could not initiate transformer", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTransformer(boolean bl) {
        if (transformer != null) {
            return;
        }
        if (bl) {
            new Thread("Init Transformer"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = transformerLock;
                    synchronized (object) {
                        if (transformer == null) {
                            EnhancedHTMLStructuredReportView.transformer = EnhancedHTMLStructuredReportView.createTransformer(EnhancedHTMLStructuredReportView.this.reducedView, EnhancedHTMLStructuredReportView.this.getFilteredCodeValuesAsString(EnhancedHTMLStructuredReportView.this.filteredCodeValues));
                        }
                    }
                }
            }.start();
        } else {
            Object object = transformerLock;
            synchronized (object) {
                if (transformer == null) {
                    transformer = EnhancedHTMLStructuredReportView.createTransformer(this.reducedView, this.getFilteredCodeValuesAsString(this.filteredCodeValues));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertSRToHTML(IReport iReport) {
        try {
            String string = this.convertSRToXML(iReport.getReportObject());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.initTransformer(false);
            Transformer transformer = EnhancedHTMLStructuredReportView.transformer;
            synchronized (transformer) {
                string = string.replaceAll("&#12;", "");
                string = string.replaceAll("&#13;(\r\n)?", "\r\n");
                string = string.replaceAll("&#", "");
                EnhancedHTMLStructuredReportView.transformer.setParameter("REDUCED_VIEW_PROCESSING", Boolean.toString(this.reducedView && !ReportType.DoseReport.equals((Object)this.report.getType())));
                EnhancedHTMLStructuredReportView.transformer.setParameter("ORBIS_REPORT", Boolean.toString(ReportType.OrbisReport.equals((Object)iReport.getType())));
                EnhancedHTMLStructuredReportView.transformer.transform(new StreamSource(new StringReader(string)), new StreamResult(byteArrayOutputStream));
            }
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            logger.error("SR to HTML conversion failed!", (Throwable)exception);
            return Messages.getString("EnhancedHtmlStructuredReportView.ParseReportError");
        }
    }

    protected String doPostProcessing(String string) {
        String string2 = string;
        string2 = string2.replaceFirst("<html(.)*>", "<html>");
        string2 = string2.replaceFirst("<META(.)*>", "");
        string2 = this.doOrbisReportHistoryPostProcessing(string2);
        string2 = this.doPhysiciansReadingStudyPostProcessing(string2);
        string2 = this.doLocalizationPostProcessing(string2);
        string2 = this.doDatePostProcessing(string2);
        string2 = this.doTimePostProcessing(string2);
        string2 = this.doDateTimePostProcessing(string2);
        string2 = this.doNamePostProcessing(string2);
        string2 = this.doCompositePostProcessing(string2);
        string2 = this.doWaveformPostProcessing(string2);
        string2 = this.doImagePostProcessing(string2);
        return string2;
    }

    protected String doLocalizationPostProcessing(String string) {
        String string2 = string;
        string2 = string2.replaceAll("PAT_NAME", Messages.getString("EnhancedHtmlStructuredReportView.PatientName"));
        string2 = string2.replaceAll("PHYSICIAN_NAME_READING_STUDY", Messages.getString("EnhancedHtmlStructuredReportView.PhysicianNameReadingStudy"));
        string2 = string2.replaceAll("REASON_FOR_THE_REQ_PROC", DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(4198402));
        string2 = string2.replaceAll("PAT_ID", Messages.getString("EnhancedHtmlStructuredReportView.PatientId"));
        string2 = string2.replaceAll("PAT_BIRTHDATE", Messages.getString("EnhancedHtmlStructuredReportView.PatientBirthdate"));
        string2 = string2.replaceAll("PAT_SEX", Messages.getString("EnhancedHtmlStructuredReportView.PatientSex"));
        string2 = string2.replaceAll("REPORT_DATE", this.report.getType().equals((Object)ReportType.DoseReport) ? Messages.getString("EnhancedHtmlStructuredReportView.ProtocolDate") : Messages.getString("EnhancedHtmlStructuredReportView.ReportDate"));
        string2 = string2.replaceAll("REPORT_STATUS", Messages.getString("EnhancedHtmlStructuredReportView.ReportStatus"));
        string2 = string2.replaceAll(CompletionFlag.Complete.dicom(), IReport.CompletionState.COMPLETE.toString());
        string2 = string2.replaceAll(CompletionFlag.Partial.dicom(), IReport.CompletionState.PARTIAL.toString());
        string2 = string2.replaceAll(VerificationFlag.Verified.dicom(), IReport.VerificationState.VERIFIED.toString());
        string2 = string2.replaceAll(VerificationFlag.Unverified.dicom(), IReport.VerificationState.UNVERIFIED.toString());
        string2 = this.doCodeTranslationPostProcessing(string2);
        return string2;
    }

    protected String doDatePostProcessing(String string) {
        Pattern pattern = Pattern.compile("<DATE>.*?</DATE>", 32);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2 == null) continue;
            try {
                String string3 = matcher.group().substring(6, string2.length() - 7);
                Date date = DateUtils.parseDA(null, (String)string3, (boolean)false);
                matcher.appendReplacement(stringBuffer, dateFormat.format(date));
            }
            catch (Exception exception) {
                logger.warn("Parsing dicom date failed. Skipping conversion!");
                stringBuffer.append(string2);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected String doTimePostProcessing(String string) {
        Pattern pattern = Pattern.compile("<TIME>.*?</TIME>", 32);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        DateFormat dateFormat = DateFormat.getTimeInstance(1);
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2 == null) continue;
            try {
                String string3 = matcher.group().substring(6, string2.length() - 7);
                Date date = DateUtils.parseTM(null, (String)string3, (boolean)false, (DatePrecision)PERFECT_PRECISION);
                matcher.appendReplacement(stringBuffer, dateFormat.format(date));
            }
            catch (Exception exception) {
                logger.warn("Parsing dicom time failed. Skipping conversion!", (Throwable)exception);
                stringBuffer.append(string2);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected String doDateTimePostProcessing(String string) {
        Pattern pattern = Pattern.compile("<DATETIME>.*?</DATETIME>", 32);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3);
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2 == null) continue;
            try {
                Date date;
                String string3 = matcher.group().substring(10, string2.length() - 11).trim();
                if (string3.isEmpty() || (date = DateUtils.parseDT(null, (String)string3, (boolean)false, (DatePrecision)PERFECT_PRECISION)) == null) continue;
                matcher.appendReplacement(stringBuffer, dateFormat.format(date));
            }
            catch (Exception exception) {
                logger.warn("Parsing dicom datetime failed. Skipping conversion!", (Throwable)exception);
                stringBuffer.append(string2);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected String doNamePostProcessing(String string) {
        Pattern pattern = Pattern.compile("<PNAME>.*?</PNAME>", 32);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2 == null) continue;
            try {
                String string3 = matcher.group().substring(7, string2.length() - 8);
                if (string3.length() == 0) continue;
                PersonName personName = new PersonName(string3, true);
                matcher.appendReplacement(stringBuffer, PersonNameUtilities.personNameToHRReverse((PersonName)personName));
            }
            catch (Exception exception) {
                logger.warn("Parsing person name failed. Skipping conversion!", (Throwable)exception);
                stringBuffer.append(string2);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected String doCodeTranslationPostProcessing(String string) {
        Pattern pattern = Pattern.compile("<TRANSLATE-CODE>.*?</TRANSLATE-CODE>", 32);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2 == null) continue;
            try {
                String string3 = string2.substring(string2.indexOf("<VALUE>") + 7, string2.indexOf("</VALUE>"));
                Code code = CodeDictionary.DefaultSRContent.getCodeForValue((String)string3);
                if (code != null) {
                    matcher.appendReplacement(stringBuffer, code.getLocalizedCodeMeaning());
                    continue;
                }
                String string4 = string2.substring(string2.indexOf("<DEFAULT>") + 9, string2.indexOf("</DEFAULT>"));
                matcher.appendReplacement(stringBuffer, string4);
            }
            catch (Exception exception) {
                logger.warn("Parsing code-translation failed. Skipping conversion!", (Throwable)exception);
                stringBuffer.append(string2);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected String doOrbisReportHistoryPostProcessing(String string) {
        if (string != null && string.contains("ORBIS_REPORT_HISTORY")) {
            StringBuilder stringBuilder = new StringBuilder();
            ISeriesInfo iSeriesInfo = (ISeriesInfo)this.report.getReportInfo().getTreeParent();
            if (iSeriesInfo != null) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
                boolean bl = true;
                for (IReport iReport : this.view.getReports()) {
                    ISeriesInfo iSeriesInfo2;
                    IObjectInfo iObjectInfo = iReport.getReportInfo();
                    ISeriesInfo iSeriesInfo3 = iSeriesInfo2 = iObjectInfo != null ? (ISeriesInfo)iObjectInfo.getTreeParent() : null;
                    if (iSeriesInfo2 == null || !iSeriesInfo.equalsKey((IDataInfo)iSeriesInfo2)) continue;
                    stringBuilder.append("<tr><td>");
                    if (bl) {
                        stringBuilder.append("REPORT_DATE");
                        bl = false;
                    }
                    stringBuilder.append("</td><td>");
                    stringBuilder.append("<b>");
                    Date date = iReport.getCreationDateTime();
                    if (date != null) {
                        stringBuilder.append(dateFormat.format(date));
                    }
                    stringBuilder.append("</b>");
                    if (iSeriesInfo2.children().size() > 1) {
                        stringBuilder.append(" (");
                        stringBuilder.append(iReport.getTitle());
                        stringBuilder.append(")");
                    }
                    stringBuilder.append("</td></tr>");
                }
            }
            return string.replaceFirst("ORBIS_REPORT_HISTORY", stringBuilder.toString());
        }
        return string;
    }

    protected String doPhysiciansReadingStudyPostProcessing(String string) {
        if (string != null && string.contains("PHYSICIAN_NAMES_READING_STUDY")) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            IObjectInfo iObjectInfo = this.report.getReportInfo();
            if (iObjectInfo.getAttributes().containsValue(528480) && (stringArray = iObjectInfo.getAttributes().getStrings(528480)) != null && stringArray.length > 0) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    stringBuilder.append("<tr><td>");
                    if (bl) {
                        stringBuilder.append("PHYSICIAN_NAME_READING_STUDY");
                        bl = false;
                    }
                    stringBuilder.append("</td><td>");
                    stringBuilder.append("<b>");
                    stringBuilder.append(PersonNameUtilities.personNameToHRReverse((PersonName)new PersonName(string2, true)));
                    stringBuilder.append("</b>");
                    stringBuilder.append("</td></tr>");
                    ++n2;
                }
            }
            return string.replaceFirst("PHYSICIAN_NAMES_READING_STUDY", stringBuilder.toString());
        }
        return string;
    }

    protected String doCompositePostProcessing(String string) {
        Pattern pattern = Pattern.compile("<COMPOSITE>.*?</COMPOSITE>", 32);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2 == null) continue;
            try {
                String string3 = string2.substring(string2.indexOf("<SOP_CLASS_UID>") + 15, string2.indexOf("</SOP_CLASS_UID"));
                String string4 = string2.substring(string2.indexOf("<SOP_INSTANCE_UID>") + 18, string2.indexOf("</SOP_INSTANCE_UID>"));
                ArrayList<ReferencedSOP> arrayList = new ArrayList<ReferencedSOP>();
                ReferencedSOP referencedSOP = new ReferencedSOP(string3, string4);
                arrayList.add(referencedSOP);
                int n = ThreadLocalRandom.current().nextInt();
                this.refCompositeMap.put(n, arrayList);
                IReport iReport = this.findLinkedReport(string3, string4);
                String string5 = iReport != null ? CompositeLink.getAsHtmlLink(n) : this.getCompositeReferenceText(string3, string4);
                matcher.appendReplacement(stringBuffer, string5);
            }
            catch (Exception exception) {
                logger.warn("Parsing COMPOSITE object reference failed. Skipping conversion!", (Throwable)exception);
                stringBuffer.append(string2);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected String doWaveformPostProcessing(String string) {
        Pattern pattern = Pattern.compile("<WAVEFORM>.*?</WAVEFORM>", 32);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (string2 == null) continue;
            try {
                String string3 = string2.substring(string2.indexOf("<SOP_CLASS_UID>") + 15, string2.indexOf("</SOP_CLASS_UID"));
                String string4 = string2.substring(string2.indexOf("<SOP_INSTANCE_UID>18"), string2.indexOf("</SOP_INSTANCE_UID>"));
                String[] stringArray = string2.substring(string2.indexOf("<CHANNELS>10"), string2.indexOf("</CHANNELS>")).split(",");
                int[] nArray = new int[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    nArray[n] = Integer.parseInt(stringArray[n]);
                    ++n;
                }
                ReferencedWaveform referencedWaveform = new ReferencedWaveform(string3, string4, nArray);
                ArrayList<ReferencedWaveform> arrayList = new ArrayList<ReferencedWaveform>();
                arrayList.add(referencedWaveform);
                int n2 = ThreadLocalRandom.current().nextInt();
                this.refWaveformMap.put(n2, arrayList);
                String string5 = this.isWaveformLinkSupported(string3) ? WaveformLink.getAsHtmlLink(n2) : this.getWaveformReferenceText(string3, string4, stringArray);
                matcher.appendReplacement(stringBuffer, string5);
            }
            catch (Exception exception) {
                logger.warn("Parsing WAVEFORM object reference failed. Skipping conversion!", (Throwable)exception);
                stringBuffer.append(string2);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected String doImagePostProcessing(String string) {
        Pattern pattern = Pattern.compile("(<IMAGE>.*?</IMAGE>)+", 32);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            ArrayList<SRReferencedImage> arrayList = new ArrayList<SRReferencedImage>();
            String string2 = matcher.group();
            Pattern pattern2 = Pattern.compile("(<IMAGE>.*?</IMAGE>)", 32);
            Matcher matcher2 = pattern2.matcher(string2);
            while (matcher2.find()) {
                String string3 = matcher2.group();
                try {
                    String string4 = string3.substring(string3.indexOf("<SOP_CLASS_UID>") + 15, string3.indexOf("</SOP_CLASS_UID"));
                    String string5 = string3.substring(string3.indexOf("<SOP_INSTANCE_UID>") + 18, string3.indexOf("</SOP_INSTANCE_UID>"));
                    String[] stringArray = string3.substring(string3.indexOf("<FRAME_NUMBERS>") + 15, string3.indexOf("</FRAME_NUMBERS>")).split(",");
                    String string6 = string3.substring(string3.indexOf("<PS_SOP_CLASS_UID>") + 18, string3.indexOf("</PS_SOP_CLASS_UID>"));
                    String string7 = string3.substring(string3.indexOf("<PS_SOP_INSTANCE_UID>") + 21, string3.indexOf("</PS_SOP_INSTANCE_UID>"));
                    Attributes attributes = new Attributes();
                    attributes.setString(528720, VR.UI, string4);
                    attributes.setString(528725, VR.UI, string5);
                    try {
                        attributes.setString(4235574, VR.US, stringArray);
                    }
                    catch (Exception exception) {}
                    if (string6 != null && string6.length() > 0 && string7 != null && string7.length() > 0) {
                        ReferencedSOP referencedSOP = new ReferencedSOP(string6, string7);
                        attributes.newSequence(528793, 1).add(referencedSOP.toDataset());
                    }
                    arrayList.add(SRReferencedImage.create((Attributes)attributes));
                }
                catch (Exception exception) {
                    logger.warn("Parsing IMAGE object references failed. Skipping conversion!", (Throwable)exception);
                    stringBuffer.append(string3);
                }
            }
            int n = ThreadLocalRandom.current().nextInt();
            this.refImageMap.put(n, arrayList);
            matcher.appendReplacement(stringBuffer, ImageLink.getAsHtmlLink(n));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String getCompositeReferenceText(String string, String string2) {
        String string3 = String.valueOf(UID.nameOf((String)string)) + " ";
        string3 = String.valueOf(string3) + Messages.getString("EnhancedHtmlStructuredReportView.ObjectReference");
        string3 = String.valueOf(string3) + "(" + string2 + ")";
        return string3;
    }

    private String getWaveformReferenceText(String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(UID.nameOf((String)string)).append(' ');
        stringBuilder.append(Messages.getString("EnhancedHtmlStructuredReportView.ObjectReference"));
        stringBuilder.append('(').append(string2).append(')');
        if (stringArray != null && stringArray.length > 0) {
            stringBuilder.append(Messages.getString("EnhancedHtmlStructuredReportView.WaveformChannels")).append(": ");
            stringBuilder.append(stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                stringBuilder.append(',').append(stringArray[n]);
                ++n;
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private IReport findLinkedReport(String string, String string2) {
        if (this.view != null && string2 != null) {
            for (IReport iReport : this.view.getReports()) {
                IObjectInfo iObjectInfo = iReport.getReportInfo();
                if (!string2.equals(iObjectInfo.getSOPInstanceUID())) continue;
                return iReport;
            }
        }
        return null;
    }

    private boolean isWaveformLinkSupported(String string) {
        return "1.2.840.10008.5.1.4.1.1.9.1.1".equals(string) || "1.2.840.10008.5.1.4.1.1.9.1.3".equals(string) || "1.2.840.10008.5.1.4.1.1.9.4.1".equals(string) || "1.2.840.10008.5.1.4.1.1.9.1.2".equals(string) || "1.2.840.10008.5.1.4.1.1.9.2.1".equals(string);
    }

    private Map<SRReferencedImage, IObjectInfo> findImageObjects(List<SRReferencedImage> list) {
        Object object2;
        SRReferencedImage sRReferencedImage2;
        Hashtable hashtable = new Hashtable();
        Hashtable<String, SRReferencedImage> hashtable2 = new Hashtable<String, SRReferencedImage>(list.size());
        for (SRReferencedImage sRReferencedImage2 : list) {
            String string = sRReferencedImage2.getSOPInstanceUID();
            hashtable2.put(string, sRReferencedImage2);
            object2 = this.findSource(sRReferencedImage2.getSOPClassUID(), sRReferencedImage2.getSOPInstanceUID());
            if (object2 != null) {
                if (!hashtable.containsKey(object2)) {
                    hashtable.put(object2, new ArrayList());
                }
                ((List)hashtable.get(object2)).add(string);
                continue;
            }
            logger.error("Finding DataInfoSource for referenced object failed!");
        }
        sRReferencedImage2 = new HashMap();
        for (Map.Entry entry : hashtable.entrySet()) {
            object2 = DataFinderUtilities.findObjects((IDataInfoSource)((IDataInfoSource)entry.getKey()), (Collection)((Collection)entry.getValue()));
            for (Map.Entry entry2 : hashtable2.entrySet()) {
                String string = (String)entry2.getKey();
                SRReferencedImage sRReferencedImage3 = (SRReferencedImage)entry2.getValue();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    IObjectInfo iObjectInfo = (IObjectInfo)iterator.next();
                    if (!string.equals(iObjectInfo.getSOPInstanceUID())) continue;
                    sRReferencedImage2.put(sRReferencedImage3, iObjectInfo);
                    break;
                }
                if (sRReferencedImage2.containsKey(sRReferencedImage3) && sRReferencedImage2.get(sRReferencedImage3) != null) continue;
                sRReferencedImage2.put(sRReferencedImage3, null);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : hashtable2.entrySet()) {
            SRReferencedImage sRReferencedImage4 = (SRReferencedImage)entry.getValue();
            if (!sRReferencedImage2.containsKey(sRReferencedImage4)) {
                sRReferencedImage2.put(sRReferencedImage4, null);
            }
            if (sRReferencedImage2.get(sRReferencedImage4) != null) continue;
            arrayList.add(sRReferencedImage4.getSOPInstanceUID());
        }
        if (!arrayList.isEmpty() && this.queryAllArchivesWhenSourceUnavailable()) {
            List list2 = DataFinderUtilities.findObjects((Collection)Base.getDataInfoNodes(), arrayList);
            for (Object object2 : list2) {
                SRReferencedImage sRReferencedImage5 = (SRReferencedImage)hashtable2.get(object2.getSOPInstanceUID());
                sRReferencedImage2.put(sRReferencedImage5, object2);
            }
        }
        return sRReferencedImage2;
    }

    private Map<ReferencedWaveform, IObjectInfo> findWaveformObjects(List<ReferencedWaveform> list) {
        Object object2;
        ReferencedWaveform referencedWaveform2;
        Hashtable hashtable = new Hashtable();
        Hashtable<String, ReferencedWaveform> hashtable2 = new Hashtable<String, ReferencedWaveform>(list.size());
        for (ReferencedWaveform referencedWaveform2 : list) {
            String string = referencedWaveform2.getSOPInstanceUID();
            hashtable2.put(string, referencedWaveform2);
            object2 = this.findSource(referencedWaveform2.getSOPClassUID(), referencedWaveform2.getSOPInstanceUID());
            if (object2 != null) {
                if (!hashtable.containsKey(object2)) {
                    hashtable.put(object2, new ArrayList());
                }
                ((List)hashtable.get(object2)).add(string);
                continue;
            }
            logger.error("Finding DataInfoSource for referenced object failed!");
        }
        referencedWaveform2 = new HashMap();
        for (Map.Entry entry : hashtable.entrySet()) {
            object2 = DataFinderUtilities.findObjects((IDataInfoSource)((IDataInfoSource)entry.getKey()), (Collection)((Collection)entry.getValue()));
            for (Map.Entry entry2 : hashtable2.entrySet()) {
                String string = (String)entry2.getKey();
                ReferencedWaveform referencedWaveform3 = (ReferencedWaveform)entry2.getValue();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    IObjectInfo iObjectInfo = (IObjectInfo)iterator.next();
                    if (!string.equals(iObjectInfo.getSOPInstanceUID())) continue;
                    referencedWaveform2.put(referencedWaveform3, iObjectInfo);
                    break;
                }
                if (referencedWaveform2.containsKey(referencedWaveform3) && referencedWaveform2.get(referencedWaveform3) != null) continue;
                referencedWaveform2.put(referencedWaveform3, null);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : hashtable2.entrySet()) {
            ReferencedWaveform referencedWaveform4 = (ReferencedWaveform)entry.getValue();
            if (!referencedWaveform2.containsKey(referencedWaveform4)) {
                referencedWaveform2.put(referencedWaveform4, null);
            }
            if (referencedWaveform2.get(referencedWaveform4) != null) continue;
            arrayList.add(referencedWaveform4.getSOPInstanceUID());
        }
        if (!arrayList.isEmpty() && this.queryAllArchivesWhenSourceUnavailable()) {
            List list2 = DataFinderUtilities.findObjects((Collection)Base.getDataInfoNodes(), arrayList);
            for (Object object2 : list2) {
                ReferencedWaveform referencedWaveform5 = (ReferencedWaveform)hashtable2.get(object2.getSOPInstanceUID());
                referencedWaveform2.put(referencedWaveform5, object2);
            }
        }
        return referencedWaveform2;
    }

    private IDataInfoSource findSource(String string, String string2) {
        if (this.report != null) {
            SOPInstanceReference sOPInstanceReference2;
            Attributes attributes = this.report.getReportObject();
            List list = SOPInstanceReference.createList((Attributes)attributes, (int)4236149);
            for (SOPInstanceReference sOPInstanceReference2 : list) {
                if (!this.report.getReportInfo().getStudyUID().equals(sOPInstanceReference2.getStudyInstanceUID())) continue;
                for (ReferencedSeries referencedSeries : sOPInstanceReference2.referencedSeries()) {
                    String[] stringArray = referencedSeries.getRetrieveAETs();
                    if (stringArray == null || stringArray.length <= 0) continue;
                    for (ReferencedSOP referencedSOP : referencedSeries.referencedSOP()) {
                        if (!referencedSOP.getSOPInstanceUID().equals(string2)) continue;
                        String[] stringArray2 = stringArray;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string3 = stringArray2[n2];
                            IDataInfoNode iDataInfoNode = Base.getConfiguredDataInfoNodeByAET((String)string3);
                            if (iDataInfoNode != null) {
                                return iDataInfoNode;
                            }
                            ++n2;
                        }
                    }
                }
            }
            if (this.view != null && (sOPInstanceReference2 = this.view.getAssociatedStudy()) != null) {
                return sOPInstanceReference2.getSource();
            }
            return this.report.getReportInfo().getSource();
        }
        return null;
    }

    private boolean loadImageWhenIconUnavailable() {
        try {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("listtext.lta.textarea.structuredreport");
            return iConfigurationProvider.getBoolean("loadInstanceWhenIconUnavailable");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean queryAllArchivesWhenSourceUnavailable() {
        try {
            IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("listtext.lta.textarea.structuredreport");
            return iConfigurationProvider.getBoolean("queryAllArchivesWhenSourceUnavailable");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Image getDefaultImage(String string) {
        try {
            return DefaultIconFactory.getInstance().getDefaultIcon(string).getImage();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getFilteredCodeValuesAsString(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            stringBuilder.append("<value");
            stringBuilder.append(string);
            stringBuilder.append("</value>");
        }
        return stringBuilder.toString();
    }

    @Override
    public void postInit() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EnhancedHTMLStructuredReportView.this.htmlView.revalidate();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnhancedHTMLStructuredReportView.this.htmlView.scrollRectToVisible(new Rectangle(0, ((EnhancedHTMLStructuredReportView)(this).EnhancedHTMLStructuredReportView.this).htmlView.getBounds().height, 1, 1));
                    }
                });
            }
        });
    }

    private static class CompositeLink {
        private static String ID = "#COMPOSITE_";

        private CompositeLink() {
        }

        public static String getAsHtmlLink(int n) {
            String string = "<a href=\"";
            string = String.valueOf(string) + ID + Integer.toString(n);
            string = String.valueOf(string) + "\">";
            string = String.valueOf(string) + Messages.getString("EnhancedHtmlStructuredReportView.CompositeLink");
            string = String.valueOf(string) + "</a>";
            return string;
        }

        public static boolean isCompositeLink(Object object) {
            if (object != null) {
                return object.toString().contains(ID);
            }
            return false;
        }

        public static Integer getLinkId(Object object) {
            try {
                String string = null;
                if (object instanceof String) {
                    string = object.toString();
                } else if (object instanceof URL) {
                    string = ((URL)object).getRef();
                }
                if (string != null) {
                    String[] stringArray = string.split("_");
                    return Integer.parseInt(stringArray[1]);
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    private class HtmlHyperlinkListener
    implements HyperlinkListener {
        private HtmlHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        Object object = hyperlinkEvent.getURL();
                        if (object == null) {
                            object = hyperlinkEvent.getDescription();
                        }
                        if (CompositeLink.isCompositeLink(object)) {
                            ReferencedSOP referencedSOP;
                            IReport iReport;
                            List list = (List)EnhancedHTMLStructuredReportView.this.refCompositeMap.get(CompositeLink.getLinkId(object));
                            if (!list.isEmpty() && (iReport = EnhancedHTMLStructuredReportView.this.findLinkedReport((referencedSOP = (ReferencedSOP)list.get(0)).getSOPClassUID(), referencedSOP.getSOPInstanceUID())) != null) {
                                EnhancedHTMLStructuredReportView.this.view.selectReport(iReport);
                            }
                        } else if (WaveformLink.isWaveformLink(object)) {
                            EnhancedHTMLStructuredReportView.this.initWaveformView((List)EnhancedHTMLStructuredReportView.this.refWaveformMap.get(WaveformLink.getLinkId(object)));
                        } else if (ImageLink.isImageLink(object)) {
                            EnhancedHTMLStructuredReportView.this.initImagesView((List)EnhancedHTMLStructuredReportView.this.refImageMap.get(ImageLink.getLinkId(object)));
                        }
                    }
                    catch (Throwable throwable) {
                        logger.error("Hyperlink handler error!", throwable);
                    }
                }
            }
        }
    }

    protected static class ImageLink {
        private static String ID = "IMAGE";

        protected ImageLink() {
        }

        public static String getAsHtmlLink(int n) {
            String string = "<a href=\"";
            string = String.valueOf(string) + "#" + ID + "_" + Integer.toString(n);
            string = String.valueOf(string) + "\">";
            string = String.valueOf(string) + Messages.getString("EnhancedHtmlStructuredReportView.ImageLink");
            string = String.valueOf(string) + "</a>";
            return string;
        }

        public static boolean isImageLink(Object object) {
            if (object != null) {
                return object.toString().contains(ID);
            }
            return false;
        }

        public static Integer getLinkId(Object object) {
            try {
                String string = null;
                if (object instanceof String) {
                    string = object.toString();
                } else if (object instanceof URL) {
                    string = ((URL)object).getRef();
                }
                if (string != null) {
                    String[] stringArray = string.split("_");
                    return Integer.parseInt(stringArray[1]);
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    private class ImageObjectLoaderListener
    implements IImageObjectLoaderListener {
        public boolean cancelled = false;

        private ImageObjectLoaderListener() {
        }

        @Override
        public void loadingStarted(IImageObjectLoader iImageObjectLoader) {
            this.cancelled = false;
            EnhancedHTMLStructuredReportView.this.imagesPanelScp.setVisible(false);
            EnhancedHTMLStructuredReportView.this.imagesLoadingLabel.setVisible(true);
            EnhancedHTMLStructuredReportView.this.imagesLoadingLabel.setBusy(true);
            EnhancedHTMLStructuredReportView.this.imagesView.revalidate();
            EnhancedHTMLStructuredReportView.this.imagesView.repaint();
        }

        @Override
        public void loadingFinished(IImageObjectLoader iImageObjectLoader, Map<IObjectInfo, List<Image>> map) {
            EnhancedHTMLStructuredReportView.this.imagesLoadingLabel.setBusy(false);
            if (!this.cancelled) {
                for (Map.Entry<IObjectInfo, List<Image>> entry : map.entrySet()) {
                    IObjectInfo iObjectInfo = entry.getKey();
                    List<Image> list = entry.getValue();
                    if (list == null || list.isEmpty()) {
                        ImagePanel imagePanel = new ImagePanel(iObjectInfo, EnhancedHTMLStructuredReportView.this.getDefaultImage(iObjectInfo.getSOPClassUID()));
                        EnhancedHTMLStructuredReportView.this.imagesPanel.add(imagePanel);
                        continue;
                    }
                    for (Image image : list) {
                        ImagePanel imagePanel = new ImagePanel(iObjectInfo, image);
                        EnhancedHTMLStructuredReportView.this.imagesPanel.add(imagePanel);
                    }
                }
                EnhancedHTMLStructuredReportView.this.imagesLoadingLabel.setVisible(false);
                EnhancedHTMLStructuredReportView.this.imagesPanelScp.setVisible(true);
                EnhancedHTMLStructuredReportView.this.imagesView.revalidate();
                EnhancedHTMLStructuredReportView.this.imagesView.repaint();
            }
        }
    }

    private class ImagePanel
    extends JPanel
    implements DragGestureListener,
    DragSourceListener {
        private static final long serialVersionUID = -6780002258869611774L;
        private IObjectInfo objectInfo;
        private Image image = null;

        public ImagePanel(IObjectInfo iObjectInfo, Image image) {
            this.objectInfo = iObjectInfo;
            this.image = image;
            if (iObjectInfo != null) {
                DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 1, this);
                final IObjectInfo iObjectInfo2 = iObjectInfo;
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        JButton jButton = SwingUtilities2.createButton((Icon)UIManager.getIcon("load.eye"));
                        jButton.setBackground(UIManager.getColor("color.primary.3"));
                        jButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                ICycleListProvider iCycleListProvider = CycleListProviderFactory.getInstance().getCycleListProvider();
                                if (iCycleListProvider != null) {
                                    try {
                                        iCycleListProvider.addToCycleListAndDisplay(DataInfoUtilities.intoList((IDataInfo)iObjectInfo2), false);
                                    }
                                    catch (Exception exception) {
                                        logger.error("Opening image failed!", (Throwable)exception);
                                    }
                                }
                            }
                        });
                        PopupWindow popupWindow = new PopupWindow(SwingUtilities.windowForComponent(EnhancedHTMLStructuredReportView.this.view.getVisibleComponent()), 250, new IPopupWindowClosingCallback(){

                            public boolean closeWindow(PopupWindow popupWindow) {
                                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                                Point point = pointerInfo.getLocation();
                                if (point != null) {
                                    SwingUtilities.convertPointFromScreen(point, ImagePanel.this);
                                    return !ImagePanel.this.contains(pointerInfo.getLocation());
                                }
                                return true;
                            }
                        });
                        popupWindow.getContentPane().add(jButton);
                        popupWindow.show((Component)ImagePanel.this, 1, 1);
                    }
                });
            }
            if (image != null) {
                this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
            }
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.image != null) {
                graphics.drawImage(this.image, this.getInsets().left, this.getInsets().top, null);
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            try {
                switch (dragGestureEvent.getDragAction()) {
                    case 2: {
                        dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, (Transferable)new DataInfoTransferable((IDataInfo)this.objectInfo), this);
                        break;
                    }
                    case 1: {
                        dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, (Transferable)new DataInfoTransferable((IDataInfo)this.objectInfo), this);
                    }
                }
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                logger.error("Initiating drag and drop operation failed!", (Throwable)invalidDnDOperationException);
            }
            catch (NullPointerException nullPointerException) {
                logger.error("Transferable is null!", (Throwable)nullPointerException);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = componentEvent.getComponent().getSize();
            EnhancedHTMLStructuredReportView.this.imagesPanelScp.setSize(dimension);
            EnhancedHTMLStructuredReportView.this.imagesLoadingLabel.setSize(dimension);
        }
    }

    private static class WaveformLink {
        private static String ID = "#WAVEFORM_";

        private WaveformLink() {
        }

        public static String getAsHtmlLink(int n) {
            String string = "<a href=\"";
            string = String.valueOf(string) + ID + Integer.toString(n);
            string = String.valueOf(string) + "\">";
            string = String.valueOf(string) + Messages.getString("EnhancedHtmlStructuredReportView.WaveformLink");
            string = String.valueOf(string) + "</a>";
            return string;
        }

        public static boolean isWaveformLink(Object object) {
            if (object != null) {
                return object.toString().contains(ID);
            }
            return false;
        }

        public static Integer getLinkId(Object object) {
            try {
                String string = null;
                if (object instanceof String) {
                    string = object.toString();
                } else if (object instanceof URL) {
                    string = ((URL)object).getRef();
                }
                if (string != null) {
                    String[] stringArray = string.split("_");
                    return Integer.parseInt(stringArray[1]);
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }
}

