/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports.ui;

import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.ReportType;
import com.agfa.pacs.listtext.lta.reports.ui.IReportView;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class CDAReportView
extends JPanel
implements IReportView {
    private static final ALogger log = ALogger.getLogger(CDAReportView.class);
    public static final String CDA_VIEW_TYPE = "CDA";
    public static final ReportType[] SUPPORTED_CDA_REPORT_TYPES = new ReportType[]{ReportType.CDAReport};
    private IReport report;
    private WebView webview;

    public CDAReportView(IReport iReport) {
        this.setName("ReportView");
        this.init(iReport);
    }

    public CDAReportView() {
        this((IReport)null);
    }

    @Override
    public IReport getReport() {
        return this.report;
    }

    @Override
    public String getReportViewType() {
        return CDA_VIEW_TYPE;
    }

    @Override
    public boolean isReportTypeSupported(ReportType reportType) {
        return CDAReportView.supportsReport(reportType);
    }

    public static boolean supportsReport(ReportType reportType) {
        return Arrays.asList(SUPPORTED_CDA_REPORT_TYPES).contains((Object)reportType);
    }

    @Override
    public Component getAWTRootComponent() {
        return this;
    }

    @Override
    public JComponent getPrintComponent() {
        return null;
    }

    @Override
    public void init(IReport iReport) {
        this.report = iReport;
        if (iReport != null) {
            final String string = this.convertSRToHTML(iReport);
            if (string != null) {
                final JFXPanel jFXPanel = new JFXPanel();
                this.setPreferredSize(new Dimension(1024, 800));
                this.setLayout(new BorderLayout());
                this.add((Component)jFXPanel, "Center");
                Platform.setImplicitExit((boolean)false);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (CDAReportView.this.webview == null) {
                            CDAReportView.this.webview = new WebView();
                            jFXPanel.setScene(new Scene((Parent)CDAReportView.this.webview));
                        }
                        if (string != null) {
                            CDAReportView.this.webview.getEngine().loadContent(string);
                        }
                    }
                });
            }
        } else {
            this.removeAll();
        }
    }

    @Override
    public void postInit() {
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
    }

    private String convertSRToHTML(IReport iReport) {
        try {
            byte[] byArray = iReport.getReportObject().getBytes(4325393);
            InputStream inputStream = this.getClass().getResourceAsStream("/CDAToHtml.xsl");
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(inputStream));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            transformer.transform(new StreamSource(new ByteArrayInputStream(byArray)), new StreamResult(byteArrayOutputStream));
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            log.error("CDA report to HTML conversion failed!", (Throwable)exception);
            return null;
        }
    }
}

