/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports;

import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.ReportType;
import com.agfa.pacs.tools.CompareUtils;
import java.util.Comparator;
import java.util.Date;

public class ReportComparatorFactory {
    private static final ReportComparatorFactory INSTANCE = new ReportComparatorFactory();

    private ReportComparatorFactory() {
    }

    public static ReportComparatorFactory getInstance() {
        return INSTANCE;
    }

    public Comparator<IReport> createReportComparator() {
        return new DefaultComparator();
    }

    private static abstract class AbstractComparator
    implements Comparator<IReport> {
        private AbstractComparator() {
        }

        @Override
        public int compare(IReport iReport, IReport iReport2) {
            boolean bl = this.isRadiologyReport(iReport);
            boolean bl2 = this.isRadiologyReport(iReport2);
            if (!bl && bl2) {
                return 1;
            }
            if (bl && !bl2) {
                return -1;
            }
            return 0;
        }

        private boolean isRadiologyReport(IReport iReport) {
            ReportType reportType = iReport.getType();
            return ReportType.OrbisReport.equals((Object)reportType) || ReportType.CDAReport.equals((Object)reportType) || ReportType.PDFReport.equals((Object)reportType) || ReportType.StructuredReport.equals((Object)reportType);
        }
    }

    private static class DefaultComparator
    extends AbstractComparator {
        private DefaultComparator() {
        }

        @Override
        public int compare(IReport iReport, IReport iReport2) {
            Date date;
            if (iReport == iReport2) {
                return 0;
            }
            int n = super.compare(iReport, iReport2);
            if (n != 0) {
                return n;
            }
            Date date2 = iReport.getCreationDateTime();
            int n2 = -CompareUtils.compareAdvanced((Comparable)date2, (Comparable)(date = iReport2.getCreationDateTime()));
            if (n2 == 0) {
                IReport.VerificationState verificationState = iReport.getVerificationState();
                IReport.VerificationState verificationState2 = iReport2.getVerificationState();
                return -CompareUtils.compareAdvanced((Comparable)((Object)verificationState), (Comparable)((Object)verificationState2));
            }
            return n2;
        }
    }
}

