/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.inputverifier;

import com.agfa.pacs.listtext.lta.inputverifier.IDateInputVerifier;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.dcm4che3.util.DateUtils;

public class DateInputVerifier
extends InputVerifier
implements IDateInputVerifier {
    private static DateFormat shortFormat = DateFormat.getDateInstance(3);
    private static DateFormat quickFormat = new SimpleDateFormat("yyyyMMdd");

    @Override
    public String dateToFormatString(Date date) {
        if (date == null) {
            return null;
        }
        return shortFormat.format(date);
    }

    @Override
    public String dateToDicomString(Date date) {
        return DateUtils.formatDA(null, (Date)date);
    }

    @Override
    public String dicomStringToFormatString(String string) throws ParseException {
        return this.dateToFormatString(this.dicomStringToDate(string));
    }

    @Override
    public Date dicomStringToDate(String string) throws ParseException {
        return DateUtils.parseDA(null, (String)string, (boolean)false);
    }

    @Override
    public Date formatStringToDate(String string) throws ParseException {
        return shortFormat.parse(string);
    }

    @Override
    public boolean verify(JComponent jComponent) {
        String string = ((JTextField)jComponent).getText();
        try {
            Date date = this.formatStringToDate(string);
            this.dateToDicomString(date);
            return true;
        }
        catch (ParseException parseException) {
            try {
                Date date = quickFormat.parse(string);
                ((JTextField)jComponent).setText(this.dateToFormatString(date));
                return true;
            }
            catch (ParseException parseException2) {
                return false;
            }
        }
    }
}

