/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.worklists;

import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklist;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistBundle;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistItem;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistItemWalker;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistProvider;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistProviderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class NormalizedWorklistUtils {
    public static void initializeWorklists() {
        Collection<INormalizedWorklistProvider> collection;
        NormalizedWorklistProviderFactory normalizedWorklistProviderFactory = NormalizedWorklistProviderFactory.get();
        Collection<INormalizedWorklistProvider> collection2 = normalizedWorklistProviderFactory.getProviders(INormalizedWorklistProvider.ImplementationType.LEGACY);
        if (collection2 != null && !collection2.isEmpty()) {
            collection2.iterator().next().initialize();
        }
        if ((collection = normalizedWorklistProviderFactory.getProviders(INormalizedWorklistProvider.ImplementationType.UWL)) != null && !collection.isEmpty()) {
            collection.iterator().next().initialize();
        }
    }

    public static boolean isOfImplementationType(INormalizedWorklistProvider iNormalizedWorklistProvider, INormalizedWorklistProvider.ImplementationType implementationType) {
        return iNormalizedWorklistProvider != null && implementationType.equals((Object)iNormalizedWorklistProvider.getImplementationType());
    }

    public static boolean isOfImplementationType(INormalizedWorklistBundle iNormalizedWorklistBundle, INormalizedWorklistProvider.ImplementationType implementationType) {
        return iNormalizedWorklistBundle != null && NormalizedWorklistUtils.isOfImplementationType(iNormalizedWorklistBundle.getProvider(), implementationType);
    }

    public static boolean isOfImplementationType(INormalizedWorklist iNormalizedWorklist, INormalizedWorklistProvider.ImplementationType implementationType) {
        return iNormalizedWorklist != null && NormalizedWorklistUtils.isOfImplementationType(iNormalizedWorklist.getBundle(), implementationType);
    }

    public static boolean isOfType(INormalizedWorklist iNormalizedWorklist, String string) {
        return iNormalizedWorklist != null ? NormalizedWorklistUtils.isOfType(iNormalizedWorklist.getBundle(), string) : false;
    }

    public static boolean isOfType(INormalizedWorklistBundle iNormalizedWorklistBundle, String string) {
        return iNormalizedWorklistBundle != null ? NormalizedWorklistUtils.isOfType(iNormalizedWorklistBundle.getProvider(), string) : false;
    }

    public static boolean isOfType(INormalizedWorklistProvider iNormalizedWorklistProvider, String string) {
        return iNormalizedWorklistProvider != null ? string.equalsIgnoreCase(iNormalizedWorklistProvider.getType().getID()) : false;
    }

    public static boolean isOfScheduledType(INormalizedWorklistProvider iNormalizedWorklistProvider) {
        return iNormalizedWorklistProvider != null && iNormalizedWorklistProvider.getType().isScheduleType();
    }

    public static boolean isOfScheduledType(INormalizedWorklistBundle iNormalizedWorklistBundle) {
        return iNormalizedWorklistBundle != null && NormalizedWorklistUtils.isOfScheduledType(iNormalizedWorklistBundle.getProvider());
    }

    public static boolean isOfScheduledType(INormalizedWorklist iNormalizedWorklist) {
        return iNormalizedWorklist != null && NormalizedWorklistUtils.isOfScheduledType(iNormalizedWorklist.getBundle());
    }

    public static INormalizedWorklistItem findItem(INormalizedWorklist iNormalizedWorklist, String string) {
        INormalizedWorklistItemWalker iNormalizedWorklistItemWalker = iNormalizedWorklist.createItemWalker();
        if (iNormalizedWorklistItemWalker != null) {
            while (iNormalizedWorklistItemWalker.hasNextItem()) {
                INormalizedWorklistItem iNormalizedWorklistItem = iNormalizedWorklistItemWalker.getNextItem();
                if (iNormalizedWorklistItem == null || !iNormalizedWorklistItem.getID().equals(string)) continue;
                return iNormalizedWorklistItem;
            }
        }
        return null;
    }

    public static List<IDataInfo> toDataInfos(List<? extends INormalizedWorklistItem> list) {
        if (list != null) {
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
            for (INormalizedWorklistItem iNormalizedWorklistItem : list) {
                List<? extends IDataInfo> list2 = iNormalizedWorklistItem.getDataInfos();
                if (list2 == null) continue;
                arrayList.addAll(list2);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

