/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.worklists;

import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistProvider;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistProviderFactory;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

class NormalizedWorklistProviderFactoryEclipseImpl
extends NormalizedWorklistProviderFactory {
    private static final ALogger log = ALogger.getLogger(NormalizedWorklistProviderFactoryEclipseImpl.class);
    private final List<INormalizedWorklistProvider> providers = new ArrayList<INormalizedWorklistProvider>();
    private final Map<String, INormalizedWorklistProvider> typesToProviders = new HashMap<String, INormalizedWorklistProvider>();

    public NormalizedWorklistProviderFactoryEclipseImpl() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.listtext.lta.base.NormalizedWorklistProvider");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
                log.warn("No worklist provider implementations found!");
            } else {
                try {
                    IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                        INormalizedWorklistProvider iNormalizedWorklistProvider = (INormalizedWorklistProvider)iConfigurationElement.createExecutableExtension("class");
                        this.typesToProviders.put(iNormalizedWorklistProvider.getType().getID(), iNormalizedWorklistProvider);
                        this.providers.add(iNormalizedWorklistProvider);
                        Collections.sort(this.providers, NormalizedWorklistProviderComparator.get());
                        ++n4;
                    }
                }
                catch (CoreException coreException) {
                    log.error("Factory exception", (Throwable)coreException);
                }
            }
            ++n2;
        }
    }

    @Override
    protected Collection<String> getProviderTypesImpl() {
        ArrayList<String> arrayList = new ArrayList<String>(this.providers.size());
        for (INormalizedWorklistProvider iNormalizedWorklistProvider : this.providers) {
            arrayList.add(iNormalizedWorklistProvider.getType().getID());
        }
        return arrayList;
    }

    @Override
    protected Collection<String> getProviderTypesImpl(INormalizedWorklistProvider.ImplementationType implementationType) {
        ArrayList<String> arrayList = new ArrayList<String>(this.providers.size());
        for (INormalizedWorklistProvider iNormalizedWorklistProvider : this.providers) {
            if (!implementationType.equals((Object)iNormalizedWorklistProvider.getImplementationType())) continue;
            arrayList.add(iNormalizedWorklistProvider.getType().getID());
        }
        return arrayList;
    }

    @Override
    protected INormalizedWorklistProvider getProviderImpl(String string) {
        return this.typesToProviders.get(string);
    }

    @Override
    protected Collection<INormalizedWorklistProvider> getProvidersImpl() {
        return Collections.unmodifiableList(this.providers);
    }

    @Override
    protected Collection<INormalizedWorklistProvider> getProvidersImpl(INormalizedWorklistProvider.ImplementationType implementationType) {
        ArrayList<INormalizedWorklistProvider> arrayList = new ArrayList<INormalizedWorklistProvider>(this.providers.size());
        for (INormalizedWorklistProvider iNormalizedWorklistProvider : this.providers) {
            if (!implementationType.equals((Object)iNormalizedWorklistProvider.getImplementationType())) continue;
            arrayList.add(iNormalizedWorklistProvider);
        }
        return arrayList;
    }

    private static class NormalizedWorklistProviderComparator
    implements Comparator<INormalizedWorklistProvider> {
        private static NormalizedWorklistProviderComparator instance;

        private NormalizedWorklistProviderComparator() {
        }

        public static synchronized NormalizedWorklistProviderComparator get() {
            if (instance == null) {
                instance = new NormalizedWorklistProviderComparator();
            }
            return instance;
        }

        @Override
        public int compare(INormalizedWorklistProvider iNormalizedWorklistProvider, INormalizedWorklistProvider iNormalizedWorklistProvider2) {
            int n = Integer.compare(iNormalizedWorklistProvider.getPriority(), iNormalizedWorklistProvider2.getPriority());
            return n == 0 ? -1 : n;
        }
    }
}

