/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.tagdictionary;

import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.dcm4che3.data.VR;

public enum DataTypeForVR {
    STRING(new VR[]{VR.AE, VR.AS, VR.OB, VR.CS, VR.LO, VR.LT, VR.OW, VR.PN, VR.SH, VR.ST, VR.UI, VR.UN, VR.UT}),
    INTEGER(new VR[]{VR.IS, VR.SL, VR.SS, VR.UL, VR.US}),
    FLOAT(new VR[]{VR.DS, VR.FL, VR.FD, VR.OF}),
    DATE(new VR[]{VR.DA}),
    TIME(new VR[]{VR.TM}),
    DATETIME(new VR[]{VR.DT});

    private VR[] valueRepresentations;
    private static HashMap<VR, DataTypeForVR> mapVR2DataType;
    private static ALogger log;

    static {
        log = ALogger.getLogger(DataTypeForVR.class);
        mapVR2DataType = new HashMap();
        mapVR2DataType.put(VR.SQ, STRING);
        DataTypeForVR[] dataTypeForVRArray = DataTypeForVR.values();
        int n = dataTypeForVRArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataTypeForVR dataTypeForVR = dataTypeForVRArray[n2];
            VR[] vRArray = dataTypeForVR.valueRepresentations;
            int n3 = dataTypeForVR.valueRepresentations.length;
            int n4 = 0;
            while (n4 < n3) {
                VR vR = vRArray[n4];
                if (mapVR2DataType.containsKey(vR)) {
                    throw new IllegalArgumentException("Each value representation can only be associated with one data type! VR: " + vR);
                }
                mapVR2DataType.put(vR, dataTypeForVR);
                ++n4;
            }
            ++n2;
        }
    }

    private DataTypeForVR(VR[] vRArray) {
        this.valueRepresentations = vRArray;
    }

    public static final DataTypeForVR getDataType(VR vR) {
        return mapVR2DataType.get(vR);
    }

    public static final DataTypeForVR getDataType(String string) {
        try {
            Field field = VR.class.getField(string);
            Object object = field.get(null);
            if (object instanceof VR) {
                return DataTypeForVR.getDataType((VR)object);
            }
        }
        catch (Exception exception) {
            log.warn("Cannot find VR object for: " + string);
        }
        return null;
    }
}

