/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.xml;

import com.agfa.pacs.listtext.lta.base.connect.xml.XmlException;
import com.agfa.pacs.logging.ALogger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtilities {
    private static final ALogger LOGGER = ALogger.getLogger(XmlUtilities.class);
    private static final Pattern LINEBREAK_PATTERN = Pattern.compile("\\n|\\r");

    private XmlUtilities() {
    }

    public static Node createDocumentRoot(InputStream inputStream) throws XmlException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new XmlException(exception);
        }
    }

    public static String findNodeValue(Node node, String string) {
        Node node2 = XmlUtilities.findNode(node, string);
        if (node2 != null) {
            return XmlUtilities.getNodeValue(node2);
        }
        return null;
    }

    private static Node findNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(string)) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    public static List<Node> findAllNodes(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (string.equalsIgnoreCase(node2.getNodeName())) {
                arrayList.add(node2);
            }
            ++n;
        }
        return arrayList;
    }

    public static String getNodeValue(Node node) {
        return XmlUtilities.removeLineBreaks(node.getTextContent());
    }

    private static String removeLineBreaks(String string) {
        return LINEBREAK_PATTERN.matcher(string).replaceAll("");
    }

    public static String getAttribute(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap;
        if (node != null && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static Integer getIntegerAttribute(Node node, String string) {
        String string2 = XmlUtilities.getAttribute(node, string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                LOGGER.warn("Parsing XML integer value failed: " + string2, (Throwable)exception);
            }
        }
        return null;
    }
}

