/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.IPermissionTask;
import com.agfa.pacs.listtext.lta.base.connect.IStudyShareData;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareConfig;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareParameter;
import com.agfa.pacs.listtext.lta.base.connect.exception.StudyShareException;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractPermissionTask;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractStudyShareTask;
import com.agfa.pacs.listtext.lta.base.connect.xml.XmlUtilities;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

class PermissionRevokeTask
extends AbstractPermissionTask {
    private static final String ACTION_NAME = "eaDelete";
    private static final String DELETED_NODE_NAME = "deleted";
    private final IPermissionTask query;

    PermissionRevokeTask(IPermissionTask iPermissionTask) {
        super(null, false, iPermissionTask.getSessionCookie());
        this.query = iPermissionTask;
    }

    public String getInfo() {
        return Messages.getString("StudyShare.PermissionRevokeTask.Name");
    }

    @Override
    Map<StudyShareParameter, String> getRequestParameters() {
        EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
        enumMap.put(StudyShareParameter.USER_ID, StudyShareConfig.getUserId());
        enumMap.put(StudyShareParameter.ACTION, ACTION_NAME);
        enumMap.put(StudyShareParameter.IDS, this.query.getResult().getInternalIDs());
        return enumMap;
    }

    @Override
    boolean readResponse(HttpURLConnection httpURLConnection) throws IOException, StudyShareException {
        Node node = XmlUtilities.createDocumentRoot(httpURLConnection.getInputStream());
        String string = node.getNodeName().equalsIgnoreCase("error") ? XmlUtilities.getNodeValue(node) : XmlUtilities.findNodeValue(node, "error");
        if (string != null) {
            this.log.error("Failed to revoke study share permissions: " + string);
            return false;
        }
        String string2 = this.query.getResult().getInternalIDs();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(StringUtils.split((String)string2, (char)',')));
        if (node.getNodeName().equals(DELETED_NODE_NAME)) {
            String[] stringArray;
            String string3 = XmlUtilities.getNodeValue(node);
            if (string3 == null) {
                string3 = XmlUtilities.findNodeValue(node, DELETED_NODE_NAME);
            }
            String[] stringArray2 = stringArray = StringUtils.split((String)string3, (char)',');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string4 = stringArray2[n2];
                if (!arrayList.contains(string4)) {
                    throw new StudyShareException("Revoked study permission for a non recorded study");
                }
                arrayList.remove(string4);
                ++n2;
            }
            if (arrayList.size() != 0) {
                throw new StudyShareException("Not all studies of the study share have been removed");
            }
        } else {
            throw new StudyShareException("Unknown response while revoking study permissions");
        }
        this.setResult(IStudyShareData.NONE);
        return true;
    }

    @Override
    AbstractStudyShareTask.RetrySettings getRetrySettings() {
        return AbstractStudyShareTask.RetrySettings.DEFAULT;
    }

    @Override
    public List<? extends IStudyInfo> getStudies() {
        return this.query.getStudies();
    }
}

