/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareConfig;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareParameter;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractStudyPermissionTask;
import com.agfa.pacs.listtext.lta.base.connect.task.AbstractStudyShareTask;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

class PermissionCreationTask
extends AbstractStudyPermissionTask {
    private static final String NAME = Messages.getString("StudyShare.PermissionCreationTask.Name");
    private static final String ACTION_NAME = "eaCreate";

    PermissionCreationTask(List<IStudyInfo> list, IStudySharePermissionOptions iStudySharePermissionOptions) {
        super(list, iStudySharePermissionOptions, false);
    }

    public String getInfo() {
        return NAME;
    }

    @Override
    Map<StudyShareParameter, String> getRequestParameters() {
        EnumMap<StudyShareParameter, String> enumMap = new EnumMap<StudyShareParameter, String>(StudyShareParameter.class);
        enumMap.put(StudyShareParameter.EXPIRATION_DATE, Long.toString(this.getRoundedUpExpirationDate()));
        enumMap.put(StudyShareParameter.PATIENT_BIRTHDATE, this.getPatientBirthDate());
        enumMap.put(StudyShareParameter.USER_ID, StudyShareConfig.getUserId());
        enumMap.put(StudyShareParameter.ACTION, ACTION_NAME);
        enumMap.put(StudyShareParameter.PERMISSION, Integer.toString(this.options.getPermission().getCode()));
        enumMap.put(StudyShareParameter.STUDY_UIDS, this.getStudyUIDs());
        return enumMap;
    }

    @Override
    AbstractStudyShareTask.RetrySettings getRetrySettings() {
        return new AbstractStudyShareTask.RetrySettings(9, 15000L, true);
    }
}

