/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePDFOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareConfig;
import com.agfa.pacs.listtext.lta.util.BasicImportConfig;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class StudySharePDFOptions
extends JPanel
implements IStudySharePDFOptions {
    private final JTextField institutionNameField;
    private final JComboBox<String> institutionNameChooser;
    private final JTextField departmentNameField;
    private final JCheckBox includeQRCode;

    StudySharePDFOptions(IComponentFactory iComponentFactory) {
        Collection collection = BasicImportConfig.getConfiguredInstitutionNames();
        if (collection == null || collection.size() <= 1) {
            this.institutionNameField = iComponentFactory.createTextField();
            this.institutionNameChooser = null;
            if (collection != null && !collection.isEmpty()) {
                this.institutionNameField.setText((String)collection.iterator().next());
            }
        } else {
            this.institutionNameField = null;
            this.institutionNameChooser = new JComboBox<String>(collection.toArray(new String[collection.size()]));
            iComponentFactory.scaleFont(this.institutionNameChooser);
        }
        this.departmentNameField = iComponentFactory.createTextField();
        this.departmentNameField.setText(StudyShareConfig.getDefaultDepartmentName());
        this.includeQRCode = iComponentFactory.createCheckBox(Messages.getString("StudySharePDFOptions.IncludeQRCode"));
        this.includeQRCode.setSelected(StudyShareConfig.isQRCodeEnabledByDefault());
        this.init(iComponentFactory);
    }

    @Override
    public String getInstitutionName() {
        if (this.institutionNameField != null) {
            return this.institutionNameField.getText();
        }
        if (this.institutionNameChooser != null) {
            return this.institutionNameChooser.getItemAt(this.institutionNameChooser.getSelectedIndex());
        }
        return "";
    }

    @Override
    public String getDepartmentName() {
        return this.departmentNameField.getText();
    }

    @Override
    public boolean isQRCodeEnabled() {
        return this.includeQRCode.isSelected();
    }

    private void init(IComponentFactory iComponentFactory) {
        int n = iComponentFactory.scaleInt(10);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-2.0, -2.0, n, -2.0});
        tableLayout.setHGap(n);
        this.setLayout((LayoutManager)tableLayout);
        this.add((Component)new JLabel(String.valueOf(Messages.getString("StudySharePDFOptions.InstitutionName")) + ':'), "0,0");
        this.add(this.institutionNameField == null ? this.institutionNameChooser : this.institutionNameField, "1,0");
        this.add((Component)new JLabel(String.valueOf(Messages.getString("StudySharePDFOptions.DepartmentName")) + ':'), "0,1");
        this.add((Component)this.departmentNameField, "1,1");
        this.add((Component)this.includeQRCode, "0,3,1,3");
    }
}

