/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect;

import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.AbstractStudyShareAction;
import com.agfa.pacs.listtext.lta.base.connect.IPermissionTask;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareConfig;
import com.agfa.pacs.listtext.lta.base.connect.StudySharePDFOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.task.PDFCreationTask;
import com.agfa.pacs.listtext.lta.base.connect.task.PermissionTaskFactory;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.listtext.lta.util.job.JobControl;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class StudyShareCreationAction
extends AbstractStudyShareAction {
    public static final String NAME = Messages.getString("StudyShareCreationAction.Name");
    private static final String DESCRIPTION = Messages.getString("StudyShareCreationAction.Description");
    private static final ALogger LOGGER = ALogger.getLogger(StudyShareCreationAction.class);

    public StudyShareCreationAction(IComponentFactory iComponentFactory) {
        super(iComponentFactory);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    void performImpl(Component component, List<IStudyInfo> list) {
        StudySharePDFOptions studySharePDFOptions;
        StudySharePermissionOptions studySharePermissionOptions = this.createPermissionOptions(StudyShareConfig.getDefaultSettings(), true);
        int n = this.componentFactory.showOKCancelDialog(DESCRIPTION, (JComponent)this.createDialog(list, studySharePermissionOptions, studySharePDFOptions = this.createPDFOptions()), component, true);
        if (n == 0) {
            JobControl jobControl = new JobControl(DESCRIPTION, JobControl.createDetailedInformation((String)DESCRIPTION, list));
            ProgressStateModel progressStateModel = jobControl.getModel();
            ProgressManagerFactory.getManager().addProgressState(progressStateModel);
            try {
                if (StudyShareConfig.getUseSeparateArchive()) {
                    jobControl.addTask(PermissionTaskFactory.createCMoveTask(StudyShareConfig.getDestinationAET(), list));
                }
                IPermissionTask iPermissionTask = PermissionTaskFactory.createPermissionCreationTask(list, studySharePermissionOptions);
                jobControl.addTask((IBackgroundTask)iPermissionTask);
                PDFCreationTask pDFCreationTask = new PDFCreationTask(iPermissionTask, studySharePermissionOptions, studySharePDFOptions, list);
                jobControl.addTask((IBackgroundTask)pDFCreationTask);
                progressStateModel.addPropertyChangeListener((PropertyChangeListener)new JobTerminationListener(component, progressStateModel, pDFCreationTask));
                new Thread((Runnable)jobControl, "CreateShareStudies").start();
            }
            catch (Exception exception) {
                LOGGER.error("Sharing studies failed.", (Throwable)exception);
                progressStateModel.setState(JobState.FAILED);
            }
        }
    }

    void askUserToOpenPDF(final Component component, final File file) {
        EventUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(Messages.getString("StudyShareCreationAction.PDF.Message"));
                stringBuilder.append('\n');
                if (StudyShareConfig.isPrintEnabled()) {
                    stringBuilder.append(Messages.getString("StudyShareCreationAction.PDF.Query.Print"));
                } else {
                    stringBuilder.append(Messages.getString("StudyShareCreationAction.PDF.Query.Open"));
                }
                boolean bl = StudyShareCreationAction.this.componentFactory.showYesNoDialog(Messages.getString("StudyShareCreationAction.PDF.Title"), stringBuilder.toString(), component);
                if (bl) {
                    LOGGER.debug("Opening/printing PDF with Internet study share settings ...");
                    StudyShareCreationAction.this.showAndPrintPDF(file, component, StudyShareConfig.isPrintEnabled());
                } else if (StudyShareConfig.isPrintEnabled()) {
                    LOGGER.debug("User declined to print PDF with Internet study share settings, Opening PDF.");
                    StudyShareCreationAction.this.showAndPrintPDF(file, component, false);
                } else {
                    LOGGER.debug("User declined to open PDF with Internet study share settings.");
                }
            }
        });
    }

    void informUserOfFailure(Component component, String string) {
        String string2 = string == null || string.trim().length() == 0 ? Messages.getString("StudyShareCreationAction.Failure.Message") : string;
        LOGGER.error("Internet study share failed: " + string2);
        this.showErrorDialog(Messages.getString("StudyShareCreationAction.Failure.Title"), string2, component);
    }

    private class JobTerminationListener
    implements PropertyChangeListener {
        private final Component parent;
        private final ProgressStateModel model;
        private final PDFCreationTask pdf;

        JobTerminationListener(Component component, ProgressStateModel progressStateModel, PDFCreationTask pDFCreationTask) {
            this.parent = component;
            this.model = progressStateModel;
            this.pdf = pDFCreationTask;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("PROGRESS_STATE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                JobState jobState = (JobState)propertyChangeEvent.getNewValue();
                if (jobState.isDone()) {
                    this.model.removePropertyChangeListener((PropertyChangeListener)this);
                }
                switch (jobState) {
                    case CANCELLED: {
                        LOGGER.debug("Internet study shared cancelled by user.");
                        break;
                    }
                    case FINISHED: 
                    case RETIRED: {
                        StudyShareCreationAction.this.askUserToOpenPDF(this.parent, this.pdf.getPDF());
                        break;
                    }
                    case FAILED: {
                        String string = this.model.getProgressMessage();
                        if (string == null || string.endsWith("...")) {
                            string = this.model.getDetailMessage();
                        }
                        StudyShareCreationAction.this.informUserOfFailure(this.parent, string);
                        break;
                    }
                }
            }
        }
    }
}

