/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.PersonName;

class StudiesListTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{DicomTagDictionaryFactory.getLocaleDictionary().getNameForTagWithPrefix(524320), DicomTagDictionaryFactory.getLocaleDictionary().getNameForTagWithPrefix(528432), DicomTagDictionaryFactory.getLocaleDictionary().getNameForTagWithPrefix(524384)};
    private static final int STUDY_DATE_COLUMN = 0;
    private static final int STUDY_DESCRIPTION_COLUMN = 1;
    private static final int MODALITY_COLUMN = 2;
    private final String patientName;
    private final List<Entry> content;

    StudiesListTableModel(List<IStudyInfo> list) {
        this.patientName = PersonNameUtilities.personNameToHRReverseShort((PersonName)new PersonName(list.get(0).getPatient().getString(0x100010), true));
        this.content = new ArrayList<Entry>(list.size());
        this.init(list);
    }

    private void init(List<IStudyInfo> list) {
        this.content.clear();
        int n = 0;
        for (IStudyInfo iStudyInfo : list) {
            this.content.add(new Entry(iStudyInfo, ++n));
        }
        Collections.sort(this.content);
    }

    public String getPatientName() {
        return this.patientName;
    }

    @Override
    public int getRowCount() {
        return this.content.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Entry entry = this.content.get(n);
        switch (n2) {
            case 0: {
                if (entry.studyDate == null) break;
                return DateTimeUtils.dateTime2String((Date)entry.studyDate);
            }
            case 1: {
                return entry.studyDescription;
            }
            case 2: {
                return entry.modalities;
            }
        }
        return null;
    }

    private static class Entry
    implements Comparable<Entry> {
        final Date studyDate;
        final String studyDescription;
        final String modalities;
        private final int index;

        public Entry(IStudyInfo iStudyInfo, int n) {
            this.studyDate = iStudyInfo.getAttributes().getDate(2251937253163056L);
            this.studyDescription = iStudyInfo.getString(528432);
            this.modalities = DicomUtils.getModalitiesInStudiesAsString((Attributes)iStudyInfo.getAttributes(), (boolean)true, (boolean)true);
            this.index = n;
        }

        @Override
        public int compareTo(Entry entry) {
            int n = CompareUtils.compareAdvanced((Comparable)this.studyDate, (Comparable)entry.studyDate);
            if (n == 0) {
                n = this.index - entry.index;
            }
            return n;
        }
    }
}

