/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.about;

import com.agfa.pacs.base.lic.ILicense;
import com.agfa.pacs.base.lic.LicenseManager;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.listtext.config.Vendor;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.about.AbstractAboutModel;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class AboutModel
extends AbstractAboutModel {
    private String productTitle = Product.getProductName();
    private String productVersion = Product.getLongVersionString();
    private List<BundleDescription> bundles = null;
    private Image vendorImage = Vendor.getVendorImage();
    private Image ceImage = this.getCeImageImpl();
    private Date lastReleaseDate = null;
    private Date firstReleaseDate = Product.getFirstReleaseDate();

    public AboutModel() {
        this.lastReleaseDate = Product.getLastReleaseDate();
        this.bundles = this.createBundleList();
    }

    private Image getCeImageImpl() {
        String string = null;
        if (Product.isReleasedVersion()) {
            if (Product.isCDViewer()) {
                string = "/icons/ce_mark_classI.svg";
            } else {
                if (Product.isPasta()) {
                    return null;
                }
                string = "/icons/CE_0413.svg";
            }
        }
        if (string != null) {
            PIconFactory pIconFactory = PIconFactory.createdFixedSizeIconFactory((boolean)false, (int[])new int[]{40});
            return pIconFactory.loadIcon(this.getClass(), string).getImage();
        }
        return null;
    }

    public Image getCEImage() {
        return this.ceImage;
    }

    public String getProductTitle() {
        return this.productTitle;
    }

    public List<BundleDescription> getInstalledBundles() {
        return this.bundles;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public Date getProductFirstReleaseDate() {
        return this.firstReleaseDate;
    }

    public Date getProductLastReleaseDate() {
        return this.lastReleaseDate;
    }

    public Image getVendorImage() {
        return this.vendorImage;
    }

    public String getLicenseInformation() {
        ILicense iLicense = LicenseManager.getInstance().getLicense(ILicense.MAIN_PRODUCT_LICENSE_ID);
        if (iLicense == null) {
            return Messages.getString("Unlicensed");
        }
        String string = String.valueOf(iLicense.getCustomer().getName()) + " \n" + iLicense.getCustomer().getLocation() + " \n" + iLicense.getCustomer().getCountry();
        return string;
    }

    private List<BundleDescription> createBundleList() {
        BundleDescription[] bundleDescriptionArray = Platform.getPlatformAdmin().getState().getBundles();
        if (bundleDescriptionArray == null) {
            return new ArrayList<BundleDescription>(0);
        }
        return Arrays.asList(bundleDescriptionArray);
    }
}

