/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base;

import com.agfa.pacs.listtext.lta.base.WeakListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class WeakListenerSupport<T> {
    private List<WeakListener<T>> weakListeners;
    private List<T> listeners;

    public List<T> getAllListeners() {
        ArrayList<T> arrayList = null;
        if (this.listeners != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<T>(3);
            }
            arrayList.addAll(this.listeners);
        }
        if (this.weakListeners != null) {
            if (arrayList == null) {
                arrayList = new ArrayList(this.weakListeners.size());
            }
            Iterator<WeakListener<T>> iterator = this.weakListeners.iterator();
            while (iterator.hasNext()) {
                WeakListener<T> weakListener = iterator.next();
                if (!weakListener.isValid()) {
                    iterator.remove();
                    continue;
                }
                arrayList.add(weakListener.get());
            }
        }
        if (arrayList != null) {
            return arrayList;
        }
        return Collections.emptyList();
    }

    public boolean addListener(T t) {
        return this.addListener(t, false);
    }

    public synchronized boolean addListener(T t, boolean bl) {
        if (bl) {
            if (this.weakListeners == null) {
                this.weakListeners = new ArrayList<WeakListener<T>>(5);
            }
            if (this.find(t) == null) {
                this.weakListeners.add(new WeakListener<T>(t));
                return true;
            }
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayList<T>(5);
            }
            if (!this.listeners.contains(t)) {
                this.listeners.add(t);
                return true;
            }
        }
        return false;
    }

    public synchronized boolean removeListener(T t) {
        WeakListener<T> weakListener;
        boolean bl = false;
        if (this.listeners != null && this.listeners.remove(t)) {
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
            bl = true;
        }
        if (this.weakListeners != null && (weakListener = this.find(t)) != null && this.weakListeners.remove(weakListener)) {
            if (this.weakListeners.isEmpty()) {
                this.weakListeners = null;
            }
            bl = true;
        }
        return bl;
    }

    private WeakListener<T> find(T t) {
        if (this.weakListeners != null) {
            for (WeakListener<T> weakListener : this.weakListeners) {
                if (weakListener.get() != t) continue;
                return weakListener;
            }
        }
        return null;
    }
}

