/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base;

import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.login.URLProviderFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

public class PrintRenderer
implements Printable {
    private JComponent component;
    private int totalNumPages = -1;
    private String headerText = null;

    public PrintRenderer(JComponent jComponent, String string) {
        this(jComponent);
        this.headerText = string;
    }

    public PrintRenderer(JComponent jComponent) {
        this.component = jComponent;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d2 = 0.0;
        int n2 = 0;
        int n3 = graphics2D.getFontMetrics().getHeight();
        int n4 = graphics2D.getFontMetrics().getDescent();
        double d3 = pageFormat.getImageableWidth();
        double d4 = d3 / (double)this.component.getWidth();
        double d5 = d = pageFormat.getImageableHeight();
        if (this.headerText != null) {
            d2 = n3 + 2 * n4;
            d5 -= d2;
        }
        d5 -= (double)(n3 + 2 * n4);
        if (this.totalNumPages == -1) {
            this.totalNumPages = this.component instanceof JTextComponent || this.component instanceof JTable ? this.getNumberOfPages(graphics, pageFormat, this.component) : (int)Math.ceil((double)this.component.getHeight() * d4 / d5);
        }
        if (n >= this.totalNumPages) {
            return 1;
        }
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.setFont(this.component.getFont());
        if (this.headerText != null) {
            n2 = graphics2D.getFontMetrics().stringWidth(this.headerText);
            graphics2D.drawString(this.headerText, (int)(d3 - (double)n2) / 2, n3 - n4);
        }
        int n5 = (int)d - n4;
        if (this.headerText != null) {
            graphics2D.drawLine(0, n3 + n4, (int)d3, n3 + n4);
        }
        graphics2D.drawLine(0, n5 - n3, (int)d3, n5 - n3);
        String string = URLProviderFactory.getProvider().getLoginInformation().getUserFullName();
        graphics2D.drawString(String.valueOf(Messages.getString("PrintRenderer.PrintedBy")) + " " + string, 0, n5);
        String string2 = DateFormat.getDateTimeInstance(3, 3).format(new Date());
        n2 = graphics2D.getFontMetrics().stringWidth(string2);
        graphics2D.drawString(string2, (int)(d3 - (double)n2) / 2, n5);
        String string3 = String.valueOf(Messages.getString("PrintRenderer.Page")) + " " + (n + 1) + " " + Messages.getString("PrintRenderer.PageOf") + " " + this.totalNumPages;
        n2 = graphics2D.getFontMetrics().stringWidth(string3);
        graphics2D.drawString(string3, (int)d3 - n2, n5);
        if (this.component instanceof JTable) {
            JTable jTable = (JTable)this.component;
            Printable printable = jTable.getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
            graphics2D.scale(1.0, d5 / pageFormat.getImageableHeight());
            graphics2D.translate(-pageFormat.getImageableX(), -pageFormat.getImageableY() + d2);
            return printable.print(graphics2D, pageFormat, n);
        }
        if (this.component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)this.component;
            Printable printable = jTextComponent.getPrintable(null, null);
            graphics2D.scale(1.0, d5 / pageFormat.getImageableHeight());
            graphics2D.translate(-pageFormat.getImageableX(), -pageFormat.getImageableY() + d2);
            return printable.print(graphics2D, pageFormat, n);
        }
        graphics2D.translate(0.0, (double)(-n) * d5 + d2);
        graphics2D.setClip(0, (int)d5 * n, (int)d3, (int)d5);
        graphics2D.scale(d4, d4);
        this.component.paint(graphics2D);
        return 0;
    }

    private int getNumberOfPages(Graphics graphics, PageFormat pageFormat, JComponent jComponent) throws PrinterException {
        Printable printable = null;
        if (jComponent instanceof JTextComponent) {
            printable = ((JTextComponent)jComponent).getPrintable(null, null);
        } else if (jComponent instanceof JTable) {
            printable = ((JTable)jComponent).getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
        } else {
            return 0;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = 0;
        int n2 = 0;
        while ((n2 = printable.print(graphics2D, pageFormat, n)) == 0) {
            ++n;
        }
        return n;
    }
}

